/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn;

import java.io.Serializable;
import net.sf.jga.fn.Generator;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.fn.Visitable;
import net.sf.jga.fn.Visitor;
import net.sf.jga.fn.adaptor.Bind1st;
import net.sf.jga.fn.adaptor.Bind2nd;
import net.sf.jga.fn.adaptor.ComposeBinary;
import net.sf.jga.fn.adaptor.ComposeUnary;
import net.sf.jga.fn.adaptor.Distribute;
import net.sf.jga.fn.adaptor.Generate1st;
import net.sf.jga.fn.adaptor.Generate2nd;
import net.sf.jga.fn.adaptor.Identity;
import net.sf.jga.parser.GenericParser;
import net.sf.jga.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BinaryFunctor<T1, T2, R>
implements Serializable,
Visitable {
    public static <Arg1Type, Arg2Type, ReturnType> BinaryFunctor<Arg1Type, Arg2Type, ReturnType> parse(String exp, Class<Arg1Type> arg1Class, Class<Arg2Type> arg2Class, Class<ReturnType> retClass) throws ParseException {
        return BinaryFunctor.parse(exp, arg1Class, arg2Class, retClass, GenericParser.getInstance());
    }

    public static <Arg1Type, Arg2Type, ReturnType> BinaryFunctor<Arg1Type, Arg2Type, ReturnType> parse(String exp, Class<Arg1Type> arg1Class, Class<Arg2Type> arg2Class, Class<ReturnType> retClass, GenericParser parser) throws ParseException {
        return parser.parseBinary(exp, arg1Class, arg2Class, retClass);
    }

    public abstract R fn(T1 var1, T2 var2);

    public UnaryFunctor<T2, R> bind1st(T1 value) {
        return new Bind1st(value, this);
    }

    public UnaryFunctor<T1, R> bind2nd(T2 value) {
        return new Bind2nd(value, this);
    }

    public Generator<R> bind(T1 value1, T2 value2) {
        return this.bind1st(value1).bind(value2);
    }

    public <F> UnaryFunctor<F, R> compose(UnaryFunctor<F, T1> g, UnaryFunctor<F, T2> h) {
        return new ComposeUnary(g, h, this);
    }

    public <F1, F2> BinaryFunctor<F1, F2, R> compose(BinaryFunctor<F1, F2, T1> g, BinaryFunctor<F1, F2, T2> h) {
        return new ComposeBinary(g, h, this);
    }

    public <F1, F2> BinaryFunctor<F1, F2, R> distribute(UnaryFunctor<F1, T1> g, UnaryFunctor<F2, T2> h) {
        if (g instanceof Identity && h instanceof Identity) {
            return this;
        }
        return new Distribute(g, h, this);
    }

    public UnaryFunctor<T2, R> generate1st(Generator<T1> gen) {
        return new Generate1st(this, gen);
    }

    public UnaryFunctor<T1, R> generate2nd(Generator<T2> gen) {
        return new Generate2nd(this, gen);
    }

    public Generator<R> generate(Generator<T1> gen1, Generator<T2> gen2) {
        return this.generate1st(gen1).generate(gen2);
    }

    @Override
    public void accept(Visitor v) {
    }
}

