/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.adaptor;

import net.sf.jga.fn.BinaryFunctor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionalBinary<T1, T2, R>
extends BinaryFunctor<T1, T2, R> {
    static final long serialVersionUID = -2682605534388798188L;
    private BinaryFunctor<T1, T2, Boolean> _test;
    private BinaryFunctor<T1, T2, R> _then;
    private BinaryFunctor<T1, T2, R> _else;

    public ConditionalBinary(BinaryFunctor<T1, T2, Boolean> test, BinaryFunctor<T1, T2, R> trueFn, BinaryFunctor<T1, T2, R> falseFn) {
        if (test == null || trueFn == null || falseFn == null) {
            throw new IllegalArgumentException("Three functors are required");
        }
        this._test = test;
        this._then = trueFn;
        this._else = falseFn;
    }

    public BinaryFunctor<T1, T2, Boolean> getCondition() {
        return this._test;
    }

    public BinaryFunctor<T1, T2, R> getTrueFunctor() {
        return this._then;
    }

    public BinaryFunctor<T1, T2, R> getFalseFunctor() {
        return this._else;
    }

    @Override
    public R fn(T1 x, T2 y) {
        return this._test.fn(x, y) != false ? this._then.fn(x, y) : this._else.fn(x, y);
    }

    @Override
    public void accept(net.sf.jga.fn.Visitor v) {
        if (v instanceof Visitor) {
            ((Visitor)v).visit(this);
        }
    }

    public String toString() {
        return "ConditionalBinary[" + this._test + "?" + this._then + ":" + this._else + "]";
    }

    public static interface Visitor
    extends net.sf.jga.fn.Visitor {
        public void visit(ConditionalBinary var1);
    }
}

