/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.adaptor;

import net.sf.jga.fn.UnaryFunctor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionalUnary<T, R>
extends UnaryFunctor<T, R> {
    static final long serialVersionUID = -8509676654602764401L;
    private UnaryFunctor<T, Boolean> _test;
    private UnaryFunctor<T, R> _then;
    private UnaryFunctor<T, R> _else;

    public ConditionalUnary(UnaryFunctor<T, Boolean> test, UnaryFunctor<T, R> trueFn, UnaryFunctor<T, R> falseFn) {
        if (test == null || trueFn == null || falseFn == null) {
            throw new IllegalArgumentException("Three functors are required");
        }
        this._test = test;
        this._then = trueFn;
        this._else = falseFn;
    }

    public UnaryFunctor<T, Boolean> getCondition() {
        return this._test;
    }

    public UnaryFunctor<T, R> getTrueFunctor() {
        return this._then;
    }

    public UnaryFunctor<T, R> getFalseFunctor() {
        return this._else;
    }

    @Override
    public R fn(T x) {
        return this._test.fn(x) != false ? this._then.fn(x) : this._else.fn(x);
    }

    @Override
    public void accept(net.sf.jga.fn.Visitor v) {
        if (v instanceof Visitor) {
            ((Visitor)v).visit(this);
        }
    }

    public String toString() {
        return "ConditionalUnary[" + this._test + "?" + this._then + ":" + this._else + "]";
    }

    public static interface Visitor
    extends net.sf.jga.fn.Visitor {
        public void visit(ConditionalUnary var1);
    }
}

