/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.algorithm;

import java.util.Iterator;
import net.sf.jga.fn.BinaryFunctor;
import net.sf.jga.fn.UnaryFunctor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Accumulate<T>
extends UnaryFunctor<Iterator<? extends T>, T> {
    static final long serialVersionUID = 4611344190624502921L;
    private BinaryFunctor<T, T, T> _fn;
    private T _value;
    private boolean _givenValue = false;

    public Accumulate(BinaryFunctor<T, T, T> fn) {
        if (fn == null) {
            throw new IllegalArgumentException();
        }
        this._fn = fn;
    }

    public Accumulate(T startValue, BinaryFunctor<T, T, T> fn) {
        this(fn);
        this._value = startValue;
        this._givenValue = true;
    }

    public BinaryFunctor<T, T, T> getFunction() {
        return this._fn;
    }

    public T getStartValue() {
        return this._value;
    }

    public boolean hasStartValue() {
        return this._givenValue;
    }

    @Override
    public T fn(Iterator<? extends T> iterator) {
        T value;
        Object object = this._givenValue ? this._value : (value = iterator.hasNext() ? iterator.next() : null);
        while (iterator.hasNext()) {
            value = this._fn.fn(value, iterator.next());
        }
        return value;
    }

    @Override
    public void accept(net.sf.jga.fn.Visitor v) {
        if (v instanceof Visitor) {
            ((Visitor)v).visit(this);
        }
    }

    public String toString() {
        return "Accumulate";
    }

    public static interface Visitor
    extends net.sf.jga.fn.Visitor {
        public void visit(Accumulate var1);
    }
}

