/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.algorithm;

import java.util.Collection;
import net.sf.jga.fn.BinaryFunctor;
import net.sf.jga.fn.BinaryPredicate;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.util.FindIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementOf<T>
extends BinaryPredicate<T, Collection<? extends T>> {
    static final long serialVersionUID = 4639100512962835854L;
    private BinaryFunctor<T, T, Boolean> _eq;

    public ElementOf() {
    }

    public ElementOf(BinaryFunctor<T, T, Boolean> eq) {
        this._eq = eq;
    }

    public BinaryFunctor<T, T, Boolean> getComparisonFn() {
        return this._eq;
    }

    @Override
    public Boolean fn(T value, Collection<? extends T> collection) {
        if (this._eq == null) {
            return collection.contains(value);
        }
        FindIterator<T> finder = new FindIterator<T>(collection.iterator());
        UnaryFunctor<T, Boolean> uf = this._eq.bind2nd(value);
        return finder.findNext(uf);
    }

    @Override
    public void accept(net.sf.jga.fn.Visitor v) {
        if (v instanceof Visitor) {
            ((Visitor)v).visit(this);
        }
    }

    public String toString() {
        return "ElementOf";
    }

    public static interface Visitor
    extends net.sf.jga.fn.Visitor {
        public void visit(ElementOf var1);
    }
}

