/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.algorithm;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import net.sf.jga.fn.BinaryFunctor;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.fn.algorithm.ElementOf;
import net.sf.jga.fn.algorithm.FindIteratorFunctor;
import net.sf.jga.util.FindIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindElement<T>
extends FindIteratorFunctor<T> {
    static final long serialVersionUID = -1746637029942790280L;
    private BinaryFunctor<T, T, Boolean> _bf;
    private UnaryFunctor<T, Boolean> _uf;
    private Collection<? extends T> _elements;

    public FindElement(Collection<? extends T> elements) {
        this._elements = elements == null ? new Vector() : elements;
        this._uf = new ElementOf().bind2nd(elements);
    }

    public FindElement(Collection<? extends T> elements, BinaryFunctor<T, T, Boolean> eq) {
        this._bf = eq;
        this._elements = elements == null ? new Vector() : elements;
        this._uf = new ElementOf<T>(eq).bind2nd(elements);
    }

    public Collection<? extends T> getElementSet() {
        return Collections.unmodifiableCollection(this._elements);
    }

    public BinaryFunctor<T, T, Boolean> getComparisonFn() {
        return this._bf;
    }

    @Override
    public FindIterator<T> fn(Iterator<? extends T> iterator) {
        FindIterator<T> finder = this.wrap(iterator);
        finder.findNext(this._uf);
        return finder;
    }

    @Override
    public void accept(net.sf.jga.fn.Visitor v) {
        if (v instanceof Visitor) {
            ((Visitor)v).visit(this);
        }
    }

    public String toString() {
        return "FindElement";
    }

    public static interface Visitor
    extends net.sf.jga.fn.Visitor {
        public void visit(FindElement var1);
    }
}

