/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.algorithm;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import net.sf.jga.fn.BinaryFunctor;
import net.sf.jga.fn.algorithm.LookAheadFunctor;
import net.sf.jga.fn.comparison.NotEqualTo;
import net.sf.jga.util.EmptyIterator;
import net.sf.jga.util.LookAheadIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindMismatch<T>
extends LookAheadFunctor<T> {
    static final long serialVersionUID = -5406536818520367561L;
    private Collection<? extends T> _elements;
    private BinaryFunctor<T, T, Boolean> _bf;
    private LookAheadIterator<T> _elemIter;
    private T _mismatch;

    public FindMismatch(Collection<? extends T> elements) {
        this(elements, new NotEqualTo());
    }

    public FindMismatch(Collection<? extends T> elements, BinaryFunctor<T, T, Boolean> neq) {
        this._elements = elements == null ? new Vector() : elements;
        this._bf = neq;
    }

    public FindMismatch(Iterator<? extends T> iter, BinaryFunctor<T, T, Boolean> neq) {
        if (iter == null) {
            iter = new EmptyIterator<T>();
        }
        this._elemIter = new LookAheadIterator<T>(iter);
        this._bf = neq;
    }

    public Collection<? extends T> getElements() {
        return this._elements == null ? null : Collections.unmodifiableCollection(this._elements);
    }

    public BinaryFunctor<T, T, Boolean> getComparisonFn() {
        return this._bf;
    }

    public T getMismatchedElement() {
        if (this._elemIter == null) {
            throw new IllegalStateException();
        }
        return this._mismatch;
    }

    @Override
    public LookAheadIterator<T> fn(Iterator<? extends T> iterator) {
        if (this._elemIter == null) {
            this._elemIter = new LookAheadIterator<T>(this._elements.iterator());
        }
        LookAheadIterator<T> lai = this.wrap(iterator, 1);
        while (lai.hasNextPlus(1) && this._elemIter.hasNextPlus(1)) {
            T arg2;
            T arg1 = lai.peek(1);
            if (this._bf.fn(arg1, arg2 = this._elemIter.peek(1)).booleanValue()) {
                this._mismatch = this._elemIter.next();
                return lai;
            }
            lai.next();
            this._elemIter.next();
        }
        return lai;
    }

    @Override
    public void accept(net.sf.jga.fn.Visitor v) {
        if (v instanceof Visitor) {
            ((Visitor)v).visit(this);
        }
    }

    public String toString() {
        return "FindMismatch";
    }

    public static interface Visitor
    extends net.sf.jga.fn.Visitor {
        public void visit(FindMismatch var1);
    }
}

