/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.algorithm;

import java.util.Iterator;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.fn.algorithm.LookAheadFunctor;
import net.sf.jga.fn.comparison.EqualTo;
import net.sf.jga.fn.comparison.Equality;
import net.sf.jga.util.EmptyIterator;
import net.sf.jga.util.LookAheadIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindRepeated<T>
extends LookAheadFunctor<T> {
    static final long serialVersionUID = 2382887791885942503L;
    private int _repeatCount;
    private UnaryFunctor<T, Boolean> _eq;

    public FindRepeated(int count, T value) {
        this(count, new EqualTo().bind2nd(value));
    }

    public FindRepeated(int count, T value, Equality<T> eq) {
        this(count, eq.bind2nd(value));
    }

    public FindRepeated(int count, UnaryFunctor<T, Boolean> eq) {
        if (count < 0) {
            throw new IllegalArgumentException("count < 0");
        }
        this._repeatCount = count;
        this._eq = eq;
    }

    public int getRunLength() {
        return this._repeatCount;
    }

    public UnaryFunctor<T, Boolean> getComparisonFn() {
        return this._eq;
    }

    @Override
    public LookAheadIterator<T> fn(Iterator<? extends T> iterator) {
        if (!iterator.hasNext() || this._repeatCount == 0) {
            return new LookAheadIterator<T>(iterator, 1);
        }
        LookAheadIterator<T> lai = this.wrap(iterator, this._repeatCount);
        block0: while (lai.hasNextPlus(this._repeatCount)) {
            for (int i = 1; i <= this._repeatCount; ++i) {
                T arg = lai.peek(i);
                if (this._eq.fn(arg).booleanValue()) continue;
                for (int j = i; j > 0; --j) {
                    lai.next();
                }
                continue block0;
            }
            return lai;
        }
        return new LookAheadIterator(new EmptyIterator(), 1);
    }

    @Override
    public void accept(net.sf.jga.fn.Visitor v) {
        if (v instanceof Visitor) {
            ((Visitor)v).visit(this);
        }
    }

    public String toString() {
        return "FindRepeated[" + this._eq + "]";
    }

    public static interface Visitor
    extends net.sf.jga.fn.Visitor {
        public void visit(FindRepeated var1);
    }
}

