/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.algorithm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import net.sf.jga.fn.BinaryFunctor;
import net.sf.jga.fn.algorithm.LookAheadFunctor;
import net.sf.jga.fn.comparison.EqualTo;
import net.sf.jga.util.EmptyIterator;
import net.sf.jga.util.LookAheadIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindSequence<T>
extends LookAheadFunctor<T> {
    static final long serialVersionUID = 5277671793270812331L;
    private Collection<? extends T> _pattern;
    private BinaryFunctor<T, T, Boolean> _eq;
    private int _length;

    public FindSequence(Collection<? extends T> pattern) {
        this(pattern, new EqualTo());
    }

    public FindSequence(Collection<? extends T> pattern, BinaryFunctor<T, T, Boolean> eq) {
        if (eq == null) {
            throw new IllegalArgumentException();
        }
        this._eq = eq;
        this._pattern = pattern != null ? pattern : new ArrayList();
        this._length = Math.max(pattern.size(), 1);
    }

    public Collection<? extends T> getPattern() {
        return Collections.unmodifiableCollection(this._pattern);
    }

    public BinaryFunctor<T, T, Boolean> getComparisonFn() {
        return this._eq;
    }

    @Override
    public LookAheadIterator<T> fn(Iterator<? extends T> iterator) {
        if (!iterator.hasNext() || this._length == 0) {
            return this.wrap(iterator, 1);
        }
        LookAheadIterator<T> lai = this.wrap(iterator, this._length);
        block0: while (lai.hasNextPlus(this._length)) {
            int idx = 1;
            for (T obj : this._pattern) {
                if (!this._eq.fn(obj, lai.peek(idx)).booleanValue()) {
                    lai.next();
                    continue block0;
                }
                ++idx;
            }
            return lai;
        }
        return new LookAheadIterator(new EmptyIterator(), 1);
    }

    @Override
    public void accept(net.sf.jga.fn.Visitor v) {
        if (v instanceof Visitor) {
            ((Visitor)v).visit(this);
        }
    }

    public String toString() {
        return "FindSequence";
    }

    public static interface Visitor
    extends net.sf.jga.fn.Visitor {
        public void visit(FindSequence var1);
    }
}

