/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.arithmetic;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import net.sf.jga.fn.arithmetic.Arithmetic;
import net.sf.jga.fn.arithmetic.BigIntMath;
import net.sf.jga.fn.arithmetic.ByteMath;
import net.sf.jga.fn.arithmetic.DecimalMath;
import net.sf.jga.fn.arithmetic.DoubleMath;
import net.sf.jga.fn.arithmetic.FloatMath;
import net.sf.jga.fn.arithmetic.IntegerArithmetic;
import net.sf.jga.fn.arithmetic.IntegerMath;
import net.sf.jga.fn.arithmetic.LongMath;
import net.sf.jga.fn.arithmetic.ShortMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArithmeticFactory {
    private static HashMap<Class<? extends Number>, Arithmetic<? extends Number>> _arithmeticMap = new HashMap();
    private static HashMap<Class<? extends Number>, IntegerArithmetic<? extends Number>> _integralMap = new HashMap();

    public static <T extends Number> void register(Class<T> c, Arithmetic<T> math) {
        _arithmeticMap.put(c, math);
    }

    public static <T extends Number> void register(Class<T> c, IntegerArithmetic<T> math) {
        _arithmeticMap.put(c, math);
        _integralMap.put(c, math);
    }

    public static <T extends Number> Arithmetic<T> getArithmetic(Class<T> c) {
        return _arithmeticMap.get(c);
    }

    public static <T extends Number> IntegerArithmetic<T> getIntegralArithmetic(Class<T> c) {
        return _integralMap.get(c);
    }

    static {
        ArithmeticFactory.register(Byte.class, new ByteMath());
        ArithmeticFactory.register(Short.class, new ShortMath());
        ArithmeticFactory.register(Integer.class, new IntegerMath());
        ArithmeticFactory.register(Long.class, new LongMath());
        ArithmeticFactory.register(Float.class, new FloatMath());
        ArithmeticFactory.register(Double.class, new DoubleMath());
        ArithmeticFactory.register(BigDecimal.class, new DecimalMath());
        ArithmeticFactory.register(BigInteger.class, new BigIntMath());
    }
}

