/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.arithmetic;

import java.text.MessageFormat;
import java.util.Iterator;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.fn.arithmetic.Arithmetic;
import net.sf.jga.fn.arithmetic.ArithmeticFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Average<T extends Number>
extends UnaryFunctor<Iterator<T>, T> {
    private Arithmetic<T> _math;

    public Average(Class<T> type) {
        this._math = ArithmeticFactory.getArithmetic(type);
        if (this._math == null) {
            String msg = "No implementation of Arithmetic registered for {0}";
            throw new IllegalArgumentException(MessageFormat.format(msg, type));
        }
    }

    @Override
    public T fn(Iterator<T> iterator) {
        int count = 0;
        Object sum = this._math.zero();
        while (iterator.hasNext()) {
            Number value = (Number)iterator.next();
            sum = this._math.plus((Number)sum, value);
            ++count;
        }
        return this._math.divides(sum, this._math.valueOf(count));
    }

    @Override
    public void accept(net.sf.jga.fn.Visitor v) {
        if (v instanceof Visitor) {
            ((Visitor)v).visit(this);
        }
    }

    public String toString() {
        return "Average[]";
    }

    public static interface Visitor
    extends net.sf.jga.fn.Visitor {
        public void visit(Average var1);
    }
}

