/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.arithmetic;

import java.text.MessageFormat;
import net.sf.jga.fn.EvaluationException;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.fn.arithmetic.ArithmeticFactory;
import net.sf.jga.fn.arithmetic.IntegerArithmetic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitwiseNot<T extends Number>
extends UnaryFunctor<T, T> {
    static final long serialVersionUID = 9034926672034158292L;
    private IntegerArithmetic<T> _math;

    public BitwiseNot(Class<T> c) {
        this._math = ArithmeticFactory.getIntegralArithmetic(c);
        if (this._math == null) {
            String msg = "No implementation of IntegerArithmetic registered for {0}";
            throw new IllegalArgumentException(MessageFormat.format(msg, c));
        }
    }

    @Override
    public T fn(T x) {
        try {
            return this._math.not(x);
        }
        catch (ClassCastException ex) {
            String msg = "ClassCastException: Cannot compute ~{0}[{1}]";
            String err = MessageFormat.format(msg, x.getClass(), x);
            throw new EvaluationException(err, ex);
        }
    }

    @Override
    public void accept(net.sf.jga.fn.Visitor v) {
        if (v instanceof Visitor) {
            ((Visitor)v).visit(this);
        }
    }

    public String toString() {
        return "BitwiseNot";
    }

    public static interface Visitor
    extends net.sf.jga.fn.Visitor {
        public void visit(BitwiseNot var1);
    }
}

