/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.arithmetic;

import java.text.MessageFormat;
import net.sf.jga.fn.BinaryFunctor;
import net.sf.jga.fn.EvaluationException;
import net.sf.jga.fn.arithmetic.ArithmeticFactory;
import net.sf.jga.fn.arithmetic.IntegerArithmetic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitwiseXor<T extends Number>
extends BinaryFunctor<T, T, T> {
    static final long serialVersionUID = 5855300269271261789L;
    private IntegerArithmetic<T> _math;

    public BitwiseXor(Class<T> c) {
        this._math = ArithmeticFactory.getIntegralArithmetic(c);
        if (this._math == null) {
            String msg = "No implementation of IntegerArithmetic registered for {0}";
            throw new IllegalArgumentException(MessageFormat.format(msg, c));
        }
    }

    @Override
    public T fn(T x, T y) {
        try {
            return this._math.xor(x, y);
        }
        catch (ClassCastException ex) {
            String msg = "ClassCastException: Cannot compute {0}[{1}] | {2}[{3}]";
            String err = MessageFormat.format(msg, x.getClass(), x, y.getClass(), y);
            throw new EvaluationException(err, ex);
        }
    }

    @Override
    public void accept(net.sf.jga.fn.Visitor v) {
        if (v instanceof Visitor) {
            ((Visitor)v).visit(this);
        }
    }

    public String toString() {
        return "BitwiseXor";
    }

    public static interface Visitor
    extends net.sf.jga.fn.Visitor {
        public void visit(BitwiseXor var1);
    }
}

