/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.arithmetic;

import java.math.BigDecimal;
import net.sf.jga.fn.arithmetic.Arithmetic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DecimalMath
implements Arithmetic<BigDecimal> {
    static final long serialVersionUID = 2565703485705053014L;
    private static final BigDecimal ZERO = new BigDecimal(0.0);
    private static final BigDecimal ONE = new BigDecimal(1.0);

    DecimalMath() {
    }

    @Override
    public BigDecimal valueOf(Number value) throws IllegalArgumentException {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return new BigDecimal(value.toString());
    }

    @Override
    public BigDecimal zero() {
        return ZERO;
    }

    @Override
    public BigDecimal one() {
        return ONE;
    }

    @Override
    public BigDecimal plus(BigDecimal x, BigDecimal y) {
        return x.add(y);
    }

    @Override
    public BigDecimal minus(BigDecimal x, BigDecimal y) {
        return x.subtract(y);
    }

    @Override
    public BigDecimal multiplies(BigDecimal x, BigDecimal y) {
        return x.multiply(y);
    }

    @Override
    public BigDecimal divides(BigDecimal x, BigDecimal y) {
        return x.divide(y, 4);
    }

    @Override
    public BigDecimal negate(BigDecimal x) {
        return x.negate();
    }
}

