/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.arithmetic;

import java.text.MessageFormat;
import net.sf.jga.fn.BinaryFunctor;
import net.sf.jga.fn.EvaluationException;
import net.sf.jga.fn.arithmetic.Arithmetic;
import net.sf.jga.fn.arithmetic.ArithmeticFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Divides<T extends Number>
extends BinaryFunctor<T, T, T> {
    static final long serialVersionUID = 6203872808362432020L;
    private Arithmetic<T> _math;

    public Divides(Class<T> c) {
        this._math = ArithmeticFactory.getArithmetic(c);
        if (this._math == null) {
            String msg = "No implementation of Arithmetic registered for {0}";
            throw new IllegalArgumentException(MessageFormat.format(msg, c));
        }
    }

    @Override
    public T fn(T x, T y) {
        try {
            return this._math.divides(x, y);
        }
        catch (ClassCastException ex) {
            String msg = "ClassCastException: Cannot divide {0}[{1}] by {2}[{3}]";
            String err = MessageFormat.format(msg, x.getClass(), x, y.getClass(), y);
            throw new EvaluationException(err, ex);
        }
    }

    @Override
    public void accept(net.sf.jga.fn.Visitor v) {
        if (v instanceof Visitor) {
            ((Visitor)v).visit(this);
        }
    }

    public String toString() {
        return "Divides";
    }

    public static interface Visitor
    extends net.sf.jga.fn.Visitor {
        public void visit(Divides var1);
    }
}

