/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.arithmetic;

import net.sf.jga.fn.arithmetic.Arithmetic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FloatMath
implements Arithmetic<Float> {
    static final long serialVersionUID = 8813677408947677131L;
    private static final Float ZERO = new Float(0.0f);
    private static final Float ONE = new Float(1.0f);

    FloatMath() {
    }

    @Override
    public Float valueOf(Number value) throws IllegalArgumentException {
        return new Float(value.floatValue());
    }

    @Override
    public Float zero() {
        return ZERO;
    }

    @Override
    public Float one() {
        return ONE;
    }

    @Override
    public Float plus(Float x, Float y) {
        return new Float(x.floatValue() + y.floatValue());
    }

    @Override
    public Float minus(Float x, Float y) {
        return new Float(x.floatValue() - y.floatValue());
    }

    @Override
    public Float multiplies(Float x, Float y) {
        return new Float(x.floatValue() * y.floatValue());
    }

    @Override
    public Float divides(Float x, Float y) {
        return new Float(x.floatValue() / y.floatValue());
    }

    @Override
    public Float negate(Float x) {
        return new Float(-x.floatValue());
    }
}

