/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.arithmetic;

import net.sf.jga.fn.arithmetic.IntegerArithmetic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LongMath
implements IntegerArithmetic<Long> {
    static final long serialVersionUID = 7284047144544492350L;
    private static final Long ZERO = new Long(0L);
    private static final Long ONE = new Long(1L);

    LongMath() {
    }

    @Override
    public Long valueOf(Number value) throws IllegalArgumentException {
        return new Long(value.longValue());
    }

    @Override
    public Long zero() {
        return ZERO;
    }

    @Override
    public Long one() {
        return ONE;
    }

    @Override
    public Long plus(Long x, Long y) {
        return new Long(x + y);
    }

    @Override
    public Long minus(Long x, Long y) {
        return new Long(x - y);
    }

    @Override
    public Long multiplies(Long x, Long y) {
        return new Long(x * y);
    }

    @Override
    public Long divides(Long x, Long y) {
        return new Long(x / y);
    }

    @Override
    public Long negate(Long x) {
        return new Long(-x.longValue());
    }

    @Override
    public Long modulus(Long x, Long y) {
        return new Long(x % y);
    }

    @Override
    public Long and(Long x, Long y) {
        return new Long(x & y);
    }

    @Override
    public Long or(Long x, Long y) {
        return new Long(x | y);
    }

    @Override
    public Long xor(Long x, Long y) {
        return new Long(x ^ y);
    }

    @Override
    public Long not(Long x) {
        return new Long((long)(x ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public Long shiftLeft(Long x, Integer y) {
        return new Long(x << y);
    }

    @Override
    public Long signedShiftRight(Long x, Integer y) {
        return new Long(x >> y);
    }

    @Override
    public Long unsignedShiftRight(Long x, Integer y) {
        return new Long(x >>> y);
    }
}

