/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.comparison;

import java.util.Comparator;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.fn.UnaryPredicate;
import net.sf.jga.fn.comparison.GreaterEqual;
import net.sf.jga.fn.comparison.LessEqual;
import net.sf.jga.util.ComparableComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Between<T>
extends UnaryPredicate<T> {
    static final long serialVersionUID = 7520704443234013748L;
    private UnaryFunctor<T, Boolean> _ge;
    private UnaryFunctor<T, Boolean> _le;

    public Between(T lo, T hi, Comparator<? super T> comp) {
        if (lo == null || hi == null) {
            String msg = "a pair of values is required";
            throw new IllegalArgumentException(msg);
        }
        if (comp.compare(lo, hi) > 0) {
            String msg = "lo value must be less than hi value";
            throw new IllegalArgumentException(msg);
        }
        this._ge = new GreaterEqual<T>(comp).bind2nd(lo);
        this._le = new LessEqual<T>(comp).bind2nd(hi);
    }

    public Between(UnaryFunctor<T, Boolean> lo, UnaryFunctor<T, Boolean> hi) {
        if (lo == null || hi == null) {
            String msg = "a pair of predicates is required";
            throw new IllegalArgumentException(msg);
        }
        this._ge = lo;
        this._le = hi;
    }

    @Override
    public Boolean fn(T x) {
        return this._ge.fn(x) != false && this._le.fn(x) != false;
    }

    @Override
    public void accept(net.sf.jga.fn.Visitor v) {
        if (v instanceof Visitor) {
            ((Visitor)v).visit(this);
        }
    }

    public String toString() {
        return "Between";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Comparable<T extends java.lang.Comparable<? super T>>
    extends Between<T> {
        static final long serialVersionUID = 4385771596777515479L;

        public Comparable(T lo, T hi) {
            super(lo, hi, new ComparableComparator());
        }
    }

    public static interface Visitor
    extends net.sf.jga.fn.Visitor {
        public void visit(Between var1);
    }
}

