/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.property;

import java.text.MessageFormat;
import net.sf.jga.fn.UnaryFunctor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cast<R>
extends UnaryFunctor<Object, R> {
    static final long serialVersionUID = 2712605844695159349L;
    private Class<R> _class;

    public Cast(Class<R> cl) {
        if (cl == null) {
            throw new IllegalArgumentException("A class must be given");
        }
        this._class = cl;
    }

    public Class<R> getCastClass() {
        return this._class;
    }

    @Override
    public R fn(Object arg) {
        if (this._class.isInstance(arg)) {
            return (R)arg;
        }
        String msg = "Cannot cast [{0}] to class {1}";
        Object[] args = new Object[]{arg, this._class.getName()};
        ClassCastException x = new ClassCastException(MessageFormat.format(msg, args));
        throw x;
    }

    @Override
    public void accept(net.sf.jga.fn.Visitor v) {
        if (v instanceof Visitor) {
            ((Visitor)v).visit(this);
        }
    }

    public String toString() {
        return "Cast[" + this._class.getName() + "]";
    }

    public static interface Visitor
    extends net.sf.jga.fn.Visitor {
        public void visit(Cast var1);
    }
}

