/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.property;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.sf.jga.fn.EvaluationException;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Construct<R>
extends UnaryFunctor<Object[], R> {
    static final long serialVersionUID = -4682718030847292345L;
    private Class<R> _objclass;
    private Class[] _argclasses;
    private transient Constructor<R> _ctor;

    public Construct(Class[] argclasses, Class<R> ctorclass) {
        if (argclasses == null) {
            String msg = "Argument Classes must be specified";
            throw new IllegalArgumentException(msg);
        }
        if (ctorclass == null) {
            String msg = "Class to be constructed must be specified";
            throw new IllegalArgumentException(msg);
        }
        this._objclass = ctorclass;
        this._argclasses = argclasses;
        try {
            this._ctor = ctorclass.getConstructor(argclasses);
        }
        catch (NoSuchMethodException x) {
            IllegalArgumentException x1 = new IllegalArgumentException();
            x1.initCause(x);
            throw x1;
        }
    }

    public Construct(Constructor<R> ctor) {
        if (ctor == null) {
            String msg = "constructor must be specified";
            throw new IllegalArgumentException(msg);
        }
        this._ctor = ctor;
        this._objclass = ctor.getDeclaringClass();
        this._argclasses = ctor.getParameterTypes();
    }

    @Override
    public R fn(Object[] args) {
        try {
            return this.getConstructor().newInstance(args);
        }
        catch (NoSuchMethodException x) {
            throw new EvaluationException(x);
        }
        catch (InstantiationException x) {
            throw new EvaluationException(x);
        }
        catch (IllegalAccessException x) {
            throw new EvaluationException(x);
        }
        catch (InvocationTargetException x) {
            throw new EvaluationException(x);
        }
    }

    private Constructor<R> getConstructor() throws NoSuchMethodException {
        if (this._ctor == null) {
            this._ctor = this._objclass.getConstructor(this._argclasses);
        }
        return this._ctor;
    }

    @Override
    public void accept(net.sf.jga.fn.Visitor v) {
        if (v instanceof Visitor) {
            ((Visitor)v).visit(this);
        }
    }

    public String toString() {
        return "Construct(" + this._objclass.getName() + ".getConstructor(" + Arrays.toString(this._argclasses) + "))";
    }

    public static interface Visitor
    extends net.sf.jga.fn.Visitor {
        public void visit(Construct var1);
    }
}

