/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.property;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import net.sf.jga.fn.EvaluationException;
import net.sf.jga.fn.Generator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructDefault<R>
extends Generator<R> {
    static final long serialVersionUID = 9150185598879755334L;
    private Class<R> _objclass;
    private transient Constructor<R> _ctor;

    public ConstructDefault(Class<R> ctorclass) {
        if (ctorclass == null) {
            String msg = "Class to be constructed must be specified";
            throw new IllegalArgumentException(msg);
        }
        Class[] argclasses = new Class[]{};
        this._objclass = ctorclass;
        try {
            this._ctor = ctorclass.getConstructor(argclasses);
        }
        catch (NoSuchMethodException x) {
            IllegalArgumentException x1 = new IllegalArgumentException();
            x1.initCause(x);
            throw x1;
        }
    }

    @Override
    public R gen() {
        try {
            R val = this.getConstructor().newInstance(new Object[0]);
            return val;
        }
        catch (NoSuchMethodException x) {
            String msg = "No default constructor for class {0}";
            Object[] args = new Object[]{this._objclass.getName()};
            throw new EvaluationException(MessageFormat.format(msg, args), x);
        }
        catch (InstantiationException x) {
            String msg = "class {0} is abstract: cannot be constructed";
            Object[] args = new Object[]{this._objclass.getName()};
            throw new EvaluationException(MessageFormat.format(msg, args), x);
        }
        catch (IllegalAccessException x) {
            String msg = "default ctor in class {0} is not accessible";
            Object[] args = new Object[]{this._objclass.getName()};
            throw new EvaluationException(MessageFormat.format(msg, args), x);
        }
        catch (InvocationTargetException x) {
            String msg = "default ctor in class {0} failed: " + x.getMessage();
            Object[] args = new Object[]{this._objclass.getName()};
            throw new EvaluationException(MessageFormat.format(msg, args), x);
        }
    }

    private Constructor<R> getConstructor() throws NoSuchMethodException {
        if (this._ctor == null) {
            this._ctor = this._objclass.getConstructor(new Class[0]);
        }
        return this._ctor;
    }

    @Override
    public void accept(net.sf.jga.fn.Visitor v) {
        if (v instanceof Visitor) {
            ((Visitor)v).visit(this);
        }
    }

    public String toString() {
        return "new " + this._objclass.getName() + "()";
    }

    public static interface Visitor
    extends net.sf.jga.fn.Visitor {
        public void visit(ConstructDefault var1);
    }
}

