/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.property;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import net.sf.jga.fn.EvaluationException;
import net.sf.jga.fn.UnaryFunctor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructUnary<T, R>
extends UnaryFunctor<T, R> {
    static final long serialVersionUID = -6046849006655934333L;
    private Class<T> _argclass;
    private Class<R> _ctorclass;
    private transient Constructor<R> _ctor;

    public ConstructUnary(Class<T> argclass, Class<R> ctorclass) {
        if (argclass == null) {
            String msg = "Argument Class must be specified";
            throw new IllegalArgumentException(msg);
        }
        if (ctorclass == null) {
            String msg = "Class to be constructed must be specified";
            throw new IllegalArgumentException(msg);
        }
        try {
            this._argclass = argclass;
            this._ctorclass = ctorclass;
            this._ctor = this.getConstructor();
        }
        catch (NoSuchMethodException x) {
            String msg = "No constructor found for class {0} that takes an argument of class {1}";
            Object[] args = new Object[]{ctorclass, argclass};
            IllegalArgumentException x1 = new IllegalArgumentException(MessageFormat.format(msg, args));
            x1.initCause(x);
            throw x1;
        }
    }

    @Override
    public R fn(T arg) {
        try {
            R val = this.getConstructor().newInstance(arg);
            return val;
        }
        catch (NoSuchMethodException x) {
            String msg = "No constructor for class {0} that takes an argument of type {1}";
            Object[] args = new Object[]{this._ctorclass.getName(), this._argclass.getName()};
            throw new EvaluationException(MessageFormat.format(msg, args), x);
        }
        catch (InstantiationException x) {
            String msg = "class {0} is abstract: cannot be constructed";
            Object[] args = new Object[]{this._ctorclass.getName()};
            throw new EvaluationException(MessageFormat.format(msg, args), x);
        }
        catch (IllegalArgumentException x) {
            String msg = "class {0} ctor({1}) cannot be called with {2}";
            Object[] args = new Object[]{this._ctorclass.getName(), this._argclass.getName(), arg};
            throw new EvaluationException(MessageFormat.format(msg, args), x);
        }
        catch (IllegalAccessException x) {
            String msg = "class {0} ctor({1}) is not accessible";
            Object[] args = new Object[]{this._ctorclass.getName(), this._argclass.getName()};
            throw new EvaluationException(MessageFormat.format(msg, args), x);
        }
        catch (InvocationTargetException x) {
            String msg = "class {0} ctor({1}) failed: " + x.getMessage();
            Object[] args = new Object[]{this._ctorclass.getName(), this._argclass.getName()};
            throw new EvaluationException(MessageFormat.format(msg, args), x);
        }
    }

    private Constructor<R> getConstructor() throws NoSuchMethodException {
        if (this._ctor == null) {
            this._ctor = this._ctorclass.getConstructor(this._argclass);
        }
        return this._ctor;
    }

    @Override
    public void accept(net.sf.jga.fn.Visitor v) {
        if (v instanceof Visitor) {
            ((Visitor)v).visit(this);
        }
    }

    public String toString() {
        return "new " + this._ctorclass.getName() + "([" + this._argclass.getName() + "])";
    }

    public static interface Visitor
    extends net.sf.jga.fn.Visitor {
        public void visit(ConstructUnary var1);
    }
}

