/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.property;

import java.lang.reflect.Field;
import java.text.MessageFormat;
import net.sf.jga.fn.EvaluationException;
import net.sf.jga.fn.UnaryFunctor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetField<T, R>
extends UnaryFunctor<T, R> {
    static final long serialVersionUID = 5733484457689881481L;
    private String _fieldName;
    private Class<T> _argtype;
    private transient Field _field;

    public GetField(Class<T> argclass, Field field) {
        if (field == null) {
            throw new IllegalArgumentException("Must supply field");
        }
        if (!field.getDeclaringClass().isAssignableFrom(argclass)) {
            throw new IllegalArgumentException(this.buildNoSuchFieldMessage(field.getName(), argclass));
        }
        this._field = field;
        this._fieldName = field.getName();
        this._argtype = argclass;
    }

    public GetField(Class<T> argclass, String fieldName) {
        if (fieldName == null || fieldName.length() == 0) {
            throw new IllegalArgumentException("Must supply field name");
        }
        this._fieldName = fieldName;
        this._argtype = argclass;
        try {
            this._field = argclass.getField(this._fieldName);
        }
        catch (NoSuchFieldException x) {
            IllegalArgumentException iax = new IllegalArgumentException(this.buildNoSuchFieldMessage(fieldName, argclass));
            iax.initCause(x);
            throw iax;
        }
    }

    public String getFieldName() {
        return this._fieldName;
    }

    public Class<R> getFieldType() {
        return this._field.getType();
    }

    @Override
    public R fn(T arg) {
        try {
            Object val = this.getField().get(arg);
            return (R)val;
        }
        catch (ClassCastException x) {
            String msg = "{0}.{1} is of type {2}";
            Field f = this.getField();
            Object[] args = new Object[]{arg.getClass().getName(), f.getName(), f.getType().getName()};
            throw new EvaluationException(MessageFormat.format(msg, args), x);
        }
        catch (IllegalAccessException x) {
            String msg = "{0}.{1} is not accessible";
            Object[] args = new Object[]{this._argtype.getName(), this.getField().getName()};
            throw new EvaluationException(MessageFormat.format(msg, args), x);
        }
    }

    private Field getField() {
        if (this._field == null) {
            try {
                this._field = this._argtype.getField(this._fieldName);
            }
            catch (NoSuchFieldException x) {
                throw new EvaluationException(this.buildNoSuchFieldMessage(this._fieldName, this._argtype));
            }
        }
        return this._field;
    }

    private String buildNoSuchFieldMessage(String fieldname, Class clasz) {
        String msg = "class {0} does not have field {1}";
        Object[] args = new Object[]{clasz.getName(), fieldname};
        return MessageFormat.format(msg, args);
    }

    @Override
    public void accept(net.sf.jga.fn.Visitor v) {
        if (v instanceof Visitor) {
            ((Visitor)v).visit(this);
        }
    }

    public String toString() {
        return "GetField[" + this._fieldName + "]";
    }

    public static interface Visitor
    extends net.sf.jga.fn.Visitor {
        public void visit(GetField var1);
    }
}

