/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.property;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import net.sf.jga.fn.EvaluationException;
import net.sf.jga.fn.UnaryFunctor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetProperty<T, R>
extends UnaryFunctor<T, R> {
    static final long serialVersionUID = -6249123644692001840L;
    private String _propName;
    private String _methName;
    private Class<T> _argtype;
    private transient Method _meth;

    public GetProperty(Class<T> argclass, String propName) {
        if (propName == null || propName.length() == 0) {
            throw new IllegalArgumentException("Must supply property name");
        }
        this._argtype = argclass;
        if (propName.startsWith("get")) {
            this._methName = propName;
            this._propName = propName.substring(3);
        } else if (argclass.equals(Boolean.class) && propName.startsWith("is")) {
            this._methName = propName;
            this._propName = propName.substring(2);
        } else {
            this._propName = propName;
            this._methName = "get" + propName;
        }
        try {
            this._meth = argclass.getMethod(this._methName, new Class[0]);
        }
        catch (NoSuchMethodException x) {
            String msg = "class {0} does not have property \"{1}\"";
            Object[] args = new Object[]{argclass.getName(), propName};
            IllegalArgumentException iax = new IllegalArgumentException(MessageFormat.format(msg, args));
            iax.initCause(x);
            throw iax;
        }
    }

    public String getPropertyName() {
        return this._propName;
    }

    @Override
    public R fn(T arg) {
        try {
            Object val = this.getMethod().invoke(arg, new Object[0]);
            return (R)val;
        }
        catch (ClassCastException x) {
            String msg = "{0}.{1} returns type {2}";
            Method m = this.getMethod();
            Object[] args = new Object[]{this._argtype.getName(), m.getName(), m.getReturnType().getName()};
            throw new EvaluationException(MessageFormat.format(msg, args), x);
        }
        catch (IllegalAccessException x) {
            String msg = "{0}.{1} is not accessible";
            Object[] args = new Object[]{this._argtype.getName(), this.getMethod().getName()};
            throw new EvaluationException(MessageFormat.format(msg, args), x);
        }
        catch (InvocationTargetException x) {
            String msg = "{0}.{1} failed : " + x.getMessage();
            Object[] args = new Object[]{this._argtype.getName(), this.getMethod().getName()};
            throw new EvaluationException(MessageFormat.format(msg, args), x);
        }
    }

    private Method getMethod() {
        if (this._meth == null) {
            try {
                this._meth = this._argtype.getMethod(this._methName, new Class[0]);
            }
            catch (NoSuchMethodException x) {
                String msg = "class {0} does not have method {1}";
                Object[] args = new Object[]{this._argtype.getName(), this._methName};
                throw new EvaluationException(MessageFormat.format(msg, args), x);
            }
        }
        return this._meth;
    }

    @Override
    public void accept(net.sf.jga.fn.Visitor v) {
        if (v instanceof Visitor) {
            ((Visitor)v).visit(this);
        }
    }

    public String toString() {
        return "GetProperty[" + this._propName + "]";
    }

    public static interface Visitor
    extends net.sf.jga.fn.Visitor {
        public void visit(GetProperty var1);
    }
}

