/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.property;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import net.sf.jga.fn.BinaryFunctor;
import net.sf.jga.fn.EvaluationException;
import net.sf.jga.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokeMethod<T, R>
extends BinaryFunctor<T, Object[], R> {
    static final long serialVersionUID = -4632096384509133504L;
    private Class<T> _objClass;
    private String _methName;
    private Class[] _argtypes;
    private transient Method _meth;

    public InvokeMethod(Class<T> objClass, Method method) {
        if (method == null) {
            String msg = "Must supply method";
            throw new IllegalArgumentException(msg);
        }
        if (objClass == null) {
            String msg = "Must supply object class";
            throw new IllegalArgumentException(msg);
        }
        if (!method.getDeclaringClass().isAssignableFrom(objClass)) {
            String msg = "Method {0} not defined for class {1}";
            Object[] args = new Object[]{method.getName(), objClass.getName()};
            throw new IllegalArgumentException(MessageFormat.format(msg, args));
        }
        this._objClass = objClass;
        this._meth = method;
        this._methName = method.getName();
        this._argtypes = method.getParameterTypes();
    }

    public InvokeMethod(Class<T> objClass, String methName, Class argtype) {
        this(objClass, methName, new Class[]{argtype});
    }

    public InvokeMethod(Class<T> objClass, String methName, Class[] argtypes) {
        if (methName == null || methName.length() == 0) {
            String msg = "Must supply method name";
            throw new IllegalArgumentException(msg);
        }
        if (objClass == null) {
            String msg = "Must supply object class";
            throw new IllegalArgumentException(msg);
        }
        this._methName = methName;
        this._objClass = objClass;
        this._argtypes = argtypes;
        try {
            this._meth = objClass.getMethod(this._methName, argtypes);
        }
        catch (NoSuchMethodException x) {
            String msg = "No such method: " + x.getMessage();
            IllegalArgumentException iax = new IllegalArgumentException(msg);
            iax.initCause(x);
            throw iax;
        }
    }

    public String getMethodName() {
        return this._methName;
    }

    public Class<R> getReturnType() {
        return this._meth.getReturnType();
    }

    @Override
    public R fn(T obj, Object[] args) {
        try {
            return (R)this.getMethod(this._argtypes).invoke(obj, args);
        }
        catch (ClassCastException x) {
            String msg = "ClassCastException: " + this._objClass + "." + this._methName + "(" + Arrays.toString(args) + ")";
            throw new EvaluationException(msg, x);
        }
        catch (IllegalAccessException x) {
            String msg = this._objClass + "." + this._methName + " is not accessible";
            throw new EvaluationException(msg, x);
        }
        catch (InvocationTargetException x) {
            String xmsg = x.getMessage();
            String msg = "InvocationException: " + this._objClass + "." + this._methName + "(" + Arrays.toString(args) + ")" + (xmsg != null ? ":" + xmsg : "");
            throw new EvaluationException(msg, x);
        }
    }

    private Method getMethod(Class[] argtypes) {
        if (this._meth == null) {
            try {
                this._meth = this._objClass.getMethod(this._methName, argtypes);
            }
            catch (NoSuchMethodException x) {
                throw new EvaluationException(x);
            }
        }
        return this._meth;
    }

    @Override
    public void accept(net.sf.jga.fn.Visitor v) {
        if (v instanceof Visitor) {
            ((Visitor)v).visit(this);
        }
    }

    public String toString() {
        return "InvokeMethod(" + this._meth + ")";
    }

    public static interface Visitor
    extends net.sf.jga.fn.Visitor {
        public void visit(InvokeMethod var1);
    }
}

