/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.property;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import net.sf.jga.fn.EvaluationException;
import net.sf.jga.fn.UnaryFunctor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokeNoArgMethod<T, R>
extends UnaryFunctor<T, R> {
    static final long serialVersionUID = -2651164047444243205L;
    private String _methName;
    private Class<T> _objclass;
    private transient Method _meth;

    public InvokeNoArgMethod(Class<T> objclass, String methName) {
        if (methName == null || methName.length() == 0) {
            String msg = "Must supply method name";
            throw new IllegalArgumentException(msg);
        }
        if (objclass == null) {
            String msg = "Must supply object class";
            throw new IllegalArgumentException(msg);
        }
        this._methName = methName;
        this._objclass = objclass;
        try {
            this._meth = objclass.getMethod(this._methName, new Class[0]);
        }
        catch (NoSuchMethodException x) {
            String msg = "No such method: " + x.getMessage();
            IllegalArgumentException iax = new IllegalArgumentException(msg);
            iax.initCause(x);
            throw iax;
        }
    }

    public InvokeNoArgMethod(Class<T> objClass, Method method) {
        if (method == null) {
            String msg = "Must supply method";
            throw new IllegalArgumentException(msg);
        }
        if (objClass == null) {
            String msg = "Must supply object class";
            throw new IllegalArgumentException(msg);
        }
        if (method.getParameterTypes().length != 0) {
            String msg = "Method {0} takes arguments";
            Object[] args = new Object[]{method.getName()};
            throw new IllegalArgumentException(MessageFormat.format(msg, args));
        }
        if (!method.getDeclaringClass().isAssignableFrom(objClass)) {
            String msg = "Method {0} not defined for class {1}";
            Object[] args = new Object[]{method.getName(), objClass.getName()};
            throw new IllegalArgumentException(MessageFormat.format(msg, args));
        }
        this._objclass = objClass;
        this._meth = method;
        this._methName = method.getName();
    }

    public String getMethodName() {
        return this._methName;
    }

    public Class<R> getReturnType() {
        return this._meth.getReturnType();
    }

    @Override
    public R fn(T obj) {
        try {
            return (R)this.getMethod().invoke(obj, new Object[0]);
        }
        catch (ClassCastException x) {
            throw new EvaluationException(x);
        }
        catch (IllegalAccessException x) {
            throw new EvaluationException(x);
        }
        catch (InvocationTargetException x) {
            throw new EvaluationException(x);
        }
    }

    private Method getMethod() {
        if (this._meth == null) {
            try {
                this._meth = this._objclass.getMethod(this._methName, new Class[0]);
            }
            catch (NoSuchMethodException x) {
                throw new EvaluationException(x);
            }
        }
        return this._meth;
    }

    @Override
    public void accept(net.sf.jga.fn.Visitor v) {
        if (v instanceof Visitor) {
            ((Visitor)v).visit(this);
        }
    }

    public String toString() {
        return "InvokeNoArgMethod(" + this._meth + ")";
    }

    public static interface Visitor
    extends net.sf.jga.fn.Visitor {
        public void visit(InvokeNoArgMethod var1);
    }
}

