/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.property;

import java.lang.reflect.Field;
import java.text.MessageFormat;
import net.sf.jga.fn.BinaryFunctor;
import net.sf.jga.fn.EvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetField<T, R>
extends BinaryFunctor<T, R, R> {
    static final long serialVersionUID = -5051261348109487737L;
    private Class<R> _fieldType;
    private String _fieldName;
    private transient Field _field;

    public SetField(Class<T> argType, Field field, Class<R> fieldType) {
        if (field == null) {
            throw new IllegalArgumentException("Must supply field");
        }
        if (field.getDeclaringClass().isAssignableFrom(argType)) {
            throw new IllegalArgumentException(this.buildNoSuchFieldMessage(field.getName(), argType));
        }
        if (!fieldType.isAssignableFrom(field.getType())) {
            String msg = "Field {0} is of the wrong type: is {1}, expected {2}";
            Object[] args = new Object[]{field.getName(), field.getType().getName(), fieldType.getName()};
            throw new IllegalArgumentException(MessageFormat.format(msg, args));
        }
        this._fieldName = field.getName();
        this._fieldType = fieldType;
        this._field = field;
    }

    public SetField(Class<T> argType, String fieldName, Class<R> fieldType) {
        if (fieldName == null || fieldName.length() == 0) {
            throw new IllegalArgumentException("Must supply field name");
        }
        if (fieldType == null) {
            throw new IllegalArgumentException("Must supply field type");
        }
        this._fieldName = fieldName;
        this._fieldType = fieldType;
        try {
            this._field = argType.getField(this._fieldName);
        }
        catch (NoSuchFieldException x) {
            IllegalArgumentException iax = new IllegalArgumentException(this.buildNoSuchFieldMessage(fieldName, argType));
            iax.initCause(x);
            throw iax;
        }
    }

    public String getFieldName() {
        return this._fieldName;
    }

    @Override
    public R fn(T arg, R val) {
        try {
            this.getField(arg).set(arg, val);
            return null;
        }
        catch (ClassCastException x) {
            String msg = "{0}.{1} is of type {2}";
            Field f = this.getField(arg);
            Object[] args = new Object[]{arg.getClass().getName(), f.getName(), f.getType().getName()};
            throw new EvaluationException(MessageFormat.format(msg, args), x);
        }
        catch (IllegalAccessException x) {
            String msg = "{0}.{1} is not accessible";
            Object[] args = new Object[]{arg.getClass().getName(), this.getField(arg).getName()};
            throw new EvaluationException(MessageFormat.format(msg, args), x);
        }
    }

    private Field getField(T arg) {
        if (this._field == null) {
            try {
                this._field = arg.getClass().getField(this._fieldName);
            }
            catch (NoSuchFieldException x) {
                throw new EvaluationException(x);
            }
        }
        return this._field;
    }

    private String buildNoSuchFieldMessage(String fieldname, Class clasz) {
        String msg = "class {0} does not have field {1}";
        Object[] args = new Object[]{clasz.getName(), fieldname};
        return MessageFormat.format(msg, args);
    }

    @Override
    public void accept(net.sf.jga.fn.Visitor v) {
        if (v instanceof Visitor) {
            ((Visitor)v).visit(this);
        }
    }

    public String toString() {
        return "SetField(" + this._fieldName + ")";
    }

    public static interface Visitor
    extends net.sf.jga.fn.Visitor {
        public void visit(SetField var1);
    }
}

