/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.property;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import net.sf.jga.fn.BinaryFunctor;
import net.sf.jga.fn.EvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetProperty<T, R>
extends BinaryFunctor<T, R, R> {
    static final long serialVersionUID = 5305970242256716550L;
    private Class<R> _propClass;
    private String _propName;
    private String _methName;
    private transient Method _meth;

    public SetProperty(Class<T> argType, String propName, Class<R> propType) {
        if (propName == null || propName.length() == 0) {
            throw new IllegalArgumentException("Must supply property name");
        }
        if (propType == null) {
            throw new IllegalArgumentException("Must supply property type");
        }
        if (propName.startsWith("set")) {
            this._methName = propName;
            this._propName = propName.substring(3);
        } else {
            this._propName = propName;
            this._methName = "set" + propName;
        }
        this._propClass = propType;
        try {
            Class[] car = new Class[]{propType};
            this._meth = argType.getMethod(this._methName, car);
        }
        catch (NoSuchMethodException x) {
            String msg = "class {0} does not have property \"{1}\"";
            Object[] args = new Object[]{argType.getName(), propName};
            IllegalArgumentException iax = new IllegalArgumentException(MessageFormat.format(msg, args));
            iax.initCause(x);
            throw iax;
        }
    }

    public String getPropertyName() {
        return this._propName;
    }

    @Override
    public R fn(T arg, R val) {
        try {
            Object ret = this.getMethod(arg).invoke(arg, val);
            return (R)ret;
        }
        catch (ClassCastException x) {
            String msg = "{0}.{1} returns type {2}";
            Method m = this.getMethod(arg);
            Object[] args = new Object[]{arg.getClass().getName(), m.getName(), m.getReturnType().getName()};
            throw new EvaluationException(MessageFormat.format(msg, args), x);
        }
        catch (IllegalAccessException x) {
            String msg = "{0}.{1} is not accessible";
            Object[] args = new Object[]{arg.getClass().getName(), this.getMethod(arg).getName()};
            throw new EvaluationException(MessageFormat.format(msg, args), x);
        }
        catch (InvocationTargetException x) {
            String msg = "{0}.{1}({2}) failed : " + x.getMessage();
            Object[] args = new Object[]{arg.getClass().getName(), this.getMethod(arg).getName(), val};
            throw new EvaluationException(MessageFormat.format(msg, args), x);
        }
    }

    private Method getMethod(T arg) {
        if (this._meth == null) {
            try {
                Class[] car = new Class[]{this._propClass};
                this._meth = arg.getClass().getMethod(this._methName, car);
            }
            catch (NoSuchMethodException x) {
                throw new EvaluationException(x);
            }
        }
        return this._meth;
    }

    @Override
    public void accept(net.sf.jga.fn.Visitor v) {
        if (v instanceof Visitor) {
            ((Visitor)v).visit(this);
        }
    }

    public String toString() {
        return "SetProperty(" + this._methName + ")";
    }

    public static interface Visitor
    extends net.sf.jga.fn.Visitor {
        public void visit(SetProperty var1);
    }
}

