/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.fn.string;

import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import net.sf.jga.fn.EvaluationException;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.fn.arithmetic.ValueOf;
import net.sf.jga.fn.property.Cast;
import net.sf.jga.fn.property.ConstructUnary;
import net.sf.jga.fn.property.GetProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseFormat<R>
extends UnaryFunctor<String, R> {
    static final long serialVersionUID = 6590747028326789147L;
    private Format _format;
    private UnaryFunctor<Object, R> _converter;

    protected ParseFormat(Format format, UnaryFunctor<Object, R> conv) {
        if (format == null) {
            String msg = "Format must be specified";
            throw new IllegalArgumentException(msg);
        }
        this._format = format;
        this._converter = conv;
    }

    public Format getFormat() {
        return this._format;
    }

    @Override
    public R fn(String arg) {
        try {
            Object obj = this._format.parseObject(arg);
            Object val = this._converter == null ? obj : this._converter.fn(obj);
            return (R)val;
        }
        catch (ParseException x) {
            String msg = "Unable to parse \"{0}\"";
            Object[] args = new Object[]{arg};
            throw new EvaluationException(MessageFormat.format(msg, args), x);
        }
        catch (ClassCastException x) {
            String msg = "Unable to convert \"{0}\" to correct type";
            Object[] args = new Object[]{arg};
            throw new EvaluationException(MessageFormat.format(msg, args), x);
        }
    }

    @Override
    public void accept(net.sf.jga.fn.Visitor v) {
        if (v instanceof Visitor) {
            ((Visitor)v).visit(this);
        }
    }

    public String toString() {
        return "ParseFormat[" + this._format + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Number<T extends java.lang.Number>
    extends ParseFormat<T> {
        static final long serialVersionUID = -5365953713327551298L;

        public Number(Class<T> type, NumberFormat format) {
            super(format, new ValueOf(type).compose(new Cast<java.lang.Number>(java.lang.Number.class)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Date<T extends java.util.Date>
    extends ParseFormat<T> {
        static final long serialVersionUID = 6959869794482290044L;

        public Date(Class<T> type, DateFormat format) {
            super(format, type.equals(java.util.Date.class) ? new Cast<java.util.Date>(java.util.Date.class) : new ConstructUnary(Long.TYPE, type).compose(new GetProperty(java.util.Date.class, "Time")).compose(new Cast<java.util.Date>(java.util.Date.class)));
        }
    }

    public static interface Visitor
    extends net.sf.jga.fn.Visitor {
        public void visit(ParseFormat var1);
    }
}

