/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.parser;

import java.text.MessageFormat;
import net.sf.jga.fn.adaptor.Constant;
import net.sf.jga.parser.FunctorRef;
import net.sf.jga.parser.GeneratorRef;
import net.sf.jga.parser.ParseException;

class EnumHandler {
    static final boolean handlesEnums = true;

    EnumHandler() {
    }

    static FunctorRef checkEnum(Class type, String name) throws ParseException {
        if (type.isEnum()) {
            try {
                return new GeneratorRef(new Constant(Enum.valueOf(type, name)), type);
            }
            catch (IllegalArgumentException x) {
                String msg = "enum {0} has no {1} value";
                Object[] args = new Object[]{type.getName(), name};
                ParseException px = new ParseException(MessageFormat.format(msg, args));
                px.initCause(x);
                throw px;
            }
        }
        return null;
    }
}

