/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.parser;

import java.text.MessageFormat;
import net.sf.jga.fn.BinaryFunctor;
import net.sf.jga.fn.Generator;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.parser.FunctorParser;
import net.sf.jga.parser.IParser;
import net.sf.jga.parser.JFXGParser;
import net.sf.jga.parser.ParseException;
import net.sf.jga.parser.UncheckedParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericParser
implements IParser {
    private static GenericParser _instance;
    private IParser _delegate;

    public static synchronized GenericParser getInstance() {
        if (_instance == null) {
            _instance = new GenericParser(FunctorParser.getInstance());
        }
        return _instance;
    }

    public GenericParser() {
        this._delegate = new JFXGParser();
    }

    public GenericParser(IParser delegate) {
        this._delegate = delegate;
    }

    public <R> Generator<R> parseGenerator(String str, Class<R> returnType) throws ClassCastException, ParseException {
        Generator gen = this.parseGenerator(str);
        if (returnType.isAssignableFrom(this.getReturnType())) {
            return gen;
        }
        String err = "Expected Generator<{0}>, but expression returns {1}";
        String msg = MessageFormat.format(err, returnType.getName(), this.getReturnType().getName());
        throw new ClassCastException(msg);
    }

    public <T, R> UnaryFunctor<T, R> parseUnary(String str, Class<T> argType, Class<R> returnType) throws ClassCastException, ParseException {
        UnaryFunctor uf = this.parseUnary(str, argType);
        if (returnType.isAssignableFrom(this.getReturnType())) {
            return uf;
        }
        String err = "Expected UnaryFunctor<{0},{1}>, but expression returns {2}";
        String msg = MessageFormat.format(err, argType.getName(), returnType.getName(), this.getReturnType().getName());
        throw new ClassCastException(msg);
    }

    public <T1, T2, R> BinaryFunctor<T1, T2, R> parseBinary(String str, Class<T1> arg1Type, Class<T2> arg2Type, Class<R> returnType) throws ClassCastException, ParseException {
        BinaryFunctor bf = this.parseBinary(str, arg1Type, arg2Type);
        if (returnType.isAssignableFrom(this.getReturnType())) {
            return bf;
        }
        String err = "Expected BinaryFunctor<{0},{1},{2}>, but expression returns {3}";
        String msg = MessageFormat.format(err, arg1Type.getName(), arg2Type.getName(), returnType.getName(), this.getReturnType().getName());
        throw new ClassCastException(msg);
    }

    @Override
    public Generator parseGenerator(String str) throws ParseException {
        return this._delegate.parseGenerator(str);
    }

    @Override
    public UnaryFunctor parseUnary(String str, Class argType) throws ParseException {
        return this._delegate.parseUnary(str, argType);
    }

    @Override
    public BinaryFunctor parseBinary(String str, Class arg1Type, Class arg2Type) throws ParseException {
        return this._delegate.parseBinary(str, arg1Type, arg2Type);
    }

    @Override
    public Class getReturnType() {
        return this._delegate.getReturnType();
    }

    public static <R> Generator<R> parse(String str, Class<R> returnType) throws UncheckedParseException, ClassCastException {
        try {
            return GenericParser.getInstance().parseGenerator(str);
        }
        catch (ParseException x) {
            throw new UncheckedParseException(x);
        }
    }

    public static <T, R> UnaryFunctor parse(String str, Class<T> argType, Class<R> returnType) throws UncheckedParseException, ClassCastException {
        try {
            return GenericParser.getInstance().parseUnary(str, argType, returnType);
        }
        catch (ParseException x) {
            throw new UncheckedParseException(x);
        }
    }

    public static <T1, T2, R> BinaryFunctor parse(String str, Class<T1> arg1Type, Class<T2> arg2Type, Class<R> returnType) throws UncheckedParseException, ClassCastException {
        try {
            return GenericParser.getInstance().parseBinary(str, arg1Type, arg2Type, returnType);
        }
        catch (ParseException x) {
            throw new UncheckedParseException(x);
        }
    }
}

