/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.parser;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jga.fn.BinaryFunctor;
import net.sf.jga.fn.BinaryPredicate;
import net.sf.jga.fn.Generator;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.fn.UnaryPredicate;
import net.sf.jga.fn.adaptor.AndBinary;
import net.sf.jga.fn.adaptor.AndGenerator;
import net.sf.jga.fn.adaptor.AndUnary;
import net.sf.jga.fn.adaptor.ApplyBinary;
import net.sf.jga.fn.adaptor.ApplyGenerator;
import net.sf.jga.fn.adaptor.ApplyUnary;
import net.sf.jga.fn.adaptor.CompoundBinary;
import net.sf.jga.fn.adaptor.CompoundGenerator;
import net.sf.jga.fn.adaptor.CompoundUnary;
import net.sf.jga.fn.adaptor.ConditionalBinary;
import net.sf.jga.fn.adaptor.ConditionalGenerator;
import net.sf.jga.fn.adaptor.ConditionalUnary;
import net.sf.jga.fn.adaptor.Constant;
import net.sf.jga.fn.adaptor.ConstantBinary;
import net.sf.jga.fn.adaptor.ConstantUnary;
import net.sf.jga.fn.adaptor.GenerateBinary;
import net.sf.jga.fn.adaptor.GenerateUnary;
import net.sf.jga.fn.adaptor.Identity;
import net.sf.jga.fn.adaptor.OrBinary;
import net.sf.jga.fn.adaptor.OrGenerator;
import net.sf.jga.fn.adaptor.OrUnary;
import net.sf.jga.fn.adaptor.Project1st;
import net.sf.jga.fn.adaptor.Project2nd;
import net.sf.jga.fn.arithmetic.Arithmetic;
import net.sf.jga.fn.arithmetic.ArithmeticFactory;
import net.sf.jga.fn.arithmetic.BitwiseAnd;
import net.sf.jga.fn.arithmetic.BitwiseNot;
import net.sf.jga.fn.arithmetic.BitwiseOr;
import net.sf.jga.fn.arithmetic.BitwiseXor;
import net.sf.jga.fn.arithmetic.Divides;
import net.sf.jga.fn.arithmetic.Minus;
import net.sf.jga.fn.arithmetic.Modulus;
import net.sf.jga.fn.arithmetic.Multiplies;
import net.sf.jga.fn.arithmetic.Negate;
import net.sf.jga.fn.arithmetic.Plus;
import net.sf.jga.fn.arithmetic.ShiftLeft;
import net.sf.jga.fn.arithmetic.ShiftRight;
import net.sf.jga.fn.arithmetic.UnsignedShiftRight;
import net.sf.jga.fn.arithmetic.ValueOf;
import net.sf.jga.fn.comparison.EqualTo;
import net.sf.jga.fn.comparison.Greater;
import net.sf.jga.fn.comparison.GreaterEqual;
import net.sf.jga.fn.comparison.Less;
import net.sf.jga.fn.comparison.LessEqual;
import net.sf.jga.fn.comparison.NotEqualTo;
import net.sf.jga.fn.logical.LogicalAnd;
import net.sf.jga.fn.logical.LogicalNot;
import net.sf.jga.fn.logical.LogicalOr;
import net.sf.jga.fn.property.ArrayUnary;
import net.sf.jga.fn.property.Cast;
import net.sf.jga.fn.property.Construct;
import net.sf.jga.fn.property.ConstructDefault;
import net.sf.jga.fn.property.ConstructUnary;
import net.sf.jga.fn.property.GetField;
import net.sf.jga.fn.property.InstanceOf;
import net.sf.jga.fn.property.InvokeMethod;
import net.sf.jga.fn.property.InvokeNoArgMethod;
import net.sf.jga.fn.string.DefaultFormat;
import net.sf.jga.parser.BinaryFunctorRef;
import net.sf.jga.parser.EnumHandler;
import net.sf.jga.parser.FunctorRef;
import net.sf.jga.parser.GeneratorRef;
import net.sf.jga.parser.IParser;
import net.sf.jga.parser.JFXGParserConstants;
import net.sf.jga.parser.JFXGParserTokenManager;
import net.sf.jga.parser.JavaCharStream;
import net.sf.jga.parser.JavaLangResources;
import net.sf.jga.parser.ParseException;
import net.sf.jga.parser.Token;
import net.sf.jga.parser.UnaryFunctorRef;
import net.sf.jga.parser.UncheckedParseException;
import net.sf.jga.util.ComparableComparator;

public class JFXGParser
implements IParser,
JFXGParserConstants {
    public static final String[] ARG_NAME = new String[]{"x", "y"};
    private Map arguments = new HashMap();
    private Map imports = new HashMap();
    private Map methods = new HashMap();
    private Map fields = new HashMap();
    private Object thisObj;
    private Map javalang = JavaLangResources.getMap();
    private boolean _undecoratedDecimal;
    FunctorRef lastFunctorRef;
    private static JFXGParser _instance;
    private static Map boxedTypes;
    private static Map unboxedTypes;
    private static Map boxFunctors;
    private static Map unboxFunctors;
    private static Set stableFunctors;
    private static final int CONSTANT = Integer.MIN_VALUE;
    private static final int ARG_ = 0;
    private static final int ARG_X = 1;
    private static final int ARG_Y = 2;
    private static final int ARG_XY = 3;
    private InvokeMethod invokeAppendString = new InvokeMethod(StringBuffer.class, "append", String.class);
    public JFXGParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();

    public static void main(String[] args) {
        JFXGParser fnp = new JFXGParser();
        try {
            FunctorRef ref = fnp.Functor();
        }
        catch (Exception x) {
            System.out.println(x.getMessage());
            x.printStackTrace();
        }
    }

    public JFXGParser() {
        this(new InputStreamReader(System.in));
    }

    public void importClass(Class clasz) {
        this.importClass(clasz.getSimpleName(), clasz);
    }

    public void importClass(String alias, Class clasz) {
        if (alias != null && clasz != null) {
            this.imports.put(alias, clasz);
        }
    }

    public void deportClass(String alias) {
        if (alias != null) {
            this.imports.remove(alias);
        }
    }

    public void importStatics(Class clasz) {
        Field[] fields = clasz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!Modifier.isStatic(fields[i].getModifiers())) continue;
            this.importField(fields[i]);
        }
        Method[] methods = clasz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!Modifier.isStatic(methods[i].getModifiers())) continue;
            this.importMethod(methods[i]);
        }
    }

    public void importField(Class clasz, String name) throws NoSuchFieldException {
        this.importField(clasz.getField(name));
    }

    public void importField(Field field) throws IllegalArgumentException {
        if (!Modifier.isStatic(field.getModifiers())) {
            String msg = "Cannot import non-static field {0}";
            throw new IllegalArgumentException(MessageFormat.format(msg, field));
        }
        this.fields.put(field.getName(), field);
    }

    public Field getImportedField(String name) {
        return (Field)this.fields.get(name);
    }

    public void importMethod(Class clasz, String name) throws NoSuchMethodException {
        Method[] methods = clasz.getMethods();
        int numImported = 0;
        for (int i = 0; i < methods.length; ++i) {
            if (!name.equals(methods[i].getName()) || !Modifier.isStatic(methods[i].getModifiers())) continue;
            this.importMethod(name, methods[i]);
            ++numImported;
        }
        if (numImported == 0) {
            String msg = "No non-static method {0} found in class {1}";
            Object[] args = new Object[]{name, clasz.getName()};
            throw new NoSuchMethodException(MessageFormat.format(msg, args));
        }
    }

    public void importMethod(Method meth) {
        this.importMethod(meth.getName(), meth);
    }

    public void importMethod(String name, Method meth) {
        if (!Modifier.isStatic(meth.getModifiers())) {
            String msg = "Cannot import non-static method {0}";
            throw new IllegalArgumentException(MessageFormat.format(msg, meth));
        }
        ArrayList<Method> methodList = (ArrayList<Method>)this.methods.get(name);
        if (methodList == null) {
            methodList = new ArrayList<Method>();
            this.methods.put(name, methodList);
        }
        methodList.add(meth);
    }

    public Method[] getImportedMethods(String name) {
        List methodList = (List)this.methods.get(name);
        if (methodList == null) {
            return new Method[0];
        }
        return methodList.toArray(new Method[0]);
    }

    protected FunctorRef reservedWord(String name) throws ParseException {
        return null;
    }

    protected FunctorRef reservedField(FunctorRef prefix, String name) throws ParseException {
        return null;
    }

    protected FunctorRef reservedFunction(String name, FunctorRef[] args) throws ParseException {
        return null;
    }

    public void bindThis(Object thisBinding) {
        this.thisObj = thisBinding;
    }

    protected Object getBoundObject() {
        return this.thisObj;
    }

    public void setUndecoratedDecimal(boolean flag) {
        this._undecoratedDecimal = flag;
    }

    public boolean isUndecoratedDecimal() {
        return this._undecoratedDecimal;
    }

    public Generator parseGenerator(String str) throws ParseException {
        this.ReInit(new StringBufferInputStream(str));
        return this.parseGenerator();
    }

    public Generator parseGenerator() throws ParseException {
        try {
            this.lastFunctorRef = null;
            FunctorRef ref = this.Functor();
            if (ref.getReturnType().isPrimitive() && (ref = this.boxUnboxFunctor(this.getBoxedType(ref.getReturnType()), ref)) == null) {
                String msg = "Internal error: no boxed functor registered for type " + ref.getReturnType();
                throw new ParseException(msg);
            }
            if (ref instanceof GeneratorRef) {
                this.lastFunctorRef = ref;
                return ((GeneratorRef)ref).getFunctor();
            }
            throw new ParseException("Invalid number of arguments");
        }
        catch (ParseException x) {
            throw x;
        }
        catch (Throwable x) {
            ParseException px = new ParseException(x.getMessage());
            px.initCause(x);
            throw px;
        }
    }

    public UnaryFunctor parseUnary(String str, Class argType) throws ParseException {
        this.ReInit(new StringBufferInputStream(str));
        return this.parseUnary(argType);
    }

    public UnaryFunctor parseUnary(Class argType) throws ParseException {
        this.arguments.put(ARG_NAME[0], argType);
        this.lastFunctorRef = null;
        try {
            this.lastFunctorRef = this.Functor();
            Class expType = this.lastFunctorRef.getReturnType();
            if (expType.isPrimitive()) {
                this.lastFunctorRef = this.boxUnboxFunctor(this.getBoxedType(expType), this.lastFunctorRef);
                if (this.lastFunctorRef == null) {
                    String msg = "Internal error: no boxed functor registered for type " + expType;
                    throw new ParseException(msg);
                }
            }
            return this.ensureUnary(this.lastFunctorRef);
        }
        catch (ParseException x) {
            throw x;
        }
        catch (Throwable x) {
            ParseException px = new ParseException(x.getMessage());
            px.initCause(x);
            throw px;
        }
    }

    public BinaryFunctor parseBinary(String str, Class arg1Type, Class arg2Type) throws ParseException {
        this.ReInit(new StringBufferInputStream(str));
        return this.parseBinary(arg1Type, arg2Type);
    }

    public BinaryFunctor parseBinary(Class arg1Type, Class arg2Type) throws ParseException {
        this.arguments.put(ARG_NAME[0], arg1Type);
        this.arguments.put(ARG_NAME[1], arg2Type);
        this.lastFunctorRef = null;
        try {
            this.lastFunctorRef = this.Functor();
            Class expType = this.lastFunctorRef.getReturnType();
            if (expType.isPrimitive()) {
                this.lastFunctorRef = this.boxUnboxFunctor(this.getBoxedType(expType), this.lastFunctorRef);
                if (this.lastFunctorRef == null) {
                    String msg = "Internal error: no boxed functor registered for type " + expType;
                    throw new ParseException(msg);
                }
            }
            return this.ensureBinary(this.lastFunctorRef);
        }
        catch (ParseException x) {
            throw x;
        }
        catch (Throwable x) {
            ParseException px = new ParseException(x.getMessage());
            px.initCause(x);
            throw px;
        }
    }

    public Class getReturnType() {
        if (this.lastFunctorRef == null) {
            throw new IllegalStateException();
        }
        return this.lastFunctorRef.getReturnType();
    }

    public static synchronized JFXGParser getInstance() {
        if (_instance == null) {
            _instance = new JFXGParser(){

                public void setUndecoratedDecimal(boolean flag) {
                    throw new UnsupportedOperationException();
                }

                public void importClass(Class clasz) {
                    throw new UnsupportedOperationException();
                }

                public void importClass(String alias, Class clasz) {
                    throw new UnsupportedOperationException();
                }

                public void deportClass(String alias) {
                    throw new UnsupportedOperationException();
                }

                public void importStatics(Class clasz) {
                    throw new UnsupportedOperationException();
                }

                public void importField(Class clasz, String name) {
                    throw new UnsupportedOperationException();
                }

                public void importField(Field field) {
                    throw new UnsupportedOperationException();
                }

                public void importMethod(Class clasz, String name) {
                    throw new UnsupportedOperationException();
                }

                public void importMethod(Method meth) {
                    throw new UnsupportedOperationException();
                }

                public void importMethod(String name, Method meth) {
                    throw new UnsupportedOperationException();
                }

                public void bindThis(Object binding) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return _instance;
    }

    public static Generator parse(String str) throws UncheckedParseException {
        try {
            return JFXGParser.getInstance().parseGenerator(str);
        }
        catch (ParseException x) {
            throw new UncheckedParseException(x);
        }
    }

    public static UnaryFunctor parse(String str, Class argType) throws UncheckedParseException {
        try {
            return JFXGParser.getInstance().parseUnary(str, argType);
        }
        catch (ParseException x) {
            throw new UncheckedParseException(x);
        }
    }

    public static BinaryFunctor parse(String str, Class arg1Type, Class arg2Type) throws UncheckedParseException {
        try {
            return JFXGParser.getInstance().parseBinary(str, arg1Type, arg2Type);
        }
        catch (ParseException x) {
            throw new UncheckedParseException(x);
        }
    }

    private UnaryFunctor getBoxFunctor(Class primitive) {
        return (UnaryFunctor)boxFunctors.get(primitive);
    }

    private UnaryFunctor getUnboxFunctor(Class reference) {
        return (UnaryFunctor)unboxFunctors.get(reference);
    }

    protected Class getBoxedType(Class type) {
        Class c = (Class)boxedTypes.get(type);
        return c == null ? type : c;
    }

    protected Class getUnboxedType(Class type) {
        Class c = (Class)unboxedTypes.get(type);
        return c == null ? type : c;
    }

    private boolean isBoxedType(Class primitive, Class boxedType) {
        return primitive.isPrimitive() && primitive == this.getUnboxedType(boxedType);
    }

    protected FunctorRef boxUnboxFunctor(Class reqType, FunctorRef ref) throws ParseException {
        if (this.isNull(ref)) {
            return ref;
        }
        Class argType = ref.getReturnType();
        if (reqType.isAssignableFrom(argType)) {
            return ref;
        }
        if (reqType.isPrimitive() && reqType == this.getUnboxedType(argType)) {
            UnaryFunctor uf = this.getUnboxFunctor(argType);
            UnaryFunctorRef unboxed = new UnaryFunctorRef(uf, argType, "", reqType);
            return this.bindUnaryFn(unboxed, ref);
        }
        if (argType.isPrimitive() && reqType.isAssignableFrom(this.getBoxedType(argType))) {
            UnaryFunctor uf = this.getBoxFunctor(argType);
            UnaryFunctorRef boxed = new UnaryFunctorRef(uf, argType, "", reqType);
            return this.bindUnaryFn(boxed, ref);
        }
        return null;
    }

    private boolean isNull(FunctorRef ref) throws ParseException {
        return this.getArgMask(ref) == Integer.MIN_VALUE && ((GeneratorRef)ref).getFunctor().gen() == null;
    }

    private boolean isStable(UnaryFunctor fn) {
        return stableFunctors.contains(fn.getClass());
    }

    private boolean isStable(BinaryFunctor fn) {
        return stableFunctors.contains(fn.getClass());
    }

    private FunctorRef bindUnaryFn(UnaryFunctorRef uf, FunctorRef arg) throws ParseException {
        if (uf.getFunctor() instanceof Identity) {
            return arg;
        }
        if (arg instanceof UnaryFunctorRef && ((UnaryFunctorRef)arg).getFunctor() instanceof Identity) {
            return new UnaryFunctorRef(uf.getFunctor(), arg.getArgType(0), arg.getArgName(0), uf.getReturnType());
        }
        FunctorRef boxedArg = this.boxUnboxFunctor(uf.getArgType(0), arg);
        if (boxedArg == null) {
            String err = "{0} requires arguments of {1} : received {2}";
            String msg = MessageFormat.format(err, uf.getFunctor(), uf.getArgType(0), arg.getReturnType());
            throw new ParseException(msg);
        }
        switch (this.getArgMask(boxedArg)) {
            case -2147483648: {
                Object val = ((GeneratorRef)boxedArg).getFunctor().gen();
                if (this.isStable(uf.getFunctor())) {
                    return new GeneratorRef(new Constant(uf.getFunctor().fn(val)), uf.getReturnType());
                }
                return new GeneratorRef(uf.getFunctor().bind(val), uf.getReturnType());
            }
            case 0: {
                Generator gen = ((GeneratorRef)boxedArg).getFunctor();
                return new GeneratorRef(uf.getFunctor().generate(gen), uf.getReturnType());
            }
            case 1: 
            case 2: {
                UnaryFunctor uf2 = ((UnaryFunctorRef)boxedArg).getFunctor();
                return new UnaryFunctorRef(uf.getFunctor().compose(uf2), boxedArg.getArgType(0), boxedArg.getArgName(0), uf.getReturnType());
            }
            case 3: {
                BinaryFunctor bf = ((BinaryFunctorRef)boxedArg).getFunctor();
                return new BinaryFunctorRef(uf.getFunctor().compose(bf), boxedArg.getArgType(0), boxedArg.getArgType(1), uf.getReturnType());
            }
        }
        throw new ParseException("Cannot bind [" + uf + "] with arg [" + arg + "]");
    }

    private FunctorRef bindBinaryFn(BinaryFunctorRef bf, FunctorRef arg1, FunctorRef arg2) throws ParseException {
        FunctorRef fn1 = this.boxUnboxFunctor(bf.getArgType(0), arg1);
        FunctorRef fn2 = this.boxUnboxFunctor(bf.getArgType(1), arg2);
        if (fn1 == null || fn2 == null) {
            String err = "{0} requires arguments of {1} and {2}: received {3} and {4}";
            String msg = MessageFormat.format(err, bf.getFunctor(), bf.getArgType(0), bf.getArgType(1), arg1.getReturnType(), arg2.getReturnType());
            throw new ParseException(msg);
        }
        arg1 = fn1;
        arg2 = fn2;
        switch (this.getArgMask(arg1)) {
            case -2147483648: {
                Object val1 = ((GeneratorRef)arg1).getFunctor().gen();
                switch (this.getArgMask(arg2)) {
                    case -2147483648: {
                        Object val2 = ((GeneratorRef)arg2).getFunctor().gen();
                        if (this.isStable(bf.getFunctor())) {
                            return new GeneratorRef(new Constant(bf.getFunctor().fn(val1, val2)), bf.getReturnType());
                        }
                        return new GeneratorRef(bf.getFunctor().bind(val1, val2), bf.getReturnType());
                    }
                    case 0: {
                        Generator gen2 = ((GeneratorRef)arg2).getFunctor();
                        return new GeneratorRef(bf.getFunctor().bind1st(val1).generate(gen2), bf.getReturnType());
                    }
                    case 1: 
                    case 2: {
                        UnaryFunctor uf2 = ((UnaryFunctorRef)arg2).getFunctor();
                        return new UnaryFunctorRef(bf.getFunctor().bind1st(val1).compose(uf2), arg2.getArgType(0), arg2.getArgName(0), bf.getReturnType());
                    }
                    case 3: {
                        BinaryFunctor bf2 = ((BinaryFunctorRef)arg2).getFunctor();
                        return new BinaryFunctorRef(bf.getFunctor().bind1st(val1).compose(bf2), arg2.getArgType(0), arg2.getArgType(1), bf.getReturnType());
                    }
                }
                break;
            }
            case 0: {
                Generator gen1 = ((GeneratorRef)arg1).getFunctor();
                switch (this.getArgMask(arg2)) {
                    case -2147483648: {
                        Object val2 = ((GeneratorRef)arg2).getFunctor().gen();
                        return new GeneratorRef(bf.getFunctor().generate1st(gen1).bind(val2), bf.getReturnType());
                    }
                    case 0: {
                        Generator gen2 = ((GeneratorRef)arg2).getFunctor();
                        return new GeneratorRef(bf.getFunctor().generate(gen1, gen2), bf.getReturnType());
                    }
                    case 1: 
                    case 2: {
                        UnaryFunctor uf2 = ((UnaryFunctorRef)arg2).getFunctor();
                        return new UnaryFunctorRef(bf.getFunctor().generate1st(gen1).compose(uf2), arg2.getArgType(0), arg2.getArgName(0), bf.getReturnType());
                    }
                    case 3: {
                        BinaryFunctor bf2 = ((BinaryFunctorRef)arg2).getFunctor();
                        return new BinaryFunctorRef(bf.getFunctor().generate1st(gen1).compose(bf2), arg2.getArgType(0), arg2.getArgType(1), bf.getReturnType());
                    }
                }
                break;
            }
            case 1: {
                UnaryFunctor uf1 = ((UnaryFunctorRef)arg1).getFunctor();
                switch (this.getArgMask(arg2)) {
                    case -2147483648: {
                        Object val2 = ((GeneratorRef)arg2).getFunctor().gen();
                        return new UnaryFunctorRef(bf.getFunctor().bind2nd(val2).compose(uf1), arg1.getArgType(0), arg1.getArgName(0), bf.getReturnType());
                    }
                    case 0: {
                        Generator gen2 = ((GeneratorRef)arg2).getFunctor();
                        return new UnaryFunctorRef(bf.getFunctor().generate2nd(gen2).compose(uf1), arg1.getArgType(0), arg1.getArgName(0), bf.getReturnType());
                    }
                    case 1: {
                        UnaryFunctor ufx = ((UnaryFunctorRef)arg2).getFunctor();
                        return new UnaryFunctorRef(bf.getFunctor().compose(uf1, ufx), arg1.getArgType(0), arg1.getArgName(0), bf.getReturnType());
                    }
                    case 2: {
                        UnaryFunctor ufy = ((UnaryFunctorRef)arg2).getFunctor();
                        return new BinaryFunctorRef(bf.getFunctor().distribute(uf1, ufy), arg1.getArgType(0), arg2.getArgType(0), bf.getReturnType());
                    }
                    case 3: {
                        BinaryFunctor bf2 = ((BinaryFunctorRef)arg2).getFunctor();
                        return new BinaryFunctorRef(bf.getFunctor().compose(uf1.compose(new Project1st()), bf2), arg2.getArgType(0), arg2.getArgType(1), bf.getReturnType());
                    }
                }
                break;
            }
            case 2: {
                UnaryFunctor uf1 = ((UnaryFunctorRef)arg1).getFunctor();
                switch (this.getArgMask(arg2)) {
                    case -2147483648: {
                        Object val2 = ((GeneratorRef)arg2).getFunctor().gen();
                        return new UnaryFunctorRef(bf.getFunctor().bind2nd(val2).compose(uf1), arg1.getArgType(0), arg1.getArgName(0), bf.getReturnType());
                    }
                    case 0: {
                        Generator gen2 = ((GeneratorRef)arg2).getFunctor();
                        return new UnaryFunctorRef(bf.getFunctor().generate2nd(gen2).compose(uf1), arg1.getArgType(0), arg1.getArgName(0), bf.getReturnType());
                    }
                    case 1: {
                        UnaryFunctor ufx = ((UnaryFunctorRef)arg2).getFunctor();
                        return new BinaryFunctorRef(bf.getFunctor().compose(uf1.compose(new Project2nd()), ufx.compose(new Project1st())), arg2.getArgType(0), arg1.getArgType(0), bf.getReturnType());
                    }
                    case 2: {
                        UnaryFunctor ufy = ((UnaryFunctorRef)arg2).getFunctor();
                        return new UnaryFunctorRef(bf.getFunctor().compose(uf1, ufy), arg1.getArgType(0), arg1.getArgName(0), bf.getReturnType());
                    }
                    case 3: {
                        BinaryFunctor bf2 = ((BinaryFunctorRef)arg2).getFunctor();
                        return new BinaryFunctorRef(bf.getFunctor().compose(uf1.compose(new Project2nd()), bf2), arg2.getArgType(0), arg2.getArgType(1), bf.getReturnType());
                    }
                }
                break;
            }
            case 3: {
                BinaryFunctor bf1 = ((BinaryFunctorRef)arg1).getFunctor();
                switch (this.getArgMask(arg2)) {
                    case -2147483648: {
                        Object val2 = ((GeneratorRef)arg2).getFunctor().gen();
                        return new BinaryFunctorRef(bf.getFunctor().bind2nd(val2).compose(bf1), arg1.getArgType(0), arg1.getArgType(1), bf.getReturnType());
                    }
                    case 0: {
                        Generator gen2 = ((GeneratorRef)arg2).getFunctor();
                        return new BinaryFunctorRef(bf.getFunctor().generate2nd(gen2).compose(bf1), arg1.getArgType(0), arg1.getArgType(1), bf.getReturnType());
                    }
                    case 1: {
                        UnaryFunctor ufx = ((UnaryFunctorRef)arg2).getFunctor();
                        return new BinaryFunctorRef(bf.getFunctor().compose(bf1, ufx.compose(new Project1st())), arg1.getArgType(0), arg1.getArgType(1), bf.getReturnType());
                    }
                    case 2: {
                        UnaryFunctor ufy = ((UnaryFunctorRef)arg2).getFunctor();
                        return new BinaryFunctorRef(bf.getFunctor().compose(bf1, ufy.compose(new Project2nd())), arg1.getArgType(0), arg1.getArgType(1), bf.getReturnType());
                    }
                    case 3: {
                        BinaryFunctor bf2 = ((BinaryFunctorRef)arg2).getFunctor();
                        return new BinaryFunctorRef(bf.getFunctor().compose(bf1, bf2), arg1.getArgType(0), arg1.getArgType(1), bf.getReturnType());
                    }
                }
            }
        }
        throw new ParseException("Cannot bind [" + bf + "] with args [" + arg1 + "] and [" + arg2 + "]");
    }

    private FunctorRef bindConditional(FunctorRef condExp, FunctorRef trueExp, FunctorRef falseExp) throws ParseException {
        if (!trueExp.getReturnType().equals(falseExp.getReturnType())) {
            String err = "Conditional Expression may not be applied to results of {0} and {1}";
            String msg = MessageFormat.format(err, trueExp.getReturnType(), falseExp.getReturnType());
            throw new ParseException(msg);
        }
        FunctorRef[] functors = new FunctorRef[]{condExp, trueExp, falseExp};
        int argMask = (this.getArgMask(condExp) | this.getArgMask(trueExp) | this.getArgMask(falseExp)) & 3;
        if (argMask == 3) {
            BinaryFunctor condFn = this.ensureBinary(condExp);
            BinaryFunctor trueFn = this.ensureBinary(trueExp);
            BinaryFunctor falseFn = this.ensureBinary(falseExp);
            ConditionalBinary fn = new ConditionalBinary(condFn, trueFn, falseFn);
            return new BinaryFunctorRef(fn, this.getArgType(0, functors), this.getArgType(1, functors), trueExp.getReturnType());
        }
        if (argMask != 0) {
            UnaryFunctor condFn = this.ensureUnary(condExp);
            UnaryFunctor trueFn = this.ensureUnary(trueExp);
            UnaryFunctor falseFn = this.ensureUnary(falseExp);
            ConditionalUnary fn = new ConditionalUnary(condFn, trueFn, falseFn);
            return new UnaryFunctorRef(fn, this.getArgType(0, functors), this.getArgName(functors), trueExp.getReturnType());
        }
        Generator condFn = ((GeneratorRef)condExp).getFunctor();
        Generator trueFn = ((GeneratorRef)trueExp).getFunctor();
        Generator falseFn = ((GeneratorRef)falseExp).getFunctor();
        ConditionalGenerator fn = new ConditionalGenerator(condFn, trueFn, falseFn);
        return new GeneratorRef(fn, trueExp.getReturnType());
    }

    private FunctorRef bindConditionalLogic(String op, FunctorRef leftExp, FunctorRef rightExp) throws ParseException {
        assert (op.equals("&&") || op.equals("||"));
        Class leftType = leftExp.getReturnType();
        Class rightType = rightExp.getReturnType();
        if (!leftType.equals(Boolean.class) || !rightType.equals(Boolean.class)) {
            String err = "{0} requires Boolean arguments: received {1} and {2}";
            String msg = MessageFormat.format(err, op, leftType, rightType);
            throw new ParseException(msg);
        }
        FunctorRef[] functors = new FunctorRef[]{leftExp, rightExp};
        int argMask = (this.getArgMask(leftExp) | this.getArgMask(rightExp)) & 3;
        if (argMask == 3) {
            BinaryFunctor leftFn = this.ensureBinary(leftExp);
            BinaryFunctor rightFn = this.ensureBinary(rightExp);
            BinaryPredicate fn = op.equals("&&") ? new AndBinary(leftFn, rightFn) : new OrBinary(leftFn, rightFn);
            return new BinaryFunctorRef(fn, this.getArgType(0, functors), this.getArgType(1, functors), Boolean.class);
        }
        if (argMask != 0) {
            UnaryFunctor leftFn = this.ensureUnary(leftExp);
            UnaryFunctor rightFn = this.ensureUnary(rightExp);
            UnaryPredicate fn = op.equals("&&") ? new AndUnary(leftFn, rightFn) : new OrUnary(leftFn, rightFn);
            return new UnaryFunctorRef(fn, this.getArgType(0, functors), this.getArgName(functors), Boolean.class);
        }
        Generator leftFn = ((GeneratorRef)leftExp).getFunctor();
        Generator rightFn = ((GeneratorRef)rightExp).getFunctor();
        Generator fn = op.equals("&&") ? new AndGenerator(leftFn, rightFn) : new OrGenerator(leftFn, rightFn);
        return new GeneratorRef(fn, Boolean.class);
    }

    private FunctorRef bindCompoundFunctors(FunctorRef firstExp, FunctorRef secondExp) throws ParseException {
        FunctorRef[] functors = new FunctorRef[]{firstExp, secondExp};
        int argMask = (this.getArgMask(firstExp) | this.getArgMask(secondExp)) & 3;
        if (argMask == 3) {
            CompoundBinary fn = new CompoundBinary(this.ensureBinary(firstExp), this.ensureBinary(secondExp));
            return new BinaryFunctorRef(fn, this.getArgType(0, functors), this.getArgType(1, functors), secondExp.getReturnType());
        }
        if (argMask != 0) {
            CompoundUnary fn = new CompoundUnary(this.ensureUnary(firstExp), this.ensureUnary(secondExp));
            return new UnaryFunctorRef(fn, this.getArgType(0, functors), this.getArgName(functors), secondExp.getReturnType());
        }
        CompoundGenerator fn = new CompoundGenerator(((GeneratorRef)firstExp).getFunctor(), ((GeneratorRef)secondExp).getFunctor());
        return new GeneratorRef(fn, secondExp.getReturnType());
    }

    private int getArgMask(FunctorRef[] functors) throws ParseException {
        int mask = 0;
        for (int i = 0; i < functors.length; ++i) {
            mask |= this.getArgMask(functors[i]);
        }
        return mask & Integer.MAX_VALUE;
    }

    private String getArgName(FunctorRef[] functors) throws ParseException {
        for (int i = 0; i < functors.length; ++i) {
            int args = this.getArgMask(functors[i]);
            if (args != 1 && args != 2) continue;
            return functors[i].getArgName(0);
        }
        return "bar";
    }

    private Class getArgType(int argIdx, FunctorRef[] functors) throws ParseException {
        int argMask = 1 << argIdx;
        for (int i = 0; i < functors.length; ++i) {
            FunctorRef fn = functors[i];
            if ((this.getArgMask(fn) & argMask) == 0) continue;
            for (int j = 0; j < fn.getNumberArgs(); ++j) {
                if (!fn.getArgName(j).equals(ARG_NAME[argIdx])) continue;
                return fn.getArgType(j);
            }
        }
        return Object.class;
    }

    private BinaryFunctor ensureBinary(FunctorRef fn) throws ParseException {
        switch (this.getArgMask(fn)) {
            case -2147483648: {
                return new ConstantBinary(((GeneratorRef)fn).getFunctor().gen());
            }
            case 0: {
                return new GenerateBinary(((GeneratorRef)fn).getFunctor());
            }
            case 1: {
                return ((UnaryFunctorRef)fn).getFunctor().compose(new Project1st());
            }
            case 2: {
                return ((UnaryFunctorRef)fn).getFunctor().compose(new Project2nd());
            }
            case 3: {
                return ((BinaryFunctorRef)fn).getFunctor();
            }
        }
        throw new ParseException("Cannot bind [" + fn + "] as BinaryFunctor");
    }

    private UnaryFunctor ensureUnary(FunctorRef fn) throws ParseException {
        switch (this.getArgMask(fn)) {
            case -2147483648: {
                return new ConstantUnary(((GeneratorRef)fn).getFunctor().gen());
            }
            case 0: {
                return new GenerateUnary(((GeneratorRef)fn).getFunctor());
            }
            case 1: 
            case 2: {
                return ((UnaryFunctorRef)fn).getFunctor();
            }
        }
        throw new ParseException("Cannot bind [" + fn + "] as UnaryFunctor");
    }

    private int getArgMask(FunctorRef arg) throws ParseException {
        if (arg.getReferenceType() == -2) {
            return Integer.MIN_VALUE;
        }
        if (arg instanceof GeneratorRef) {
            return 0;
        }
        if (arg instanceof BinaryFunctorRef) {
            return 3;
        }
        String name = arg.getArgName(0);
        if (name.equals(ARG_NAME[0])) {
            return 1;
        }
        if (name.equals(ARG_NAME[1])) {
            return 2;
        }
        throw new ParseException("Unknown argument \"" + name + "\" for functor ref " + arg);
    }

    private Comparator getComparator(Class type) {
        if (Comparable.class.isAssignableFrom(type)) {
            return new ComparableComparator();
        }
        String err = "No comparator registered for type {0}";
        throw new IllegalArgumentException(MessageFormat.format(err, type));
    }

    private Arithmetic getMath(Class type) throws ParseException {
        Arithmetic math = ArithmeticFactory.getArithmetic(type);
        if (math != null) {
            return math;
        }
        String msg = "No arithmetic implemented for {0}";
        throw new ParseException(MessageFormat.format(msg, type));
    }

    private FunctorRef resolveName(StringBuffer buffer, FunctorRef prefix, String name) throws ParseException {
        buffer.append(name);
        Class c = this.findClass(buffer.toString());
        if (c != null) {
            return new GeneratorRef(new Constant<Class>(c), Class.class);
        }
        if (prefix == null) {
            return null;
        }
        return this.resolveName(prefix, name);
    }

    private FunctorRef resolveName(FunctorRef prefix, String name) throws ParseException {
        if (this.isClassReference(prefix)) {
            Class type = this.getReferencedClass(prefix);
            FunctorRef fn = EnumHandler.checkEnum(type, name);
            if (fn != null) {
                return fn;
            }
            GetField getfld = new GetField(type, name);
            fn = new GeneratorRef(new Constant(getfld.bind(null).gen()), getfld.getFieldType());
            return fn;
        }
        Class prefixType = prefix.getReturnType();
        GetField getfld = new GetField(prefixType, name);
        FunctorRef fn = this.bindUnaryFn(new UnaryFunctorRef(getfld, prefixType, "", getfld.getFieldType()), prefix);
        return fn;
    }

    protected FunctorRef resolveMethodName(FunctorRef prefix, String name, FunctorRef[] args) throws ParseException {
        Class type;
        Class[] types = this.makeTypeList(args);
        Class clazz = type = this.isClassReference(prefix) ? this.getReferencedClass(prefix) : prefix.getReturnType();
        if (types.length == 0) {
            InvokeNoArgMethod meth = new InvokeNoArgMethod(type, name);
            if (this.isClassReference(prefix)) {
                return new GeneratorRef(meth.bind(null), meth.getReturnType());
            }
            UnaryFunctorRef ref = new UnaryFunctorRef(meth, type, "", meth.getReturnType());
            return this.bindUnaryFn(ref, prefix);
        }
        FunctorRef argsRef = this.getArgExpressionList(args);
        try {
            Method method = this.resolveMethod(type, name, types);
            InvokeMethod im = new InvokeMethod(type, method);
            if (this.isClassReference(prefix)) {
                UnaryFunctorRef ref = new UnaryFunctorRef(im.bind1st(null), argsRef.getReturnType(), "", im.getReturnType());
                return this.bindUnaryFn(ref, argsRef);
            }
            BinaryFunctorRef ref = new BinaryFunctorRef(im, type, argsRef.getReturnType(), im.getReturnType());
            return this.bindBinaryFn(ref, prefix, argsRef);
        }
        catch (NoSuchMethodException x) {
            String err = "No Method {0} found";
            String msg = MessageFormat.format(err, x.getMessage());
            ParseException px = new ParseException(msg);
            px.initCause(x);
            throw px;
        }
    }

    private FunctorRef getArgExpressionList(FunctorRef[] args) throws ParseException {
        switch (this.getArgMask(args)) {
            case -2147483648: 
            case 0: {
                Generator[] gens = new Generator[args.length];
                for (int i = 0; i < args.length; ++i) {
                    gens[i] = ((GeneratorRef)args[i]).getFunctor();
                }
                ApplyGenerator listgen = new ApplyGenerator(gens);
                return new GeneratorRef(listgen, Object[].class);
            }
            case 1: 
            case 2: {
                UnaryFunctor[] ufs = new UnaryFunctor[args.length];
                for (int i = 0; i < args.length; ++i) {
                    ufs[i] = this.ensureUnary(args[i]);
                }
                ApplyUnary listun = new ApplyUnary(ufs);
                return new UnaryFunctorRef(listun, this.getArgType(0, args), this.getArgName(args), Object[].class);
            }
            case 3: {
                BinaryFunctor[] bfs = new BinaryFunctor[args.length];
                for (int i = 0; i < args.length; ++i) {
                    bfs[i] = this.ensureBinary(args[i]);
                }
                ApplyBinary listbin = new ApplyBinary(bfs);
                return new BinaryFunctorRef(listbin, this.getArgType(0, args), this.getArgType(1, args), Object[].class);
            }
        }
        String msg = "Cannot parse argument list";
        throw new ParseException(msg);
    }

    private FunctorRef resolveImportedMethod(String name, FunctorRef[] args) throws ParseException {
        Class[] argTypes = this.makeTypeList(args);
        Method method = this.findBestMethod(name, this.getImportedMethods(name), argTypes);
        if (method == null) {
            return null;
        }
        if (args.length == 0) {
            return new GeneratorRef(new InvokeNoArgMethod(method.getClass(), method).bind(null), method.getReturnType());
        }
        FunctorRef argsRef = this.getArgExpressionList(args);
        InvokeMethod im = new InvokeMethod(method.getDeclaringClass(), method);
        UnaryFunctorRef ref = new UnaryFunctorRef(im.bind1st(null), argsRef.getReturnType(), "", im.getReturnType());
        return this.bindUnaryFn(ref, argsRef);
    }

    private Method resolveMethod(Class c, String name, Class[] argTypes) throws NoSuchMethodException, ParseException {
        NoSuchMethodException firstException = null;
        try {
            return c.getMethod(name, argTypes);
        }
        catch (NoSuchMethodException x) {
            if (argTypes.length == 0) {
                throw x;
            }
            firstException = x;
            Method bestMethod = this.findBestMethod(name, c.getMethods(), argTypes);
            if (bestMethod != null) {
                return bestMethod;
            }
            throw firstException;
        }
    }

    private Method findBestMethod(String name, Method[] methods, Class[] argTypes) {
        int bestScore = Integer.MAX_VALUE;
        Method bestMethod = null;
        for (int i = 0; i < methods.length; ++i) {
            Class[] parmTypes;
            int score;
            if (!methods[i].getName().equals(name) || (score = this.scoreCompatability(parmTypes = methods[i].getParameterTypes(), argTypes)) < 0 || score >= bestScore) continue;
            score = bestScore;
            bestMethod = methods[i];
        }
        return bestMethod;
    }

    private int scoreCompatability(Class[] parmTypes, Class[] argTypes) {
        if (parmTypes.length != argTypes.length) {
            return -1;
        }
        int score = 0;
        for (int i = 0; i < parmTypes.length; ++i) {
            if (parmTypes[i] == argTypes[i]) continue;
            if (this.isBoxedType(parmTypes[i], argTypes[i]) || this.isBoxedType(argTypes[i], parmTypes[i])) {
                ++score;
                continue;
            }
            if (parmTypes[i].isAssignableFrom(argTypes[i])) {
                score += parmTypes.length;
                continue;
            }
            return -1;
        }
        return score;
    }

    private FunctorRef resolveConstructor(FunctorRef prefix, FunctorRef[] args) throws ParseException {
        if (!this.isClassReference(prefix)) {
            String msg = "{0} is not a class reference";
            throw new ParseException(MessageFormat.format(msg, prefix));
        }
        Class type = this.getReferencedClass(prefix);
        if (args.length == 0) {
            try {
                ConstructDefault ctor0 = new ConstructDefault(type);
                GeneratorRef gen = new GeneratorRef(ctor0, type);
                return gen;
            }
            catch (IllegalArgumentException x) {
                ParseException px = new ParseException(x.getMessage());
                px.initCause(x);
                throw px;
            }
        }
        Class[] argTypes = this.makeTypeList(args);
        NoSuchMethodException firstException = null;
        Constructor<Object> ctor = null;
        try {
            ctor = type.getConstructor(argTypes);
        }
        catch (NoSuchMethodException x) {
            firstException = x;
        }
        if (ctor == null) {
            Constructor<?>[] constructors = type.getConstructors();
            int bestScore = Integer.MAX_VALUE;
            for (int i = 0; i < constructors.length; ++i) {
                Class[] parmTypes = constructors[i].getParameterTypes();
                int score = this.scoreCompatability(parmTypes, argTypes);
                if (score < 0 || score >= bestScore) continue;
                score = bestScore;
                ctor = constructors[i];
            }
        }
        if (ctor != null) {
            Construct ctorfn = new Construct(ctor);
            FunctorRef argsRef = this.getArgExpressionList(args);
            UnaryFunctorRef ref = new UnaryFunctorRef(ctorfn, argsRef.getReturnType(), "", type);
            return this.bindUnaryFn(ref, argsRef);
        }
        String err = "No matching constructor found";
        ParseException px = new ParseException(err);
        px.initCause(firstException);
        throw px;
    }

    private boolean isClassReference(FunctorRef ref) {
        return ref.getReturnType().equals(Class.class) && ref.getReferenceType() == -2;
    }

    private Class getReferencedClass(FunctorRef ref) {
        return (Class)((GeneratorRef)ref).getFunctor().gen();
    }

    private Class findClass(String name) {
        Class c = (Class)this.javalang.get(name);
        if (c != null) {
            return c;
        }
        Object val = this.imports.get(name);
        if (val instanceof Class) {
            return (Class)val;
        }
        if (val != null) {
            name = val.toString();
        }
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException x) {
            return null;
        }
    }

    private Character decodeChar(StringBuffer str) throws ParseException {
        char c0 = str.charAt(0);
        if (c0 != '\\') {
            str.deleteCharAt(0);
            return new Character(c0);
        }
        char c1 = str.charAt(1);
        switch (c1) {
            case '\\': {
                str.delete(0, 2);
                return new Character('\\');
            }
            case 'n': {
                str.delete(0, 2);
                return new Character('\n');
            }
            case 't': {
                str.delete(0, 2);
                return new Character('\t');
            }
            case 'b': {
                str.delete(0, 2);
                return new Character('\b');
            }
            case 'r': {
                str.delete(0, 2);
                return new Character('\r');
            }
            case 'f': {
                str.delete(0, 2);
                return new Character('\f');
            }
            case '\'': {
                str.delete(0, 2);
                return new Character('\'');
            }
            case '\"': {
                str.delete(0, 2);
                return new Character('\"');
            }
            case 'u': {
                throw new ParseException("Unicode should have been interpreted by the input stream");
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': {
                char c2;
                if (str.length() >= 4) {
                    c2 = str.charAt(2);
                    char c3 = str.charAt(3);
                    if (c2 >= '0' && c2 <= '7' && c3 >= '0' && c3 <= '7') {
                        char c = (char)Integer.decode("0" + str.substring(1, 4)).intValue();
                        str.delete(0, 4);
                        return new Character(c);
                    }
                }
            }
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                if (str.length() < 3) {
                    str.delete(0, 2);
                    return new Character((char)Character.digit(c1, 8));
                }
                char c2 = str.charAt(2);
                if (c2 >= '0' && c2 <= '7') {
                    char c = (char)Integer.decode("0" + str.substring(1, 3)).intValue();
                    str.delete(0, 3);
                    return new Character(c);
                }
                str.delete(0, 2);
                return new Character((char)Character.digit(c1, 8));
            }
        }
        throw new ParseException("Unknown leading character \"" + str + "\"");
    }

    private Class[] makeTypeList(FunctorRef[] args) {
        Class[] types = new Class[args.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = args[i].getReturnType();
        }
        return types;
    }

    private BinaryFunctor startStringConcat(Class type) {
        return this.invokeAppendString.distribute(this.buildStringBuffer(type), new ArrayUnary());
    }

    private UnaryFunctor buildStringBuffer(Class type) {
        UnaryFunctor ctor = new ConstructUnary<String, StringBuffer>(String.class, StringBuffer.class);
        if (!type.equals(String.class)) {
            ctor = ctor.compose(new DefaultFormat());
        }
        return ctor;
    }

    private BinaryFunctor continueStringConcat() {
        return this.invokeAppendString.distribute(new Identity(), new ArrayUnary());
    }

    public final FunctorRef Functor() throws ParseException {
        FunctorRef fn = this.CompoundExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 26: {
                this.jj_consume_token(26);
                break;
            }
        }
        this.jj_consume_token(0);
        return fn;
    }

    public final FunctorRef CompoundExpression() throws ParseException {
        FunctorRef fn = new GeneratorRef(new Constant<Object>(null), Void.TYPE);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 43: 
            case 44: 
            case 48: 
            case 49: {
                fn = this.Expression();
                break;
            }
        }
        while (this.jj_2_1(2)) {
            this.jj_consume_token(26);
            FunctorRef fn2 = this.Expression();
            fn = this.bindCompoundFunctors(fn, fn2);
        }
        return fn;
    }

    public final FunctorRef Expression() throws ParseException {
        FunctorRef fn = this.ConditionalExpression();
        return fn;
    }

    public final FunctorRef ConditionalExpression() throws ParseException {
        FunctorRef trueExp = null;
        FunctorRef falseExp = null;
        FunctorRef condExp = this.ConditionalOrExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                this.jj_consume_token(27);
                trueExp = this.Expression();
                this.jj_consume_token(28);
                falseExp = this.Expression();
                break;
            }
        }
        if (trueExp == null || falseExp == null) {
            return condExp;
        }
        return this.bindConditional(condExp, trueExp, falseExp);
    }

    public final FunctorRef ConditionalOrExpression() throws ParseException {
        FunctorRef lop = this.ConditionalAndExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            Class lopType = lop.getReturnType();
            this.jj_consume_token(29);
            BinaryFunctorRef bf = new BinaryFunctorRef(new LogicalOr(), Boolean.class, Boolean.class, Boolean.class);
            FunctorRef rop = this.ConditionalAndExpression();
            lop = this.bindConditionalLogic("||", lop, rop);
        }
        return lop;
    }

    public final FunctorRef ConditionalAndExpression() throws ParseException {
        FunctorRef lop = this.OrExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            Class lopType = lop.getReturnType();
            this.jj_consume_token(30);
            BinaryFunctorRef bf = new BinaryFunctorRef(new LogicalAnd(), Boolean.class, Boolean.class, Boolean.class);
            FunctorRef rop = this.OrExpression();
            lop = this.bindConditionalLogic("&&", lop, rop);
        }
        return lop;
    }

    public final FunctorRef OrExpression() throws ParseException {
        FunctorRef lop = this.XorExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 31: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            Class lopType = lop.getReturnType();
            this.jj_consume_token(31);
            BinaryFunctorRef bf = lopType.equals(Boolean.class) ? new BinaryFunctorRef(new LogicalOr(), lopType, lopType, lopType) : new BinaryFunctorRef(new BitwiseOr(lopType), lopType, lopType, lopType);
            FunctorRef rop = this.XorExpression();
            lop = this.bindBinaryFn(bf, lop, rop);
        }
        return lop;
    }

    public final FunctorRef XorExpression() throws ParseException {
        FunctorRef lop = this.AndExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 32: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            Class lopType = lop.getReturnType();
            this.jj_consume_token(32);
            BinaryFunctorRef bf = lopType.equals(Boolean.class) ? new BinaryFunctorRef(new NotEqualTo(), lopType, lopType, lopType) : new BinaryFunctorRef(new BitwiseXor(lopType), lopType, lopType, lopType);
            FunctorRef rop = this.AndExpression();
            lop = this.bindBinaryFn(bf, lop, rop);
        }
        return lop;
    }

    public final FunctorRef AndExpression() throws ParseException {
        FunctorRef lop = this.EqualityExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            Class lopType = lop.getReturnType();
            this.jj_consume_token(33);
            BinaryFunctorRef bf = lopType.equals(Boolean.class) ? new BinaryFunctorRef(new LogicalAnd(), lopType, lopType, lopType) : new BinaryFunctorRef(new BitwiseAnd(lopType), lopType, lopType, lopType);
            FunctorRef rop = this.EqualityExpression();
            lop = this.bindBinaryFn(bf, lop, rop);
        }
        return lop;
    }

    public final FunctorRef EqualityExpression() throws ParseException {
        FunctorRef lop = this.InstanceOfExpression();
        block7: while (true) {
            BinaryFunctorRef bf;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 34: 
                case 35: {
                    break;
                }
                default: {
                    break block7;
                }
            }
            Class lopType = lop.getReturnType();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 34: {
                    this.jj_consume_token(34);
                    bf = new BinaryFunctorRef(new EqualTo(), lopType, lopType, Boolean.class);
                    break;
                }
                case 35: {
                    this.jj_consume_token(35);
                    bf = new BinaryFunctorRef(new NotEqualTo(), lopType, lopType, Boolean.class);
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            FunctorRef rop = this.InstanceOfExpression();
            lop = this.bindBinaryFn(bf, lop, rop);
        }
        return lop;
    }

    public final FunctorRef InstanceOfExpression() throws ParseException {
        FunctorRef fn = this.RelationalExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                FunctorRef classref = this.ClassOrInterfaceType();
                if (this.isClassReference(classref)) {
                    Class type = (Class)((GeneratorRef)classref).getFunctor().gen();
                    InstanceOf inst = new InstanceOf(type);
                    fn = this.bindUnaryFn(new UnaryFunctorRef(inst, fn.getReturnType(), "?", Boolean.class), fn);
                    break;
                }
                String msg = "instanceof may only be applied to constant class reference";
                throw new ParseException(msg);
            }
        }
        return fn;
    }

    public final FunctorRef RelationalExpression() throws ParseException {
        FunctorRef lop = this.ShiftExpression();
        block9: while (true) {
            BinaryFunctorRef bf;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 36: 
                case 37: 
                case 38: 
                case 39: {
                    break;
                }
                default: {
                    break block9;
                }
            }
            Class lopType = lop.getReturnType();
            Comparator comp = this.getComparator(lopType);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 36: {
                    this.jj_consume_token(36);
                    bf = new BinaryFunctorRef(new Less(comp), lopType, lopType, Boolean.class);
                    break;
                }
                case 37: {
                    this.jj_consume_token(37);
                    bf = new BinaryFunctorRef(new Greater(comp), lopType, lopType, Boolean.class);
                    break;
                }
                case 38: {
                    this.jj_consume_token(38);
                    bf = new BinaryFunctorRef(new LessEqual(comp), lopType, lopType, Boolean.class);
                    break;
                }
                case 39: {
                    this.jj_consume_token(39);
                    bf = new BinaryFunctorRef(new GreaterEqual(comp), lopType, lopType, Boolean.class);
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            FunctorRef rop = this.ShiftExpression();
            lop = this.bindBinaryFn(bf, lop, rop);
        }
        return lop;
    }

    public final FunctorRef ShiftExpression() throws ParseException {
        FunctorRef lop = this.AdditiveExpression();
        block8: while (true) {
            BinaryFunctorRef bf;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 40: 
                case 41: 
                case 42: {
                    break;
                }
                default: {
                    break block8;
                }
            }
            Class lopType = lop.getReturnType();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 40: {
                    this.jj_consume_token(40);
                    bf = new BinaryFunctorRef(new ShiftLeft(lopType), lopType, Integer.class, lopType);
                    break;
                }
                case 41: {
                    this.jj_consume_token(41);
                    bf = new BinaryFunctorRef(new ShiftRight(lopType), lopType, Integer.class, lopType);
                    break;
                }
                case 42: {
                    this.jj_consume_token(42);
                    bf = new BinaryFunctorRef(new UnsignedShiftRight(lopType), lopType, Integer.class, lopType);
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            FunctorRef rop = this.AdditiveExpression();
            lop = this.bindBinaryFn(bf, lop, rop);
        }
        return lop;
    }

    public final FunctorRef AdditiveExpression() throws ParseException {
        UnaryFunctorRef format;
        FunctorRef lop = this.MultiplicativeExpression();
        block7: while (true) {
            BinaryFunctorRef bf;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 43: 
                case 44: {
                    break;
                }
                default: {
                    break block7;
                }
            }
            Class lopType = lop.getReturnType();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 43: {
                    this.jj_consume_token(43);
                    bf = new BinaryFunctorRef(new Minus(this.getBoxedType(lopType)), lopType, lopType, lopType);
                    break;
                }
                case 44: {
                    this.jj_consume_token(44);
                    if (lopType.equals(String.class)) {
                        bf = new BinaryFunctorRef(this.startStringConcat(String.class), String.class, String.class, StringBuffer.class);
                        break;
                    }
                    if (lopType.equals(StringBuffer.class)) {
                        bf = new BinaryFunctorRef(this.continueStringConcat(), lopType, Object.class, StringBuffer.class);
                        break;
                    }
                    bf = new BinaryFunctorRef(new Plus(this.getBoxedType(lopType)), lopType, lopType, lopType);
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            FunctorRef rop = this.MultiplicativeExpression();
            if (bf.getReturnType().equals(StringBuffer.class)) {
                if (!rop.getReturnType().equals(String.class)) {
                    format = new UnaryFunctorRef(new DefaultFormat(), rop.getReturnType(), "?", String.class);
                    rop = this.bindUnaryFn(format, rop);
                }
            } else if (rop.getReturnType().equals(String.class)) {
                UnaryFunctor ctor = this.buildStringBuffer(lop.getReturnType());
                UnaryFunctorRef ctorRef = new UnaryFunctorRef(ctor, lop.getReturnType(), "?", StringBuffer.class);
                lop = this.bindUnaryFn(ctorRef, lop);
                bf = new BinaryFunctorRef(this.continueStringConcat(), StringBuffer.class, String.class, StringBuffer.class);
            }
            lop = this.bindBinaryFn(bf, lop, rop);
        }
        if (lop.getReturnType().equals(StringBuffer.class)) {
            format = new UnaryFunctorRef(new DefaultFormat(), StringBuffer.class, "?", String.class);
            return this.bindUnaryFn(format, lop);
        }
        return lop;
    }

    public final FunctorRef MultiplicativeExpression() throws ParseException {
        FunctorRef lop = this.UnaryExpression();
        block8: while (true) {
            BinaryFunctorRef bf;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 45: 
                case 46: 
                case 47: {
                    break;
                }
                default: {
                    break block8;
                }
            }
            Class lopType = lop.getReturnType();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 45: {
                    this.jj_consume_token(45);
                    bf = new BinaryFunctorRef(new Multiplies(this.getBoxedType(lopType)), lopType, lopType, lopType);
                    break;
                }
                case 46: {
                    this.jj_consume_token(46);
                    bf = new BinaryFunctorRef(new Divides(this.getBoxedType(lopType)), lopType, lopType, lopType);
                    break;
                }
                case 47: {
                    this.jj_consume_token(47);
                    bf = new BinaryFunctorRef(new Modulus(this.getBoxedType(lopType)), lopType, lopType, lopType);
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            FunctorRef rop = this.UnaryExpression();
            lop = this.bindBinaryFn(bf, lop, rop);
        }
        return lop;
    }

    public final FunctorRef UnaryExpression() throws ParseException {
        int operator = 0;
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            FunctorRef operand = this.CastExpression();
            return operand;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 43: 
            case 44: 
            case 48: 
            case 49: {
                block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 43: 
                    case 44: 
                    case 48: 
                    case 49: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 44: {
                                this.jj_consume_token(44);
                                operator = 43;
                                break block3;
                            }
                            case 43: {
                                this.jj_consume_token(43);
                                operator = 45;
                                break block3;
                            }
                            case 48: {
                                this.jj_consume_token(48);
                                operator = 126;
                                break block3;
                            }
                            case 49: {
                                this.jj_consume_token(49);
                                operator = 33;
                                break block3;
                            }
                        }
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                FunctorRef operand = this.PrimaryExpression();
                Class type = operand.getReturnType();
                switch (operator) {
                    case 43: {
                        Arithmetic math = this.getMath(type);
                        return operand;
                    }
                    case 45: {
                        Arithmetic math = this.getMath(type);
                        Negate uf = new Negate(type);
                        return this.bindUnaryFn(new UnaryFunctorRef(uf, type, "?", type), operand);
                    }
                    case 126: {
                        Arithmetic math = this.getMath(type);
                        BitwiseNot uf = new BitwiseNot(type);
                        return this.bindUnaryFn(new UnaryFunctorRef(uf, type, "?", type), operand);
                    }
                    case 33: {
                        LogicalNot uf = new LogicalNot();
                        return this.bindUnaryFn(new UnaryFunctorRef(uf, Boolean.class, "?", Boolean.class), operand);
                    }
                }
                return operand;
            }
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void CastLookahead() throws ParseException {
        this.jj_consume_token(14);
        this.ClassOrInterfaceType();
        this.jj_consume_token(50);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 49: {
                this.jj_consume_token(49);
                break;
            }
            case 14: {
                this.jj_consume_token(14);
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 19: 
            case 21: 
            case 22: {
                this.Literal();
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final FunctorRef CastExpression() throws ParseException {
        this.jj_consume_token(14);
        FunctorRef cast = this.ClassOrInterfaceType();
        this.jj_consume_token(50);
        FunctorRef fn = this.UnaryExpression();
        if (this.isClassReference(cast)) {
            Class type = (Class)((GeneratorRef)cast).getFunctor().gen();
            UnaryFunctorRef convert = Number.class.isAssignableFrom(type) ? new UnaryFunctorRef(new ValueOf(type).compose(new Cast<Number>(Number.class)), Object.class, "?", type) : new UnaryFunctorRef(new Cast(type), Object.class, "?", type);
            return this.bindUnaryFn(convert, fn);
        }
        throw new Error("Missing return statement in function");
    }

    public final FunctorRef PrimaryExpression() throws ParseException {
        FunctorRef fn = this.PrimaryPrefix();
        while (this.jj_2_3(2)) {
            fn = this.PrimarySuffix(fn);
        }
        return fn;
    }

    public final FunctorRef PrimaryPrefix() throws ParseException {
        FunctorRef fn;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 19: 
            case 21: 
            case 22: {
                fn = this.Literal();
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                if (this.thisObj == null) {
                    String msg = "\"this\" has not been bound to any particular object";
                    throw new ParseException(msg);
                }
                fn = new GeneratorRef(new Constant<Object>(this.thisObj), this.thisObj.getClass());
                break;
            }
            case 14: {
                this.jj_consume_token(14);
                fn = this.Expression();
                this.jj_consume_token(50);
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                fn = this.AllocationExpression();
                break;
            }
            default: {
                if (this.jj_2_4(Integer.MAX_VALUE)) {
                    fn = this.ImportedStaticMethodCall();
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: {
                        fn = this.Name();
                        break block0;
                    }
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return fn;
    }

    public final FunctorRef AllocationExpression() throws ParseException {
        FunctorRef fn = this.ClassOrInterfaceType();
        FunctorRef[] args = this.Arguments();
        fn = this.resolveConstructor(fn, args);
        return fn;
    }

    public final FunctorRef ClassOrInterfaceType() throws ParseException {
        FunctorRef fn = null;
        StringBuffer buffer = new StringBuffer();
        Token t = this.jj_consume_token(23);
        Class type = (Class)this.arguments.get(t.image);
        if (type != null) {
            return new UnaryFunctorRef(new Identity(), type, t.image, type);
        }
        if (fn == null) {
            fn = this.resolveName(buffer, fn, t.image);
        }
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 51: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            this.jj_consume_token(51);
            buffer.append(".");
            t = this.jj_consume_token(23);
            fn = this.resolveName(buffer, fn, t.image);
        }
        if (fn == null) {
            String msg = "Unable to parse \"{0}\"";
            throw new ParseException(MessageFormat.format(msg, buffer));
        }
        return fn;
    }

    public final FunctorRef PrimarySuffix(FunctorRef prefix) throws ParseException {
        FunctorRef fn;
        if (this.jj_2_5(2)) {
            this.jj_consume_token(51);
            this.jj_consume_token(7);
            if (this.isClassReference(prefix)) {
                return prefix;
            }
            String msg = ".class may only be applied to constant class reference";
            throw new ParseException(msg);
        }
        if (this.jj_2_6(3)) {
            this.jj_consume_token(51);
            Token t = this.jj_consume_token(23);
            FunctorRef[] args = this.Arguments();
            fn = this.resolveMethodName(prefix, t.image, args);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 51: {
                    this.jj_consume_token(51);
                    Token t = this.jj_consume_token(23);
                    FunctorRef subFn = this.reservedField(prefix, t.image);
                    fn = subFn != null ? subFn : this.resolveName(prefix, t.image);
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return fn;
    }

    public final void ImportedMethodLookahead() throws ParseException {
        this.jj_consume_token(23);
        this.jj_consume_token(14);
    }

    public final FunctorRef ImportedStaticMethodCall() throws ParseException {
        FunctorRef fn = null;
        Token t = this.jj_consume_token(23);
        FunctorRef[] args = this.Arguments();
        fn = this.resolveImportedMethod(t.image, args);
        if (fn == null) {
            fn = this.reservedFunction(t.image, args);
        }
        if (fn == null) {
            String msg = "Unable to parse \"{0}\" taking args {1}";
            throw new ParseException(MessageFormat.format(msg, t.image, args));
        }
        return fn;
    }

    public final FunctorRef Name() throws ParseException {
        FunctorRef fn = null;
        StringBuffer buffer = new StringBuffer();
        Token t = this.jj_consume_token(23);
        Class type = (Class)this.arguments.get(t.image);
        if (type != null) {
            return new UnaryFunctorRef(new Identity(), type, t.image, type);
        }
        Field field = this.getImportedField(t.image);
        if (field != null) {
            try {
                Constant<Object> gen = Modifier.isFinal(field.getModifiers()) ? new Constant<Object>(field.get(null)) : new GetField(field.getDeclaringClass(), field).bind(null);
                fn = new GeneratorRef(gen, field.getType());
            }
            catch (IllegalAccessException x) {
                throw new ParseException(x.getMessage());
            }
        }
        if (fn == null) {
            fn = this.reservedWord(t.image);
        }
        if (fn == null) {
            fn = this.resolveName(buffer, fn, t.image);
        }
        while (this.jj_2_7(Integer.MAX_VALUE) && this.getToken((int)3).kind != 14) {
            this.jj_consume_token(51);
            buffer.append(".");
            t = this.jj_consume_token(23);
            FunctorRef subFn = this.reservedField(fn, t.image);
            fn = subFn != null ? subFn : this.resolveName(buffer, fn, t.image);
        }
        if (fn == null) {
            String msg = "Unable to parse \"{0}\"";
            throw new ParseException(MessageFormat.format(msg, buffer));
        }
        return fn;
    }

    public final FunctorRef[] Arguments() throws ParseException {
        FunctorRef[] args = new FunctorRef[]{};
        this.jj_consume_token(14);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 43: 
            case 44: 
            case 48: 
            case 49: {
                args = this.ArgumentList(args);
                break;
            }
        }
        this.jj_consume_token(50);
        return args;
    }

    public final FunctorRef[] ArgumentList(FunctorRef[] args) throws ParseException {
        ArrayList<FunctorRef> argList = new ArrayList<FunctorRef>();
        FunctorRef fn = this.Expression();
        argList.add(fn);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 52: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            this.jj_consume_token(52);
            fn = this.Expression();
            argList.add(fn);
        }
        return argList.toArray(args);
    }

    public final FunctorRef Literal() throws ParseException {
        FunctorRef fn;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                fn = this.Integer();
                break;
            }
            case 19: {
                fn = this.Float();
                break;
            }
            case 8: 
            case 13: {
                fn = this.Boolean();
                break;
            }
            case 21: {
                fn = this.Character();
                break;
            }
            case 22: {
                fn = this.String();
                break;
            }
            case 11: {
                fn = this.Null();
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return fn;
    }

    public final FunctorRef Integer() throws ParseException {
        Token t = this.jj_consume_token(15);
        char suffix = t.image.charAt(t.image.length() - 1);
        if (suffix == 'L' || suffix == 'l') {
            String img = t.image.substring(0, t.image.length() - 1);
            return new GeneratorRef(new Constant<Long>(Long.decode(img)), Long.class);
        }
        return new GeneratorRef(new Constant<Integer>(Integer.decode(t.image)), Integer.class);
    }

    public final FunctorRef Float() throws ParseException {
        Token t = this.jj_consume_token(19);
        String img = t.image;
        char suffix = img.charAt(t.image.length() - 1);
        if (suffix == 'F' || suffix == 'f') {
            img = img.substring(0, t.image.length() - 1);
            return new GeneratorRef(new Constant<Float>(new Float(img)), Float.class);
        }
        if (suffix == 'D' || suffix == 'd') {
            img = img.substring(0, t.image.length() - 1);
            return new GeneratorRef(new Constant<Double>(new Double(t.image)), Double.class);
        }
        if (this.isUndecoratedDecimal()) {
            return new GeneratorRef(new Constant<BigDecimal>(new BigDecimal(t.image)), BigDecimal.class);
        }
        return new GeneratorRef(new Constant<Double>(new Double(t.image)), Double.class);
    }

    public final FunctorRef Boolean() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                this.jj_consume_token(13);
                return new GeneratorRef(new Constant<Boolean>(Boolean.TRUE), Boolean.class);
            }
            case 8: {
                this.jj_consume_token(8);
                return new GeneratorRef(new Constant<Boolean>(Boolean.FALSE), Boolean.class);
            }
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final FunctorRef Character() throws ParseException {
        Token t = this.jj_consume_token(21);
        String contents = t.image.substring(1, t.image.length() - 1);
        StringBuffer buffer = new StringBuffer(contents);
        Character c = this.decodeChar(buffer);
        if (buffer.length() != 0) {
            throw new ParseException("Unknown character " + t.image);
        }
        return new GeneratorRef(new Constant<Character>(c), Character.class);
    }

    public final FunctorRef String() throws ParseException {
        Token t = this.jj_consume_token(22);
        String contents = t.image.substring(1, t.image.length() - 1);
        StringBuffer buffer = new StringBuffer(contents);
        StringBuffer value = new StringBuffer(contents.length());
        while (buffer.length() > 0) {
            value.append(this.decodeChar(buffer).charValue());
        }
        return new GeneratorRef(new Constant<String>(value.toString()), String.class);
    }

    public final FunctorRef Null() throws ParseException {
        this.jj_consume_token(11);
        return new GeneratorRef(new Constant<Object>(null), Object.class);
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_1();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_2();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_3();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_4();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_5();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_6();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_7();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private final boolean jj_3R_44() {
        return this.jj_scan_token(8);
    }

    private final boolean jj_3R_38() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_43()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_44()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_43() {
        return this.jj_scan_token(13);
    }

    private final boolean jj_3R_25() {
        return this.jj_3R_28();
    }

    private final boolean jj_3_7() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        return this.jj_scan_token(23);
    }

    private final boolean jj_3R_24() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        return this.jj_scan_token(23);
    }

    private final boolean jj_3R_49() {
        return this.jj_3R_50();
    }

    private final boolean jj_3R_45() {
        return this.jj_3R_46();
    }

    private final boolean jj_3_6() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_3R_20();
    }

    private final boolean jj_3R_23() {
        return this.jj_3R_27();
    }

    private final boolean jj_3_4() {
        return this.jj_3R_19();
    }

    private final boolean jj_3R_21() {
        return this.jj_3R_25();
    }

    private final boolean jj_3R_68() {
        return this.jj_3R_70();
    }

    private final boolean jj_3R_67() {
        return this.jj_3R_69();
    }

    private final boolean jj_3R_37() {
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_66() {
        return this.jj_scan_token(10);
    }

    private final boolean jj_3R_65() {
        return this.jj_scan_token(14);
    }

    private final boolean jj_3R_16() {
        return this.jj_3R_21();
    }

    private final boolean jj_3R_48() {
        return this.jj_3R_49();
    }

    private final boolean jj_3R_42() {
        return this.jj_3R_45();
    }

    private final boolean jj_3_5() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        return this.jj_scan_token(7);
    }

    private final boolean jj_3R_64() {
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_61() {
        return this.jj_scan_token(49);
    }

    private final boolean jj_3R_60() {
        return this.jj_scan_token(48);
    }

    private final boolean jj_3R_63() {
        return this.jj_3R_27();
    }

    private final boolean jj_3R_59() {
        return this.jj_scan_token(43);
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        return this.jj_3R_16();
    }

    private final boolean jj_3R_18() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_5()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_6()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_24()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_58() {
        return this.jj_scan_token(44);
    }

    private final boolean jj_3R_56() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_58()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_59()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_60()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_61()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_36() {
        return this.jj_scan_token(15);
    }

    private final boolean jj_3_2() {
        return this.jj_3R_17();
    }

    private final boolean jj_3R_70() {
        return this.jj_scan_token(23);
    }

    private final boolean jj_3R_62() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_63()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_64()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_65()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_66()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_67()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_68()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_34() {
        return this.jj_3R_41();
    }

    private final boolean jj_3R_33() {
        return this.jj_3R_40();
    }

    private final boolean jj_3R_32() {
        return this.jj_3R_39();
    }

    private final boolean jj_3R_31() {
        return this.jj_3R_38();
    }

    private final boolean jj_3R_30() {
        return this.jj_3R_37();
    }

    private final boolean jj_3R_29() {
        return this.jj_3R_36();
    }

    private final boolean jj_3R_54() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_56()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_57();
    }

    private final boolean jj_3_3() {
        return this.jj_3R_18();
    }

    private final boolean jj_3R_53() {
        return this.jj_3R_55();
    }

    private final boolean jj_3R_52() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_53()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_54()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_27() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_29()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_30()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_31()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_32()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_33()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_34()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_41() {
        return this.jj_scan_token(11);
    }

    private final boolean jj_3R_57() {
        return this.jj_3R_62();
    }

    private final boolean jj_3R_35() {
        return this.jj_3R_42();
    }

    private final boolean jj_3R_47() {
        return this.jj_3R_48();
    }

    private final boolean jj_3R_40() {
        return this.jj_scan_token(22);
    }

    private final boolean jj_3R_26() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        return this.jj_scan_token(23);
    }

    private final boolean jj_3R_69() {
        return this.jj_scan_token(23);
    }

    private final boolean jj_3R_28() {
        return this.jj_3R_35();
    }

    private final boolean jj_3R_46() {
        return this.jj_3R_47();
    }

    private final boolean jj_3R_50() {
        return this.jj_3R_51();
    }

    private final boolean jj_3R_19() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_scan_token(14);
    }

    private final boolean jj_3R_55() {
        return this.jj_scan_token(14);
    }

    private final boolean jj_3R_20() {
        return this.jj_scan_token(14);
    }

    private final boolean jj_3R_39() {
        return this.jj_scan_token(21);
    }

    private final boolean jj_3R_22() {
        Token xsp;
        if (this.jj_scan_token(23)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_26());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_51() {
        return this.jj_3R_52();
    }

    private final boolean jj_3R_17() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_3R_22()) {
            return true;
        }
        if (this.jj_scan_token(50)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(49)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(14)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(23)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(12)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(10)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_23()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    public JFXGParser(InputStream stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new JFXGParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public JFXGParser(Reader stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new JFXGParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public JFXGParser(JFXGParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(JFXGParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            return this.token;
        }
        this.token = oldToken;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        Token errortok = this.token.next;
        int line = errortok.beginLine;
        int column = errortok.beginColumn;
        String mess = errortok.kind == 0 ? tokenImage[0] : errortok.image;
        return new ParseException("Parse error at line " + line + ", column " + column + ".  Encountered: " + mess);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        boxedTypes = new HashMap();
        unboxedTypes = new HashMap();
        boxFunctors = new HashMap();
        unboxFunctors = new HashMap();
        boxedTypes.put(Boolean.TYPE, Boolean.class);
        boxedTypes.put(Character.TYPE, Character.class);
        boxedTypes.put(Byte.TYPE, Byte.class);
        boxedTypes.put(Short.TYPE, Short.class);
        boxedTypes.put(Integer.TYPE, Integer.class);
        boxedTypes.put(Long.TYPE, Long.class);
        boxedTypes.put(Float.TYPE, Float.class);
        boxedTypes.put(Double.TYPE, Double.class);
        boxedTypes.put(Void.TYPE, Object.class);
        unboxedTypes.put(Boolean.class, Boolean.TYPE);
        unboxedTypes.put(Character.class, Character.TYPE);
        unboxedTypes.put(Byte.class, Byte.TYPE);
        unboxedTypes.put(Short.class, Short.TYPE);
        unboxedTypes.put(Integer.class, Integer.TYPE);
        unboxedTypes.put(Long.class, Long.TYPE);
        unboxedTypes.put(Float.class, Float.TYPE);
        unboxedTypes.put(Double.class, Double.TYPE);
        boxFunctors.put(Boolean.TYPE, new InvokeMethod(Boolean.class, "valueOf", new Class[]{Boolean.TYPE}).bind1st(null).compose(new ArrayUnary()));
        boxFunctors.put(Character.TYPE, new ConstructUnary<Character, Character>(Character.TYPE, Character.class));
        boxFunctors.put(Byte.TYPE, new ConstructUnary<Byte, Byte>(Byte.TYPE, Byte.class));
        boxFunctors.put(Short.TYPE, new ConstructUnary<Short, Short>(Short.TYPE, Short.class));
        boxFunctors.put(Integer.TYPE, new ConstructUnary<Integer, Integer>(Integer.TYPE, Integer.class));
        boxFunctors.put(Long.TYPE, new ConstructUnary<Long, Long>(Long.TYPE, Long.class));
        boxFunctors.put(Float.TYPE, new ConstructUnary<Float, Float>(Float.TYPE, Float.class));
        boxFunctors.put(Double.TYPE, new ConstructUnary<Double, Double>(Double.TYPE, Double.class));
        boxFunctors.put(Void.TYPE, new ConstantUnary(null));
        unboxFunctors.put(Boolean.class, new InvokeNoArgMethod(Boolean.class, "booleanValue"));
        unboxFunctors.put(Character.class, new InvokeNoArgMethod(Character.class, "charValue"));
        unboxFunctors.put(Byte.class, new InvokeNoArgMethod(Byte.class, "byteValue"));
        unboxFunctors.put(Short.class, new InvokeNoArgMethod(Short.class, "shortValue"));
        unboxFunctors.put(Integer.class, new InvokeNoArgMethod(Integer.class, "intValue"));
        unboxFunctors.put(Long.class, new InvokeNoArgMethod(Long.class, "longValue"));
        unboxFunctors.put(Float.class, new InvokeNoArgMethod(Float.class, "floatValue"));
        unboxFunctors.put(Double.class, new InvokeNoArgMethod(Double.class, "doubleValue"));
        stableFunctors = new HashSet();
        stableFunctors.add(BitwiseAnd.class);
        stableFunctors.add(BitwiseNot.class);
        stableFunctors.add(BitwiseOr.class);
        stableFunctors.add(BitwiseXor.class);
        stableFunctors.add(Cast.class);
        stableFunctors.add(DefaultFormat.class);
        stableFunctors.add(Divides.class);
        stableFunctors.add(EqualTo.class);
        stableFunctors.add(Greater.class);
        stableFunctors.add(GreaterEqual.class);
        stableFunctors.add(Identity.class);
        stableFunctors.add(InstanceOf.class);
        stableFunctors.add(Less.class);
        stableFunctors.add(LessEqual.class);
        stableFunctors.add(LogicalAnd.class);
        stableFunctors.add(LogicalNot.class);
        stableFunctors.add(LogicalOr.class);
        stableFunctors.add(Minus.class);
        stableFunctors.add(Modulus.class);
        stableFunctors.add(Multiplies.class);
        stableFunctors.add(Negate.class);
        stableFunctors.add(NotEqualTo.class);
        stableFunctors.add(Plus.class);
        stableFunctors.add(ShiftLeft.class);
        stableFunctors.add(ShiftRight.class);
        stableFunctors.add(UnsignedShiftRight.class);
        stableFunctors.add(ValueOf.class);
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

