/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.swing;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import net.sf.jga.fn.BinaryFunctor;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.parser.GenericParser;
import net.sf.jga.parser.ParseException;
import net.sf.jga.util.Iterables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctorProxy {
    private static Map<Class<?>, WeakReference> proxyClasses = Collections.synchronizedMap(new WeakHashMap());
    private static final UnaryFunctor<Method, Boolean> isAddListenerMethod = GenericParser.parse("x.getName().matches(\"^add.*Listener$\")", Method.class, Boolean.class);

    public static Proxy makeListenerFor(Object obj) {
        return FunctorProxy.newProxyInstance(obj.getClass().getClassLoader(), FunctorProxy.identifyListeners(obj.getClass()));
    }

    public static Proxy newProxyInstance(ClassLoader loader, Class[] interfaces) {
        return (Proxy)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)new FunctorInvocationHandler(interfaces));
    }

    public static void register(Proxy proxy, String methodName, String expression) throws ParseException, NoSuchMethodException {
        FunctorProxy.getFunctorInvocationHandler(proxy).register(methodName, expression);
    }

    public static void register(Proxy proxy, String methodName, UnaryFunctor functor) throws NoSuchMethodException {
        FunctorProxy.getFunctorInvocationHandler(proxy).register(methodName, functor);
    }

    public static void register(Proxy proxy, Method method, UnaryFunctor functor) {
        FunctorProxy.getFunctorInvocationHandler(proxy).register(method, functor);
    }

    public static void register(Proxy proxy, Class listenerClass, Class eventClass, String methodName, UnaryFunctor functor) throws NoSuchMethodException, IllegalArgumentException {
        if (listenerClass.isInstance(proxy)) {
            Method m = listenerClass.getMethod(methodName, eventClass);
            FunctorProxy.getFunctorInvocationHandler(proxy).register(m, functor);
            return;
        }
        throw new IllegalArgumentException("This does not implement " + listenerClass.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class[] identifyListeners(Class<?> clasz) {
        Map<Class<?>, WeakReference> map = proxyClasses;
        synchronized (map) {
            WeakReference value = proxyClasses.get(clasz);
            if (value instanceof Reference) {
                return (Class[])((Reference)value).get();
            }
            HashSet interfaceSet = new HashSet();
            for (Method m : Iterables.filter(clasz.getMethods(), isAddListenerMethod)) {
                Class<?> c;
                Class<?>[] argtypes = m.getParameterTypes();
                if (argtypes.length != 1 || !EventListener.class.isAssignableFrom(c = m.getParameterTypes()[0])) continue;
                interfaceSet.add(c);
            }
            Class[] interfaceArray = interfaceSet.toArray(new Class[interfaceSet.size()]);
            proxyClasses.put(clasz, new WeakReference<Class[]>(interfaceArray));
            return interfaceArray;
        }
    }

    private static FunctorInvocationHandler getFunctorInvocationHandler(Proxy proxy) {
        return (FunctorInvocationHandler)Proxy.getInvocationHandler(proxy);
    }

    public static class FunctorInvocationHandler
    implements InvocationHandler,
    Serializable {
        private Class[] _interfaces;
        private Map<Method, UnaryFunctor> _functors = new HashMap<Method, UnaryFunctor>();
        private static final BinaryFunctor<Method, String, Boolean> isNameEq = GenericParser.parse("x.getName() == y", Method.class, String.class, Boolean.class);

        private FunctorInvocationHandler(Class[] interfaces) {
            this._interfaces = interfaces;
        }

        private Method getMethod(String name) throws NoSuchMethodException {
            UnaryFunctor<Method, Boolean> hasGivenName = isNameEq.bind2nd(name);
            for (Class iface : this._interfaces) {
                Iterator<Method> i$ = Iterables.filter(iface.getMethods(), hasGivenName).iterator();
                if (!i$.hasNext()) continue;
                Method method = i$.next();
                return method;
            }
            throw new NoSuchMethodException(name);
        }

        private void register(String methodName, String expression) throws ParseException, NoSuchMethodException {
            Method m = this.getMethod(methodName);
            UnaryFunctor<?, ?> fn = GenericParser.getInstance().parseUnary(expression, m.getParameterTypes()[0], m.getReturnType());
            this.register(m, fn);
        }

        private void register(String methodName, UnaryFunctor functor) throws NoSuchMethodException {
            Method m = this.getMethod(methodName);
            this.register(m, functor);
        }

        private void register(Method method, UnaryFunctor functor) {
            this._functors.put(method, functor);
        }

        private void unregister(Method method) {
            this._functors.remove(method);
        }

        private UnaryFunctor getFunctor(Method method) {
            return this._functors.get(method);
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            UnaryFunctor functor = this.getFunctor(method);
            if (functor != null) {
                functor.fn(objectArray[0]);
            }
            return null;
        }
    }
}

