/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.swing;

import java.awt.Color;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import net.sf.jga.fn.EvaluationException;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.fn.property.ConstructUnary;
import net.sf.jga.fn.string.DefaultFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericCellEditor<T>
extends DefaultCellEditor {
    static final long serialVersionUID = -6265710748312156901L;
    protected JTextField _component;
    private T _defaultValue;

    public GenericCellEditor(Class<T> type) {
        this(new DefaultFormat(), new ConstructUnary<String, T>(String.class, type));
    }

    public GenericCellEditor(UnaryFunctor<T, String> formatter, UnaryFunctor<String, T> parser) {
        this(formatter, parser, null);
    }

    public GenericCellEditor(UnaryFunctor<T, String> formatter, UnaryFunctor<String, T> parser, T defaultValue) {
        super(new JTextField());
        if (formatter == null) {
            String msg = "Formatter (functor) is required";
            throw new IllegalArgumentException(msg);
        }
        if (parser == null) {
            String msg = "Parser (functor) is required";
            throw new IllegalArgumentException(msg);
        }
        this._component = (JTextField)this.editorComponent;
        this._defaultValue = defaultValue;
        this.delegate = new FormattedDelegate(formatter, parser);
    }

    @Override
    public boolean stopCellEditing() {
        try {
            Object value = this.getCellEditorValue();
        }
        catch (Exception e) {
            this._component.setBorder(new LineBorder(Color.red));
            return false;
        }
        return super.stopCellEditing();
    }

    public int getHorizontalAlignment() {
        return this._component.getHorizontalAlignment();
    }

    public void setHorizontalAlignment(int alignment) {
        this._component.setHorizontalAlignment(alignment);
    }

    public String toString() {
        return "GenericTableCellEditor[" + this.delegate + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FormattedDelegate
    extends DefaultCellEditor.EditorDelegate {
        static final long serialVersionUID = -3670848351305705031L;
        private UnaryFunctor<T, String> _formatter;
        private UnaryFunctor<String, T> _parser;

        public FormattedDelegate(UnaryFunctor<T, String> formatter, UnaryFunctor<String, T> parser) {
            super(GenericCellEditor.this);
            this._formatter = formatter;
            this._parser = parser;
        }

        @Override
        public void setValue(Object value) {
            if (value != null) {
                try {
                    GenericCellEditor.this._component.setText(this._formatter.fn(value));
                    return;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            if (GenericCellEditor.this._defaultValue != null) {
                GenericCellEditor.this._component.setText(this._formatter.fn(GenericCellEditor.this._defaultValue));
                return;
            }
            GenericCellEditor.this._component.setText("");
        }

        @Override
        public Object getCellEditorValue() {
            String txt = GenericCellEditor.this._component.getText();
            if (txt == null || txt.trim().length() == 0) {
                return GenericCellEditor.this._defaultValue;
            }
            try {
                Object val = this._parser.fn(txt);
                return val;
            }
            catch (EvaluationException x) {
                return GenericCellEditor.this._defaultValue;
            }
        }

        public String toString() {
            return "FormattedDelegate[" + this._formatter + "," + this._parser + "]";
        }
    }
}

