/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.swing;

import javax.swing.table.DefaultTableCellRenderer;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.fn.string.DefaultFormat;
import net.sf.jga.util.Formattable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericTableCellRenderer<T>
extends DefaultTableCellRenderer
implements Formattable<T> {
    static final long serialVersionUID = -1084070441724877620L;
    private UnaryFunctor<T, String> _formatter;
    private boolean _formatNulls = false;

    public GenericTableCellRenderer() {
        this(new DefaultFormat(), false);
    }

    public GenericTableCellRenderer(UnaryFunctor<T, String> formatter) {
        this(formatter, false);
    }

    public GenericTableCellRenderer(UnaryFunctor<T, String> formatter, boolean formatsNulls) {
        if (formatter == null) {
            throw new IllegalArgumentException("Non-null functor required");
        }
        this._formatter = formatter;
        this._formatNulls = formatsNulls;
    }

    @Override
    protected void setValue(Object value) {
        if (value == null && !this._formatNulls) {
            this.setText("");
            return;
        }
        try {
            this.setText(this._formatter.fn(value));
        }
        catch (ClassCastException x) {
            this.setText("#" + value + "#");
        }
        catch (IllegalArgumentException x) {
            this.setText("#" + value + "#");
        }
    }

    @Override
    public String toString() {
        return "GenericTableCellRenderer[" + this._formatter + "]";
    }

    @Override
    public void setFormat(UnaryFunctor<T, String> formatter) {
        if (formatter == null) {
            throw new IllegalArgumentException("Non-null functor required");
        }
        this._formatter = formatter;
    }
}

