/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.swing;

import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.sf.jga.fn.BinaryFunctor;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.swing.GenericCellEditor;
import net.sf.jga.swing.GenericTableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericTableColumn<R, C>
extends TableColumn {
    static final long serialVersionUID = 1960293231258498520L;
    private Class<C> _coltype;
    private UnaryFunctor<R, C> _getFn;
    private BinaryFunctor<R, C, C> _setFn;

    public GenericTableColumn(Class<C> coltype, UnaryFunctor<R, C> getFn) {
        this(coltype, getFn, null);
    }

    public GenericTableColumn(Class<C> coltype, UnaryFunctor<R, C> getFn, BinaryFunctor<R, C, C> setFn) {
        this._coltype = coltype;
        this._getFn = getFn;
        this._setFn = setFn;
    }

    public GenericTableColumn(Class<C> coltype, UnaryFunctor<R, C> getFn, BinaryFunctor<R, C, C> setFn, UnaryFunctor<C, String> formatter, UnaryFunctor<String, C> parser) {
        this(coltype, getFn, setFn);
        if (formatter != null) {
            this.setCellRenderer(new GenericTableCellRenderer<C>(formatter));
            if (parser != null && setFn != null) {
                this.setCellEditor(new GenericCellEditor<C>(formatter, parser));
            }
        }
    }

    public GenericTableColumn(Class<C> coltype, UnaryFunctor<R, C> getFn, BinaryFunctor<R, C, C> setFn, TableCellRenderer renderer, TableCellEditor editor) {
        this(coltype, getFn, setFn);
        this.setCellRenderer(renderer);
        if (setFn != null) {
            this.setCellEditor(editor);
        }
    }

    public C getValueAt(R rowvalue) {
        return this._getFn.fn(rowvalue);
    }

    public void setValueAt(R rowvalue, Object obj) {
        if (this._setFn != null) {
            this._setFn.fn(rowvalue, obj);
        }
    }

    public boolean isEditable() {
        return this._setFn != null;
    }

    public Class<C> getColumnClass() {
        return this._coltype;
    }

    public String toString() {
        return super.toString() + "[" + this._getFn + "," + this._setFn + "]";
    }
}

