/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.swing;

import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumnModel;
import net.sf.jga.fn.EvaluationException;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.fn.property.GetProperty;
import net.sf.jga.fn.property.SetProperty;
import net.sf.jga.swing.GenericTableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericTableModel<T>
extends AbstractTableModel {
    static final long serialVersionUID = 8996104516840561845L;
    private Class<T> _rowtype;
    private List<T> _values;
    private DefaultTableColumnModel _columnModel = new DefaultTableColumnModel();
    private boolean _nameUsedInHeader = true;

    public GenericTableModel(Class<T> rowtype, List<T> values) {
        this._rowtype = rowtype;
        this._values = values;
    }

    public GenericTableModel(Class<T> rowtype, List<T> values, List<GenericTableColumn<T, ?>> columns) {
        this._rowtype = rowtype;
        this._values = values;
        Iterator<GenericTableColumn<T, ?>> iter = columns.iterator();
        while (iter.hasNext()) {
            this._columnModel.addColumn(iter.next());
        }
    }

    public TableColumnModel getColumnModel() {
        return this._columnModel;
    }

    public T getRowValue(int row) {
        return this._values.get(row);
    }

    public void setNameUsedInHeader(boolean b) {
        this._nameUsedInHeader = b;
    }

    public boolean isNameUsedInHeader() {
        return this._nameUsedInHeader;
    }

    public <C> GenericTableColumn<T, C> addColumn(Class<C> coltype, String name) {
        GetProperty getter = new GetProperty(this._rowtype, name);
        return this.addColumnImpl(name, new GenericTableColumn<T, C>(coltype, getter));
    }

    public <C> GenericTableColumn<T, C> addColumn(Class<C> coltype, String name, boolean editable) {
        GetProperty getter = new GetProperty(this._rowtype, name);
        SetProperty<T, C> setter = editable ? new SetProperty<T, C>(this._rowtype, name, coltype) : null;
        return this.addColumnImpl(name, new GenericTableColumn<T, C>(coltype, getter, setter));
    }

    public <C> GenericTableColumn<T, C> addColumn(Class<C> coltype, String name, UnaryFunctor<C, String> formatter) {
        GetProperty getter = new GetProperty(this._rowtype, name);
        return this.addColumnImpl(name, new GenericTableColumn<T, C>(coltype, getter, null, formatter, null));
    }

    public <C> GenericTableColumn<T, C> addColumn(Class<C> coltype, String name, UnaryFunctor<C, String> formatter, UnaryFunctor<String, C> parser) {
        GetProperty getter = new GetProperty(this._rowtype, name);
        SetProperty<T, C> setter = parser != null ? new SetProperty<T, C>(this._rowtype, name, coltype) : null;
        return this.addColumnImpl(name, new GenericTableColumn<T, C>(coltype, getter, setter, formatter, parser));
    }

    private <C> GenericTableColumn<T, C> addColumnImpl(String name, GenericTableColumn<T, C> column) {
        if (this._nameUsedInHeader) {
            column.setHeaderValue(name);
        }
        this.addColumn(column);
        return column;
    }

    public void addColumn(GenericTableColumn<T, ?> col) {
        col.setModelIndex(this.getColumnCount());
        this._columnModel.addColumn(col);
    }

    public GenericTableColumn<T, ?> getGenericColumn(int col) {
        return (GenericTableColumn)this._columnModel.getColumn(col);
    }

    @Override
    public int getRowCount() {
        return this._values.size();
    }

    @Override
    public int getColumnCount() {
        return this._columnModel.getColumnCount();
    }

    public Class getColumnClass(int col) {
        return this.getGenericColumn(col).getColumnClass();
    }

    @Override
    public String getColumnName(int col) {
        GenericTableColumn<T, ?> column = this.getGenericColumn(col);
        Object name = column.getHeaderValue();
        return name != null ? name.toString() : super.getColumnName(col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.getGenericColumn(col).isEditable();
    }

    @Override
    public Object getValueAt(int row, int col) {
        T rowvalue = this.getRowValue(row);
        GenericTableColumn<T, ?> column = this.getGenericColumn(col);
        try {
            return column.getValueAt(rowvalue);
        }
        catch (EvaluationException x) {
            x.printStackTrace();
            return "### ERROR ###";
        }
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        T rowvalue = this.getRowValue(row);
        GenericTableColumn<T, ?> column = this.getGenericColumn(col);
        assert (column.getColumnClass().isInstance(value));
        column.setValueAt(rowvalue, value);
        this.fireTableCellUpdated(row, col);
    }
}

