/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.swing.spreadsheet;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JApplet;
import javax.swing.JDesktopPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import net.sf.jga.fn.BinaryFunctor;
import net.sf.jga.fn.adaptor.ApplyBinary;
import net.sf.jga.fn.adaptor.ConstantBinary;
import net.sf.jga.fn.adaptor.Project1st;
import net.sf.jga.fn.adaptor.Project2nd;
import net.sf.jga.fn.property.ArrayUnary;
import net.sf.jga.fn.property.InvokeMethod;
import net.sf.jga.swing.spreadsheet.Controller;
import net.sf.jga.swing.spreadsheet.Spreadsheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Applet
extends JApplet {
    static final long serialVersionUID = 1879123030509834030L;
    private Spreadsheet _sheet;
    private JScrollPane _pane;
    private JDesktopPane _desktop;

    @Override
    public void init() {
        Applet.printStartupHeader();
        this._desktop = new JDesktopPane();
        this.setContentPane(this._desktop);
        this._sheet = new Spreadsheet(16, 16);
        this._sheet.setPreferredScrollableViewportSize(new Dimension(400, 250));
        this._sheet.setEditableByDefault(true);
        this._sheet.setRowSelectionInterval(0, 0);
        this._sheet.setColumnSelectionInterval(0, 0);
        Controller controller = new Controller(this._sheet);
        final JPopupMenu popupMenu = new JPopupMenu("Popup Menu");
        popupMenu.add(new JMenuItem(controller.getCellRenameCmd()));
        popupMenu.add(new JMenuItem(controller.getCellFormatCmd()));
        popupMenu.add(new JMenuItem(controller.getCellTypeCmd()));
        this._sheet.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    Spreadsheet sht = (Spreadsheet)e.getComponent();
                    Point p = e.getPoint();
                    int row = sht.rowAtPoint(p);
                    int col = sht.columnAtPoint(p);
                    sht.setRowSelectionInterval(row, row);
                    sht.setColumnSelectionInterval(col, col);
                    if (e.isPopupTrigger()) {
                        popupMenu.show(e.getComponent(), p.x, p.y);
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this._pane = new JScrollPane(this._sheet);
        this._desktop.add((Component)this._pane, JDesktopPane.DEFAULT_LAYER);
        this._sheet.setStatusHandler(new InvokeMethod(JApplet.class, "showStatus", String.class).bind1st(this).compose(new ArrayUnary()));
        controller.setPromptFunctor(this.buildPromptFunctor());
        controller.setErrorFunctor(this.buildErrorFunctor());
        String doc = this.getParameter("worksheet");
        if (doc != null) {
            try {
                URL docURL = new URL(this.getDocumentBase(), doc);
                Object obj = docURL.getContent();
                if (obj instanceof InputStream) {
                    this._sheet.readSpreadsheet((InputStream)obj);
                }
            }
            catch (IOException x) {
                System.err.println(x.getMessage());
                x.printStackTrace();
            }
        }
    }

    @Override
    public void start() {
        this._pane.setBounds(this._desktop.getBounds());
        this._pane.setVisible(true);
        this._sheet.requestFocusInWindow();
    }

    private static void printStartupHeader() {
        System.out.println("");
        System.out.println("/**");
        System.out.println(" * A Java Hacker's Worksheet");
        System.out.println(" * Copyright (c) 2004-2005  David A. Hall");
        System.out.println(" */");
        System.out.println("");
    }

    public BinaryFunctor<String, String, String> buildPromptFunctor() {
        InvokeMethod showInput = new InvokeMethod(JOptionPane.class, "showInternalInputDialog", new Class[]{Component.class, Object.class, String.class, Integer.TYPE, Icon.class, Object[].class, Object.class});
        ApplyBinary sevenArgs = new ApplyBinary(new BinaryFunctor[]{new ConstantBinary(this._desktop), new Project1st(), new ConstantBinary(UIManager.getString("OptionPane.inputDialogTitle")), new ConstantBinary(3), new ConstantBinary(null), new ConstantBinary(null), new Project2nd()});
        return showInput.bind1st(null).compose(sevenArgs);
    }

    public BinaryFunctor<String, String, ?> buildErrorFunctor() {
        InvokeMethod showError = new InvokeMethod(JOptionPane.class, "showInternalMessageDialog", new Class[]{Component.class, Object.class, String.class, Integer.TYPE});
        ApplyBinary fourArgs = new ApplyBinary(new BinaryFunctor[]{new ConstantBinary(this._desktop), new Project1st(), new Project2nd(), new ConstantBinary(0)});
        return showError.bind1st(null).compose(fourArgs);
    }
}

