/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.swing.spreadsheet;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import net.sf.jga.fn.BinaryFunctor;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.fn.adaptor.ApplyBinary;
import net.sf.jga.fn.adaptor.ConstantBinary;
import net.sf.jga.fn.adaptor.Project1st;
import net.sf.jga.fn.adaptor.Project2nd;
import net.sf.jga.fn.property.ArrayBinary;
import net.sf.jga.fn.property.ArrayUnary;
import net.sf.jga.fn.property.InvokeMethod;
import net.sf.jga.fn.property.InvokeNoArgMethod;
import net.sf.jga.fn.property.SetProperty;
import net.sf.jga.parser.FunctorParser;
import net.sf.jga.swing.GenericAction;
import net.sf.jga.swing.spreadsheet.Controller;
import net.sf.jga.swing.spreadsheet.Spreadsheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application {
    private JFrame _frame;
    private Spreadsheet _sheet = this.makeDefaultSheet();
    private FunctorParser _parser = new FunctorParser();
    private Controller _controller;
    private JFileChooser _chooser;

    public Application() {
        this._parser.bindThis(this);
        this._controller = new Controller(this._sheet);
        this._sheet.setUpdateHandler(new SetProperty<Controller, Boolean>(Controller.class, "SheetDirty", Boolean.TYPE).bind(this._controller, Boolean.TRUE));
        this.createUI(this._sheet, this._controller);
    }

    public Spreadsheet makeDefaultSheet() {
        Spreadsheet sheet = new Spreadsheet(16, 16);
        sheet.setPreferredScrollableViewportSize(new Dimension(400, 250));
        sheet.setEditableByDefault(true);
        sheet.setRowSelectionInterval(0, 0);
        sheet.setColumnSelectionInterval(0, 0);
        return sheet;
    }

    public final void createUI(Spreadsheet sheet, Controller controller) {
        final JPopupMenu popupMenu = new JPopupMenu("Popup Menu");
        popupMenu.add(new JMenuItem(controller.getCellRenameCmd()));
        popupMenu.add(new JMenuItem(controller.getCellFormatCmd()));
        popupMenu.add(new JMenuItem(controller.getCellTypeCmd()));
        sheet.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    Spreadsheet sht = (Spreadsheet)e.getComponent();
                    Point p = e.getPoint();
                    int row = sht.rowAtPoint(p);
                    int col = sht.columnAtPoint(p);
                    sht.setRowSelectionInterval(row, row);
                    sht.setColumnSelectionInterval(col, col);
                    if (e.isPopupTrigger()) {
                        popupMenu.show(e.getComponent(), p.x, p.y);
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        JLabel statusLabel = new JLabel("cell(0,0)");
        sheet.setStatusHandler(new SetProperty<JLabel, String>(JLabel.class, "Text", String.class).bind1st(statusLabel));
        this._frame = new JFrame("Application");
        this._frame.setDefaultCloseOperation(0);
        this._frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Application.this.closeWorksheet();
                System.exit(0);
            }
        });
        controller.setLoadFunctor(this.buildLoadFunctor());
        controller.setSaveFunctor(this.buildSaveFunctor());
        controller.setErrorFunctor(this.buildErrorFunctor());
        controller.setPromptFunctor(this.buildPromptFunctor());
        controller.setConfirmFunctor(this.buildConfirmFunctor());
        Container rootPane = this._frame.getContentPane();
        rootPane.setLayout(new BorderLayout(5, 5));
        JScrollPane pane = new JScrollPane(sheet);
        rootPane.add((Component)pane, "Center");
        rootPane.add((Component)statusLabel, "South");
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(controller.getFileNewCmd());
        fileMenu.add(controller.getFileOpenCmd());
        fileMenu.add(controller.getFileSaveCmd());
        fileMenu.add(controller.getFileSaveAsCmd());
        fileMenu.add(this.getFileExitCmd());
        JMenu defaultMenu = new JMenu("Default");
        defaultMenu.add(controller.getDefaultEditableCmd());
        defaultMenu.add(controller.getDefaultTypeCmd());
        defaultMenu.add(controller.getDefaultValueCmd());
        JMenu sheetMenu = new JMenu("Worksheet");
        sheetMenu.add(controller.getSheetColumnsCmd());
        sheetMenu.add(controller.getSheetRowsCmd());
        sheetMenu.add(defaultMenu);
        sheetMenu.add(controller.getImportClassCmd());
        JMenu cellMenu = new JMenu("Cell");
        cellMenu.add(controller.getCellRenameCmd());
        JMenuBar menu = new JMenuBar();
        menu.add(fileMenu);
        menu.add(sheetMenu);
        menu.add(cellMenu);
        this._frame.setJMenuBar(menu);
        this._frame.pack();
        this._frame.show();
    }

    public Action getFileExitCmd() {
        UnaryFunctor fn = new Project2nd().generate2nd(new InvokeNoArgMethod(Application.class, "closeWorksheet").bind(this));
        return new GenericAction(fn, "Exit");
    }

    public int loadFile(Spreadsheet sheet) {
        if (this.getChooser().showOpenDialog(this._frame) != 0) {
            return 2;
        }
        File file = this.getChosenFile();
        if (file == null) {
            return 2;
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            sheet.readSpreadsheet(fis);
            this._controller.setSheetSource(file.toURL());
            return 0;
        }
        catch (IOException x) {
            this._controller.notify(x.getMessage(), Controller.getExceptionName(x));
            return 2;
        }
    }

    public int saveFile(Spreadsheet sheet, boolean promptForName) {
        URL hint = this._controller.getSheetSource();
        if ((promptForName || hint == null) && this.getChooser().showSaveDialog(this._frame) != 0) {
            return 2;
        }
        File file = this.getChosenFile();
        if (file != null) {
            try {
                FileOutputStream fos = new FileOutputStream(file);
                this._controller.setSheetSource(file.toURL());
                this._sheet.writeSpreadsheet(fos);
                fos.close();
                this._controller.setSheetDirty(false);
                return 0;
            }
            catch (IOException x) {
                Throwable t = Controller.getRootCause(x);
                this._controller.notify(x.getMessage(), Controller.getExceptionName(t));
            }
        }
        return 2;
    }

    public void closeWorksheet() {
        int ans = 0;
        if (this._controller.isSheetDirty()) {
            ans = this._controller.promptAndSave();
        }
        if (ans != 2) {
            this._frame.dispose();
        }
    }

    private JFileChooser getChooser() {
        if (this._chooser != null) {
            return this._chooser;
        }
        File pwd = new File(".");
        this._chooser = new JFileChooser(pwd);
        return this._chooser;
    }

    private File getChosenFile() {
        File dir = this._chooser.getCurrentDirectory();
        if (dir == null) {
            return null;
        }
        return this._chooser.getSelectedFile();
    }

    protected Controller getController() {
        return this._controller;
    }

    public BinaryFunctor<String, String, String> buildPromptFunctor() {
        InvokeMethod showInput = new InvokeMethod(JOptionPane.class, "showInputDialog", new Class[]{Component.class, Object.class, Object.class});
        ApplyBinary threeArgs = new ApplyBinary(new BinaryFunctor[]{new ConstantBinary(this._frame), new Project1st(), new Project2nd()});
        return showInput.bind1st(null).compose(threeArgs);
    }

    public BinaryFunctor<String, String, ?> buildErrorFunctor() {
        InvokeMethod showError = new InvokeMethod(JOptionPane.class, "showMessageDialog", new Class[]{Component.class, Object.class, String.class, Integer.TYPE});
        ApplyBinary fourArgs = new ApplyBinary(new BinaryFunctor[]{new ConstantBinary(this._frame), new Project1st(), new Project2nd(), new ConstantBinary(0)});
        return showError.bind1st(null).compose(fourArgs);
    }

    public BinaryFunctor<String, String, Integer> buildConfirmFunctor() {
        InvokeMethod showConfirm = new InvokeMethod(JOptionPane.class, "showConfirmDialog", new Class[]{Component.class, Object.class, String.class, Integer.TYPE});
        ApplyBinary fourArgs = new ApplyBinary(new BinaryFunctor[]{new ConstantBinary(this._frame), new Project1st(), new Project2nd(), new ConstantBinary(1)});
        return showConfirm.bind1st(null).compose(fourArgs);
    }

    public BinaryFunctor<Spreadsheet, Boolean, Integer> buildSaveFunctor() {
        InvokeMethod getSave = new InvokeMethod(Application.class, "saveFile", new Class[]{Spreadsheet.class, Boolean.TYPE});
        return getSave.bind1st(this).compose(new ArrayBinary());
    }

    public UnaryFunctor<Spreadsheet, Integer> buildLoadFunctor() {
        InvokeMethod getLoad = new InvokeMethod(Application.class, "loadFile", new Class[]{Spreadsheet.class});
        return getLoad.bind1st(this).compose(new ArrayUnary());
    }

    public static void main(String[] args) {
        Application.printStartupHeader();
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception x) {
            System.err.println("Error loading L&F:" + x);
        }
        new Application();
    }

    private static void printStartupHeader() {
        System.out.println("");
        System.out.println("/**");
        System.out.println(" * A Java Hacker's Worksheet");
        System.out.println(" * Copyright (c) 2004-2005  David A. Hall");
        System.out.println(" */");
        System.out.println("");
    }
}

