/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.swing.spreadsheet;

import java.awt.Component;
import java.awt.Point;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.sf.jga.fn.AdaptorVisitor;
import net.sf.jga.fn.EvaluationException;
import net.sf.jga.fn.Generator;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.fn.adaptor.Constant;
import net.sf.jga.parser.ParseException;
import net.sf.jga.swing.GenericTableCellRenderer;
import net.sf.jga.swing.spreadsheet.CellReference;
import net.sf.jga.swing.spreadsheet.CircularReferenceException;
import net.sf.jga.swing.spreadsheet.InvalidReferenceException;
import net.sf.jga.swing.spreadsheet.Spreadsheet;
import net.sf.jga.util.Formattable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cell
extends Observable
implements Observer {
    private Spreadsheet _parent;
    private String _name;
    private Object _value;
    private Generator _generator;
    private String _formula;
    private Point _addr;
    private boolean _editable;
    private TableCellRenderer _renderer;
    private TableCellEditor _editor;
    private Throwable _exception;
    private String _errMsg;
    public static final String CLASS_CAST_ERR = "### CLASS ###";
    public static final String EVALUATION_ERR = "### EVAL ###";
    public static final String CIRCULAR_REF_ERR = "### CIRC ###";
    public static final String NULL_POINTER_ERR = "### NULL ###";
    public static final String REFERENCE_ERR = "### REF ###";
    public static final String UNDEFINED_ERR = "### UNDEF ###";
    public static final String PARSER_ERR = "### PARSE ###";
    private Set<Cell> _dependencies = new HashSet<Cell>();
    private boolean _inRecovery = false;

    Cell(Spreadsheet parent, Point addr, String formula, boolean editable) {
        if (formula == null || formula.trim().length() <= 0) {
            throw new IllegalArgumentException("Formula must be supplied");
        }
        this._parent = parent;
        this._addr = addr;
        this._editable = editable;
        this.setFormula(formula);
        this._renderer = new Renderer();
    }

    <T> Cell(Spreadsheet parent, Class<T> type, Point addr, Generator<T> value) {
        this._parent = parent;
        this._addr = addr;
        this._editable = false;
        this._renderer = new Renderer();
        this.setFormulaImpl(value);
    }

    Cell(Spreadsheet parent, int row, int col) {
        this._parent = parent;
        this._addr = new Point(row, col);
        this._editable = true;
        this._errMsg = UNDEFINED_ERR;
        this._value = parent.getDefaultCellValue();
    }

    Spreadsheet getParent() {
        return this._parent;
    }

    private Spreadsheet.Parser getParser() {
        return this._parent._parser;
    }

    public String getName() {
        return this._name;
    }

    void setName(String name) {
        this._name = name;
    }

    public Class getType() {
        return this._value == null ? Object.class : this._value.getClass();
    }

    String getFormula() {
        return this._formula;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public void setEditable(boolean b) {
        this._editable = b;
    }

    public Point getAddress() {
        return this._addr;
    }

    public TableCellRenderer getRenderer() {
        return this._renderer;
    }

    public void setRenderer(TableCellRenderer renderer) {
        this._renderer = renderer;
    }

    public TableCellEditor getEditor() {
        if (this._editor == null) {
            this._editor = new Editor();
        }
        return this._editor;
    }

    public void setEditor(TableCellEditor editor) {
        this._editor = editor;
    }

    public boolean isValid() {
        return this._errMsg == null;
    }

    public boolean isUndefined() {
        return this._errMsg == UNDEFINED_ERR;
    }

    public String getErrorMsg() {
        return this._errMsg;
    }

    private void setError(Throwable t, String formula, String msg) {
        Logger.global.log(Level.FINE, formula, t);
        this._exception = t;
        this._parent.setStatus(t.getMessage());
        this._formula = formula;
        this._errMsg = msg;
        this._value = t;
        this.notifyObservers();
    }

    private void clearError() {
        this._exception = null;
        this._errMsg = null;
    }

    public Object getValue() {
        return this._value;
    }

    private void setValue() {
        try {
            this._value = this._generator.gen();
            this.clearError();
        }
        catch (CircularReferenceException x) {
            this.setError(x, this._formula, CIRCULAR_REF_ERR);
        }
        catch (InvalidReferenceException x) {
            this.recover(x, this._formula, REFERENCE_ERR);
        }
        catch (NullPointerException x) {
            this.setError(x, this._formula, NULL_POINTER_ERR);
        }
        catch (ClassCastException x) {
            this.recover(x, this._formula, CLASS_CAST_ERR);
        }
        catch (EvaluationException x) {
            this.recover(x, this._formula, EVALUATION_ERR);
        }
        catch (IllegalArgumentException x) {
            this.recover(x, this._formula, EVALUATION_ERR);
        }
        catch (Exception x) {
            this.setError(x, this._formula, EVALUATION_ERR);
        }
    }

    public void clear() {
        this.doClear(null, this._parent.getDefaultCellValue());
    }

    void unlink() {
        this.doClear(REFERENCE_ERR, new InvalidReferenceException("Cell(" + this._addr.x + "," + this._addr.y + ")"));
    }

    private void doClear(String msg, Object value) {
        this.unregister();
        this._editable = true;
        this._value = value;
        this._generator = null;
        this._formula = null;
        this._errMsg = msg;
        this.notifyObservers();
    }

    public final void setValue(Object value) {
        if (value instanceof Generator) {
            this.setFormula((Generator)value);
        } else if (value != this._exception) {
            this.setFormula(new Constant<Object>(value));
        }
    }

    public final void setFormula(String formula) throws CircularReferenceException {
        if (formula == null || "".equals(formula)) {
            this.clear();
            return;
        }
        if (formula.startsWith("=")) {
            formula = formula.substring(1);
        }
        try {
            Generator gen = this.getParser().parseGenerator(this, formula);
            this.setFormula(gen);
            this._formula = formula;
        }
        catch (ParseException x) {
            this.setError(x, formula, PARSER_ERR);
        }
        catch (ClassCastException x) {
            this.recover(x, formula, CLASS_CAST_ERR);
        }
        catch (NullPointerException x) {
            this.setError(x, formula, NULL_POINTER_ERR);
        }
    }

    public final void setFormula(Generator formula) {
        this.clearError();
        this.unregister();
        this.setFormulaImpl(formula);
        this.notifyObservers();
    }

    private void setFormulaImpl(Generator formula) {
        try {
            this._generator = this.register(formula);
            this.setValue();
        }
        catch (CircularReferenceException x) {
            this.setError(x, formula.toString(), CIRCULAR_REF_ERR);
        }
    }

    private synchronized void recover(Exception x, String formula, String msg) {
        if (this._inRecovery) {
            this.setError(x, formula, msg);
        } else {
            this._inRecovery = true;
            this.setFormula(this._formula);
            if (!this.isValid() && this._errMsg.equals(PARSER_ERR)) {
                this.setError(x, formula, msg);
            }
            this._inRecovery = false;
        }
    }

    public <T> void setFormat(UnaryFunctor<T, String> formatter) {
        if (this._renderer instanceof Formattable) {
            ((Formattable)((Object)this._renderer)).setFormat(formatter);
        }
    }

    public Generator getReference() {
        return new CellReference(this);
    }

    public boolean references(Cell c) {
        if (this.getAddress().equals(c.getAddress())) {
            return true;
        }
        for (Cell c1 : this._dependencies) {
            if (c1 == c) {
                return true;
            }
            if (!c1.references(c)) continue;
            return true;
        }
        return false;
    }

    public final Iterator<Cell> dependsOn() {
        return this._dependencies.iterator();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(256);
        buf.append("Cell(").append(this._addr.x).append(",").append(this._addr.y).append(") ");
        if (this._name != null) {
            buf.append('\"').append(this._name).append('\"').append(' ');
        }
        buf.append("[");
        if (this._exception != null) {
            buf.append(this._exception.getMessage());
        } else if (this._formula != null) {
            buf.append(this._formula);
        } else {
            buf.append(this._value);
        }
        return buf.append("]").toString();
    }

    @Override
    public void update(Observable observable, Object object) {
        this.setValue();
        this.notifyObservers();
    }

    @Override
    public void notifyObservers() {
        this.setChanged();
        this.notifyObservers(this._value);
        this.clearChanged();
    }

    private <T> Generator<T> register(Generator<T> formula) throws CircularReferenceException {
        formula.accept(new RegistrationVisitor());
        return formula;
    }

    private void unregister() {
        if (this._generator != null) {
            this._generator.accept(new UnregistrationVisitor());
        }
        this._dependencies.clear();
    }

    static class Renderer
    extends GenericTableCellRenderer {
        Renderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Spreadsheet sheet = (Spreadsheet)table;
            Cell cell = sheet.getCellIfPresent(row, column);
            boolean editable = cell != null ? cell.isEditable() : sheet.isEditableByDefault();
            return super.getTableCellRendererComponent(table, value, isSelected && editable, hasFocus && editable, row, column);
        }
    }

    static class Editor
    extends DefaultCellEditor {
        static final long serialVersionUID = -9010644547311806213L;
        private Spreadsheet _sheet;
        private Cell _cell;

        public Editor() {
            super(new JTextField());
        }

        public Object getCellEditorValue() {
            String formula = (String)super.getCellEditorValue();
            if (formula.startsWith("=")) {
                formula = formula.substring(1);
            }
            try {
                return this._sheet._parser.parseGenerator(this._cell, formula);
            }
            catch (ParseException x) {
                this._cell.setError(x, formula, Cell.PARSER_ERR);
                return x;
            }
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            this._sheet = (Spreadsheet)table;
            this._cell = this._sheet.getCellAt(row, col);
            return super.getTableCellEditorComponent(table, this._cell._formula, isSelected, row, col);
        }
    }

    private class UnregistrationVisitor
    extends AdaptorVisitor
    implements CellReference.Visitor {
        private UnregistrationVisitor() {
        }

        public void visit(CellReference host) {
            host.unregister(Cell.this);
        }
    }

    private class RegistrationVisitor
    extends AdaptorVisitor
    implements CellReference.Visitor {
        private RegistrationVisitor() {
        }

        public void visit(CellReference host) {
            Cell hostCell = host.getCell();
            if (hostCell.references(Cell.this)) {
                throw new CircularReferenceException();
            }
            host.register(Cell.this);
            Cell.this._dependencies.add(hostCell);
        }
    }
}

