/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.swing.spreadsheet;

import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.Action;
import net.sf.jga.fn.BinaryFunctor;
import net.sf.jga.fn.Generator;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.fn.adaptor.ConstantBinary;
import net.sf.jga.fn.adaptor.ConstantUnary;
import net.sf.jga.fn.adaptor.Identity;
import net.sf.jga.fn.adaptor.Project2nd;
import net.sf.jga.parser.FunctorParser;
import net.sf.jga.parser.ParseException;
import net.sf.jga.swing.GenericAction;
import net.sf.jga.swing.spreadsheet.Cell;
import net.sf.jga.swing.spreadsheet.Spreadsheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Controller {
    private Spreadsheet _sheet;
    private FunctorParser _parser;
    private BinaryFunctor<String, String, String> _promptFn = new ConstantBinary<String, String, String>("");
    private BinaryFunctor<String, String, Integer> _confirmFn = new ConstantBinary<String, String, Object>(null);
    private BinaryFunctor<String, String, ?> _errorFn = new ConstantBinary<String, String, String>("");
    private UnaryFunctor<Spreadsheet, Integer> _loadFn = new ConstantUnary<Spreadsheet, Object>(null);
    private BinaryFunctor<Spreadsheet, Boolean, Integer> _saveFn = new ConstantBinary<Spreadsheet, Boolean, Object>(null);
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    private final String DIRTY_PROP = "dirty";
    private final String SOURCE_PROP = "source";

    public Controller(Spreadsheet sheet) {
        this._sheet = sheet;
        this._parser = new FunctorParser();
        this._parser.bindThis(this);
    }

    public String prompt(String msg, String val) {
        return this._promptFn.fn(msg, val);
    }

    public void setPromptFunctor(BinaryFunctor<String, String, String> fn) {
        this._promptFn = fn;
    }

    public int confirm(String msg, String title) {
        return this._confirmFn.fn(msg, title);
    }

    public void setConfirmFunctor(BinaryFunctor<String, String, Integer> fn) {
        this._confirmFn = fn;
    }

    public void notify(String msg, String title) {
        this._errorFn.fn(msg, title);
    }

    public void setErrorFunctor(BinaryFunctor<String, String, ?> fn) {
        this._errorFn = fn;
    }

    public int loadSheet(Spreadsheet sheet) {
        return this._loadFn.fn(sheet);
    }

    public void setLoadFunctor(UnaryFunctor<Spreadsheet, Integer> fn) {
        this._loadFn = fn;
    }

    public int saveSheet(Spreadsheet sheet, boolean prompt) {
        return this._saveFn.fn(sheet, prompt);
    }

    public void setSaveFunctor(BinaryFunctor<Spreadsheet, Boolean, Integer> fn) {
        this._saveFn = fn;
    }

    public Action getFileNewCmd() {
        return new GenericAction(this.parseAction("this.newWorksheet()"), "New");
    }

    public Action getFileOpenCmd() {
        return new GenericAction(this.parseAction("this.openFile()"), "Open");
    }

    public Action getFileSaveCmd() {
        return new GenericAction(this.parseAction("this.saveFile()"), "Save");
    }

    public Action getFileSaveAsCmd() {
        return new GenericAction(this.parseAction("this.saveFileAs()"), "Save As...");
    }

    public Action getDefaultEditableCmd() {
        GenericAction cmd = new GenericAction(new Identity(), "Editable");
        cmd.setEnabled(false);
        return cmd;
    }

    public Action getDefaultTypeCmd() {
        return new GenericAction(this.parseAction("this.setDefaultType()"), "Cell Type");
    }

    public Action getDefaultValueCmd() {
        return new GenericAction(this.parseAction("this.setDefaultValue()"), "Cell Value");
    }

    public Action getDefaultFormatCmd() {
        GenericAction cmd = new GenericAction(new Identity(), "Format");
        cmd.setEnabled(false);
        return cmd;
    }

    public Action getDefaultRendererCmd() {
        GenericAction cmd = new GenericAction(new Identity(), "Renderer");
        cmd.setEnabled(false);
        return cmd;
    }

    public Action getDefaultEditorCmd() {
        GenericAction cmd = new GenericAction(new Identity(), "Editor");
        cmd.setEnabled(false);
        return cmd;
    }

    public Action getSheetColumnsCmd() {
        return new GenericAction(this.parseAction("this.setColumnCount()"), "Set Column Count");
    }

    public Action getSheetRowsCmd() {
        return new GenericAction(this.parseAction("this.setRowCount()"), "Set Row Count");
    }

    public Action getImportClassCmd() {
        GenericAction cmd = new GenericAction(new Identity(), "Import Class");
        cmd.setEnabled(false);
        return cmd;
    }

    public Action getCellRenameCmd() {
        String cellNameExp = "this.setCellName(x.getSelectedRow(),x.getSelectedColumn())";
        try {
            UnaryFunctor cellNameFn = new Project2nd().generate2nd(this._parser.parseUnary(cellNameExp, Spreadsheet.class).bind(this._sheet));
            return new GenericAction(cellNameFn, "Set Name");
        }
        catch (ParseException x) {
            x.printStackTrace();
            GenericAction cmd = new GenericAction(new ConstantUnary(null), "Set Name");
            cmd.setEnabled(false);
            return cmd;
        }
    }

    public Action getCellFormatCmd() {
        GenericAction cmd = new GenericAction(new Identity(), "Set Format");
        cmd.setEnabled(false);
        return cmd;
    }

    public Action getCellTypeCmd() {
        GenericAction cmd = new GenericAction(new Identity(), "Set Type");
        cmd.setEnabled(false);
        return cmd;
    }

    public Action getCellRendererCmd() {
        GenericAction cmd = new GenericAction(new Identity(), "Set Renderer");
        cmd.setEnabled(false);
        return cmd;
    }

    public Action getCellEditorCmd() {
        GenericAction cmd = new GenericAction(new Identity(), "Set Editor");
        cmd.setEnabled(false);
        return cmd;
    }

    public Action getCellValidatorCmd() {
        GenericAction cmd = new GenericAction(new Identity(), "Set Validator");
        cmd.setEnabled(false);
        return cmd;
    }

    public void setDefaultType() {
        String prompt = "Enter default type for uninitialized cells";
        String name = this._promptFn.fn(prompt, this._sheet.getDefaultCellType().getName());
        if (name == null) {
            return;
        }
        try {
            this._sheet.setDefaultCellType(Class.forName(name));
        }
        catch (ClassNotFoundException x) {
            String fmt = "Class {0} not found";
            String msg = MessageFormat.format(fmt, x.getMessage());
            this._errorFn.fn(msg, "ClassNotFoundException");
        }
    }

    public void setColumnCount() {
        String prompt = "Enter the number of columns";
        String countstr = this._promptFn.fn(prompt, String.valueOf(this._sheet.getColumnCount()));
        if (countstr == null) {
            return;
        }
        try {
            this._sheet.setColumnCount(Integer.parseInt(countstr));
        }
        catch (NumberFormatException x) {
            String fmt = "{0} isn't a number";
            String msg = MessageFormat.format(fmt, countstr);
            this._errorFn.fn(msg, "NumberFormatException");
        }
    }

    public void setRowCount() {
        String prompt = "Enter the number of rows";
        String countstr = this._promptFn.fn(prompt, String.valueOf(this._sheet.getRowCount()));
        if (countstr == null) {
            return;
        }
        try {
            this._sheet.setRowCount(Integer.parseInt(countstr));
        }
        catch (NumberFormatException x) {
            String fmt = "{0} isn't a number";
            String msg = MessageFormat.format(fmt, countstr);
            this._errorFn.fn(msg, "NumberFormatException");
        }
    }

    public void setDefaultValue() {
        String prompt = "Enter default value for uninitialized cells";
        String exp = this._promptFn.fn(prompt, "" + this._sheet.getDefaultCellValue());
        if (exp == null) {
            return;
        }
        try {
            Generator gen = this._sheet.getParser().parseGenerator(exp);
            this._sheet.setDefaultCellValue(gen.gen());
        }
        catch (ParseException x) {
            this._errorFn.fn(x.getMessage(), Controller.getExceptionName(Controller.getRootCause(x)));
        }
    }

    public void setCellName(int row, int col) {
        Cell cell;
        String oldName;
        String prompt = "Enter name for cell(" + row + "," + col + ")";
        String name = this._promptFn.fn(prompt, oldName = (cell = this._sheet.getCellIfPresent(row, col)) != null ? cell.getName() : "");
        if (name != null && !name.equals(oldName)) {
            this._sheet.setCellName(name, row, col);
        }
    }

    public void newWorksheet() {
        int ans = 0;
        if (this.isSheetDirty()) {
            ans = this.promptAndSave();
        }
        if (ans != 2) {
            this._sheet.clear();
            this.setSheetSource(null);
            this.setSheetDirty(false);
        }
    }

    public int openFile() {
        return this.loadSheet(this._sheet);
    }

    public int saveFile() {
        return this.saveSheet(this._sheet, false);
    }

    public int saveFileAs() {
        return this.saveSheet(this._sheet, true);
    }

    public int promptAndSave() {
        int choice;
        String msg;
        int ans;
        String format = "save {0}?";
        Object name = this.getSheetSource();
        if (name == null) {
            name = "worksheet";
        }
        if ((ans = this.confirm(msg = MessageFormat.format(format, name), msg)) == 0 && ((choice = this.saveFile()) == 2 || choice == -1)) {
            ans = 2;
        }
        return ans;
    }

    public boolean isSheetDirty() {
        Object dirtyProp = this._sheet.getClientProperty("dirty");
        return Boolean.TRUE.equals(dirtyProp);
    }

    public void setSheetDirty(boolean flag) {
        this._sheet.putClientProperty("dirty", flag);
    }

    public URL getSheetSource() {
        Object sourceURL = this._sheet.getClientProperty("source");
        if (sourceURL == null) {
            return null;
        }
        if (sourceURL instanceof URL) {
            return (URL)sourceURL;
        }
        try {
            return new File(new File("."), "worksheet1.hwks").toURL();
        }
        catch (MalformedURLException x) {
            x.printStackTrace();
            return null;
        }
    }

    public void setSheetSource(URL url) {
        this._sheet.putClientProperty("source", url);
    }

    private UnaryFunctor<ActionEvent, ?> parseAction(String exp) {
        try {
            return new Project2nd().generate2nd(this._parser.parseGenerator(exp));
        }
        catch (ParseException x) {
            x.printStackTrace();
            return null;
        }
    }

    static Throwable getRootCause(Throwable t) {
        Throwable t1 = t.getCause();
        while (t1 != null) {
            t = t1;
            t1 = t.getCause();
        }
        return t;
    }

    static String getExceptionName(Throwable t) {
        String fqcn = t.getClass().getName();
        return fqcn.substring(fqcn.lastIndexOf(".") + 1);
    }
}

