/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.swing.spreadsheet;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

class RowHeader
extends JComponent {
    static final long serialVersionUID = -1375303876648436931L;
    private JTable _table;
    private TableCellRenderer _renderer;
    private JTableHeader _header;
    private CellRendererPane _rendererPane;
    private Font _headerFont;

    public RowHeader(JTable table) {
        this._table = table;
        this._header = table.getTableHeader();
        this._renderer = this._header.getDefaultRenderer();
        this._rendererPane = new CellRendererPane();
        this.add(this._rendererPane);
        Component rendererComponent = this._renderer.getTableCellRendererComponent(this._table, "0", false, false, 0, -1);
        this._headerFont = rendererComponent.getFont();
        this.setFont(this._headerFont);
        this.setBackground(rendererComponent.getBackground());
        this.setForeground(rendererComponent.getForeground());
    }

    public TableCellRenderer getRenderer() {
        return this._renderer;
    }

    public void setRenderer(TableCellRenderer renderer) {
        this._renderer = renderer;
    }

    public void setRowCount(int count) {
        this.resize(this.getPreferredSize());
    }

    public Dimension getPreferredSize() {
        Border border = (Border)UIManager.getDefaults().get("TableHeader.cellBorder");
        Insets insets = border.getBorderInsets(this._header);
        FontMetrics metrics = this.getFontMetrics(this._headerFont);
        Dimension dim = new Dimension(metrics.stringWidth("99999") + insets.right + insets.left, this._table.getRowHeight() * this._table.getRowCount());
        return dim;
    }

    protected void paintComponent(Graphics g) {
        Rectangle cellRect = new Rectangle(0, 0, this.getWidth(), this._table.getRowHeight(0));
        int rowMargin = this._header.getColumnModel().getColumnMargin() - 1;
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            int rowHeight = this._table.getRowHeight(i);
            cellRect.height = rowHeight - rowMargin;
            this.paintCell(g, cellRect, i);
            cellRect.y += rowHeight;
        }
    }

    private void paintCell(Graphics g, Rectangle cellRect, int rowIndex) {
        Component component = this._renderer.getTableCellRendererComponent(this._table, rowIndex, false, false, rowIndex, -1);
        this._rendererPane.paintComponent(g, component, this, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }
}

