/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.swing.spreadsheet;

import java.awt.Container;
import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import net.sf.jga.fn.Generator;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.fn.adaptor.Constant;
import net.sf.jga.fn.adaptor.Identity;
import net.sf.jga.parser.FunctorParser;
import net.sf.jga.parser.FunctorRef;
import net.sf.jga.parser.GeneratorRef;
import net.sf.jga.parser.ParseException;
import net.sf.jga.swing.spreadsheet.Cell;
import net.sf.jga.swing.spreadsheet.RowHeader;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Spreadsheet
extends JTable {
    static final long serialVersionUID = -4784933072621672138L;
    transient Parser _parser = new Parser();
    private SpreadsheetTableModel _model;
    private RowHeader _rowHeader;
    private UnaryFunctor<String, ?> _statusFn = new Identity();
    private boolean _initialized;
    private Class _defaultType = Integer.class;
    private Object _defaultValue = new Integer(0);
    private boolean _strictType;
    private Generator<?> _updateFn;
    private TableCellRenderer _defaultRenderer = new Cell.Renderer();
    private int _lastRow = -1;
    private int _lastCol = -1;

    public Spreadsheet(int rows, int cols) {
        this._model = new SpreadsheetTableModel(rows, cols);
        super.setModel(this._model);
        this.setAutoCreateColumnsFromModel(false);
        this.setAutoResizeMode(0);
        this.setCellSelectionEnabled(true);
        this.setCellEditor(new Cell.Editor());
        TableColumnModel columns = this.getColumnModel();
        for (int i = 0; i < cols; ++i) {
            columns.getColumn(i).setHeaderValue(String.valueOf(i));
        }
        this.getTableHeader().setReorderingAllowed(false);
        this._rowHeader = new RowHeader(this);
        this._parser.bindThis(this);
        this._initialized = true;
    }

    public void setColumnCount(int width) {
        int oldWidth = this.getColumnCount();
        this.doSetColumnCount(oldWidth, width);
        if (width > 0 && width != oldWidth) {
            this._model.setColumnCount(width);
        }
    }

    private void doSetColumnCount(int oldWidth, int width) {
        block4: {
            if (width <= 0 || width == oldWidth) break block4;
            TableColumnModel columns = this.getColumnModel();
            if (oldWidth < width) {
                for (int i = oldWidth; i < width; ++i) {
                    TableColumn column = new TableColumn(i);
                    column.setHeaderValue(String.valueOf(i));
                    this.addColumn(column);
                }
            } else {
                for (int i = oldWidth - 1; i >= width; --i) {
                    this.removeColumn(columns.getColumn(i));
                }
            }
        }
    }

    public void setRowCount(int height) {
        if (height > 0 && height != this.getRowCount()) {
            this._model.setRowCount(height);
            this._rowHeader.setRowCount(height);
        }
    }

    public FunctorParser getParser() {
        return this._parser;
    }

    public Class getDefaultCellType() {
        return this._defaultType;
    }

    public void setDefaultCellType(Class type) {
        this._defaultType = type;
        if (this._defaultValue != null && !type.isInstance(this._defaultValue)) {
            this._defaultValue = null;
        }
    }

    public Object getDefaultCellValue() {
        return this._defaultValue;
    }

    public void setDefaultCellValue(Object value) {
        this._defaultValue = value;
        if (!this._defaultType.isInstance(value)) {
            this._defaultType = value.getClass();
        }
    }

    public void setEditableByDefault(boolean b) {
        this._model.setEditableByDefault(b);
    }

    public boolean isEditableByDefault() {
        return this._model.isEditableByDefault();
    }

    public boolean isStrictlyTyped() {
        return this._strictType;
    }

    public void setStrictTyping(boolean b) {
        this._strictType = b;
    }

    public void readSpreadsheet(InputStream is) throws IOException {
        new Reader().readSpreadsheet(is);
    }

    public void writeSpreadsheet(OutputStream os) throws IOException {
        new Writer().writeSpreadsheet(os);
    }

    public JComponent getRowHeader() {
        return this._rowHeader;
    }

    public void setStatusHandler(UnaryFunctor<String, ?> fn) {
        this._statusFn = fn;
    }

    public void setStatus(String status) {
        this._statusFn.fn(status);
    }

    public void setUpdateHandler(Generator<?> fn) {
        this._updateFn = fn;
    }

    private void fireSpreadsheetUpdated() {
        if (this._updateFn != null) {
            this._updateFn.gen();
        }
    }

    public void clearCellAt(int row, int col) {
        Cell cell = this.getCellIfPresent(row, col);
        if (cell != null) {
            cell.clear();
        }
    }

    public Cell getCellAt(int row, int col) {
        Cell cell = this.getCellIfPresent(row, col);
        if (cell == null) {
            cell = this._model.setCell(new Cell(this, row, col));
        }
        return cell;
    }

    Cell getCellIfPresent(int row, int col) {
        return this._model.getCellAt(row, col);
    }

    public <T> Cell setCellAt(Class<T> type, T value, int row, int col) {
        return this._model.setCellAt(type, new Constant<T>(value), row, col);
    }

    public <T> Cell setCellAt(Class<T> type, Generator<T> gen, int row, int col) {
        return this._model.setCellAt(type, gen, row, col);
    }

    public Cell setCellAt(String formula, int row, int col) {
        return this._model.setCellAt(formula, row, col, this._model.isEditableByDefault());
    }

    public Cell setCellAt(String formula, int row, int col, boolean editable) {
        return this._model.setCellAt(formula, row, col, editable);
    }

    public <T> void setFormatAt(UnaryFunctor<T, String> formatter, int row, int col) {
        this.getCellAt(row, col).setFormat(formatter);
    }

    public Cell getCellByName(String name) {
        return this._model.getCellByName(name);
    }

    public Cell setCellName(String name, int row, int col) {
        Cell cell = this._model.setCellName(name, row, col);
        this.setStatus(cell.toString());
        return cell;
    }

    public <T> Generator<T> getReference(Class<T> type, int row, int col) {
        return this._model.getReference(type, row, col);
    }

    public void clear() {
        this._model.clear();
        this.setRowSelectionInterval(0, 0);
        this.setColumnSelectionInterval(0, 0);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int col) {
        Cell cell = this.getCellIfPresent(row, col);
        if (cell == null) {
            return super.getCellEditor(row, col);
        }
        TableCellEditor editor = cell.getEditor();
        return editor != null ? editor : super.getCellEditor(row, col);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int col) {
        Cell cell = this.getCellIfPresent(row, col);
        if (cell == null) {
            return this._defaultRenderer;
        }
        TableCellRenderer renderer = cell.getRenderer();
        return renderer != null ? renderer : this._defaultRenderer;
    }

    @Override
    public void setModel(TableModel model) {
        if (!this._initialized) {
            super.setModel(model);
        } else if (model instanceof SpreadsheetTableModel) {
            super.setModel(model);
            SpreadsheetTableModel oldModel = this._model;
            this._model = (SpreadsheetTableModel)model;
            this._rowHeader.setRowCount(this._model.getRowCount());
            this.doSetColumnCount(oldModel.getColumnCount(), this._model.getColumnCount());
        } else {
            String msg = "Spreadsheet requires SpreadsheetTableModel";
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    protected void configureEnclosingScrollPane() {
        Container gp;
        super.configureEnclosingScrollPane();
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            scrollPane.setRowHeaderView(this.getRowHeader());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.showSelectionStatus();
        }
        super.valueChanged(e);
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.showSelectionStatus();
        }
        super.columnSelectionChanged(e);
    }

    private void showSelectionStatus() {
        int row = this.getSelectedRow();
        int col = this.getSelectedColumn();
        if (row < 0 || col < 0) {
            return;
        }
        if (row == this._lastRow && col == this._lastCol) {
            return;
        }
        this._lastRow = row;
        this._lastCol = col;
        Cell cell = this.getCellIfPresent(row, col);
        if (cell != null) {
            this.setStatus(cell.toString());
        } else {
            this.setStatus("cell(" + row + "," + col + ")");
        }
    }

    public class Reader
    extends DefaultHandler {
        StringBuffer buf = new StringBuffer();
        private Cell _crntCell;

        public void readSpreadsheet(InputStream is) throws IOException {
            try {
                this.createParser().parse(new InputSource(is));
            }
            catch (SAXException x) {
                IOException iox = new IOException(x.getMessage());
                iox.initCause(x);
                throw iox;
            }
            catch (ParserConfigurationException x) {
                IOException iox = new IOException(x.getMessage());
                iox.initCause(x);
                throw iox;
            }
        }

        public void startElement(String nsURI, String localname, String qname, Attributes attr) throws SAXException {
            if (qname.equals("hacksheet")) {
                String vers = attr.getValue("vers");
                int rows = Integer.parseInt(attr.getValue("rows"));
                int cols = Integer.parseInt(attr.getValue("cols"));
                SpreadsheetTableModel model = new SpreadsheetTableModel(rows, cols);
                SpreadsheetTableModel oldModel = Spreadsheet.this._model;
                Spreadsheet.this.setModel(model);
            } else if (qname.equals("cell")) {
                int row = Integer.parseInt(attr.getValue("row"));
                int col = Integer.parseInt(attr.getValue("col"));
                this._crntCell = new Cell(Spreadsheet.this, row, col);
                this._crntCell.setEditable(Boolean.valueOf(attr.getValue("editable")));
                String name = attr.getValue("id");
                if (name != null) {
                    this._crntCell.setName(name);
                }
            } else if (qname.equals("formula")) {
                this.buf.delete(0, this.buf.length());
            } else {
                throw new SAXException("unknown tag \"" + qname + "\"");
            }
        }

        public void endElement(String nsURI, String localname, String qname) throws SAXException {
            if (!qname.equals("hacksheet")) {
                if (qname.equals("cell")) {
                    Spreadsheet.this._model.setCell(this._crntCell);
                } else if (qname.equals("formula")) {
                    this._crntCell.setFormula(this.buf.toString());
                    this.buf.delete(0, this.buf.length());
                } else {
                    throw new SAXException("unknown tag \"" + qname + "\"");
                }
            }
        }

        public void characters(char[] ch, int start, int ln) throws SAXException {
            for (int i = 0; i < ln; ++i) {
                this.buf.append(ch[start + i]);
            }
        }

        public XMLReader createParser() throws SAXException, ParserConfigurationException {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setValidating(false);
            SAXParser saxParser = spf.newSAXParser();
            XMLReader xmlrd = saxParser.getXMLReader();
            xmlrd.setContentHandler(this);
            xmlrd.setErrorHandler(this);
            return xmlrd;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Writer {
        private TransformerHandler _handler;
        private Transformer _xformer;
        private Set<Cell> _cellsWritten;

        public Writer() throws IOException {
            try {
                SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
                this._handler = tf.newTransformerHandler();
                Transformer xformer = this._handler.getTransformer();
                xformer.setOutputProperty("encoding", "ISO-8859-1");
                xformer.setOutputProperty("indent", "yes");
            }
            catch (TransformerConfigurationException x) {
                IOException iox = new IOException(x.getMessage());
                iox.initCause(x);
                throw iox;
            }
        }

        public void writeSpreadsheet(OutputStream os) throws IOException {
            try {
                Object defaultValue;
                StreamResult stream = new StreamResult(os);
                this._handler.setResult(stream);
                this._handler.startDocument();
                AttributesImpl atts = new AttributesImpl();
                int rows = Spreadsheet.this.getRowCount();
                int cols = Spreadsheet.this.getColumnCount();
                atts.clear();
                atts.addAttribute("", "", "vers", "", "0.1.0");
                atts.addAttribute("", "", "rows", "", String.valueOf(rows));
                atts.addAttribute("", "", "cols", "", String.valueOf(cols));
                Class defaultType = Spreadsheet.this.getDefaultCellType();
                if (!defaultType.equals(Integer.class)) {
                    atts.addAttribute("", "", "defaultType", "", defaultType.getName());
                }
                if (!(defaultValue = Spreadsheet.this.getDefaultCellValue()).equals(0)) {
                    atts.addAttribute("", "", "defaultValue", "", Spreadsheet.this.getDefaultCellValue().toString());
                }
                this._handler.startElement("", "", "hacksheet", atts);
                this._cellsWritten = new HashSet<Cell>(Spreadsheet.this._model._cellmap.values().size() * 4 / 3);
                this.writeCells(Spreadsheet.this._model._cellmap.values().iterator());
                this._handler.endElement("", "", "hacksheet");
                this._handler.endDocument();
            }
            catch (SAXException x) {
                IOException iox = new IOException(x.getMessage());
                iox.initCause(x);
                throw iox;
            }
        }

        private void writeCells(Iterator<Cell> cells) throws SAXException {
            while (cells.hasNext()) {
                Cell cell = cells.next();
                if (this._cellsWritten.contains(cell)) continue;
                this.writeCells(cell.dependsOn());
                this.writeCell(cell);
            }
        }

        private void writeCell(Cell cell) throws SAXException {
            AttributesImpl atts = new AttributesImpl();
            String name = cell.getName();
            if (name != null && name.trim().length() != 0) {
                atts.addAttribute("", "", "id", "", cell.getName());
            }
            Point p = cell.getAddress();
            atts.addAttribute("", "", "row", "", String.valueOf(p.x));
            atts.addAttribute("", "", "col", "", String.valueOf(p.y));
            atts.addAttribute("", "", "type", "", cell.getType().getName());
            atts.addAttribute("", "", "editable", "", String.valueOf(cell.isEditable()));
            String formula = cell.getFormula();
            this._handler.startElement("", "", "cell", atts);
            atts.clear();
            this._handler.startElement("", "", "formula", atts);
            this._handler.characters(formula.toCharArray(), 0, formula.length());
            this._handler.endElement("", "", "formula");
            this._handler.endElement("", "", "cell");
            this._cellsWritten.add(cell);
        }
    }

    class Parser
    extends FunctorParser {
        private Cell _crntCell;

        private Parser() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Generator parseGenerator(Cell cell, String str) throws ParseException {
            this._crntCell = cell;
            try {
                Generator generator = super.parseGenerator(str);
                return generator;
            }
            finally {
                this._crntCell = null;
            }
        }

        public void bindThis(Object thisBinding) {
            super.bindThis(Spreadsheet.this);
        }

        protected FunctorRef resolveMethodName(FunctorRef prefix, String name, FunctorRef[] args) throws ParseException {
            if (prefix.getReferenceType() != -2) {
                return super.resolveMethodName(prefix, name, args);
            }
            if (((GeneratorRef)prefix).getFunctor().gen() != Spreadsheet.this) {
                return super.resolveMethodName(prefix, name, args);
            }
            return super.resolveMethodName(prefix, name, args);
        }

        protected FunctorRef reservedWord(String word) throws ParseException {
            if (word.equals("row")) {
                return new GeneratorRef(new Constant<Integer>(this._crntCell.getAddress().x), Integer.class);
            }
            if (word.equals("col")) {
                return new GeneratorRef(new Constant<Integer>(this._crntCell.getAddress().y), Integer.class);
            }
            return super.reservedWord(word);
        }

        protected FunctorRef reservedFunction(String name, FunctorRef[] args) throws ParseException {
            if (name.equals("cell")) {
                if (args.length == 1 && args[0] instanceof GeneratorRef && args[0].getReturnType().equals(String.class)) {
                    String refname = (String)((GeneratorRef)args[0]).getFunctor().gen();
                    Cell cell = Spreadsheet.this.getCellByName(refname);
                    if (cell == null) {
                        throw new ParseException("Unknown Cell Name: " + refname);
                    }
                    return new GeneratorRef(cell.getReference(), cell.getType());
                }
                if (!(args.length == 2 && args[0] instanceof GeneratorRef && args[1] instanceof GeneratorRef && args[0].getReturnType().equals(Integer.class) && args[1].getReturnType().equals(Integer.class))) {
                    throw new ParseException("Cell Reference requires row, col arguments");
                }
                int row = (Integer)((GeneratorRef)args[0]).getFunctor().gen();
                int col = (Integer)((GeneratorRef)args[1]).getFunctor().gen();
                Cell cell = Spreadsheet.this.getCellAt(row, col);
                return new GeneratorRef(cell.getReference(), cell.getType());
            }
            return super.reservedFunction(name, args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SpreadsheetTableModel
    extends AbstractTableModel
    implements Observer {
        static final long serialVersionUID = -6455541616661139146L;
        private Map<Point, Cell> _cellmap = new HashMap<Point, Cell>();
        private Map<String, Cell> _namemap = new HashMap<String, Cell>();
        private int _numRows;
        private int _numCols;
        private boolean _editableByDefault;

        public SpreadsheetTableModel() {
            this(16, 16);
        }

        public SpreadsheetTableModel(int rows, int cols) {
            this._numRows = rows;
            this._numCols = cols;
        }

        public void clear() {
            this._cellmap = new HashMap<Point, Cell>();
            this._namemap = new HashMap<String, Cell>();
            this.fireTableDataChanged();
        }

        public Cell getCellAt(int row, int col) throws IndexOutOfBoundsException {
            if (this.checkCellAddress(row, col)) {
                return this._cellmap.get(new Point(row, col));
            }
            if (row < 0 || row >= this._numRows) {
                String msg = "Row " + row + " out of range: 0.." + (this._numRows - 1);
                throw new IndexOutOfBoundsException(msg);
            }
            String msg = "Col " + col + " out of range: 0.." + (this._numCols - 1);
            throw new IndexOutOfBoundsException(msg);
        }

        private <T> Cell setCellAt(Class<T> type, Generator<T> gen, int row, int col) {
            Cell cell = this.getCellAt(row, col);
            if (cell != null) {
                throw new IllegalArgumentException(cell + " has already been set");
            }
            if (gen == null) {
                return null;
            }
            return this.setCell(new Cell(Spreadsheet.this, type, new Point(row, col), gen));
        }

        private Cell setCellAt(String formula, int row, int col, boolean editable) {
            Cell cell = this.getCellAt(row, col);
            if (cell != null) {
                throw new IllegalArgumentException(cell + " has already been set");
            }
            if (formula == null || "".equals(formula)) {
                return null;
            }
            return this.setCell(new Cell(Spreadsheet.this, new Point(row, col), formula, editable));
        }

        private Cell setCell(Cell cell) {
            String name = cell.getName();
            if (name != null) {
                if (this._namemap.get(name) != null) {
                    String err = "Duplicate cell name " + name;
                    throw new IllegalArgumentException(err);
                }
                this._namemap.put(name, cell);
            }
            cell.addObserver(this);
            Point p = cell.getAddress();
            this._cellmap.put(p, cell);
            this.fireTableCellUpdated(p.x, p.y);
            return cell;
        }

        private Cell getCellByName(String name) {
            return this._namemap.get(name);
        }

        private Cell setCellName(String name, int row, int col) {
            Cell cell;
            if (name != null && (cell = this._namemap.get(name)) != null) {
                String err = "Duplicate cell name " + name;
                throw new IllegalArgumentException(err);
            }
            cell = Spreadsheet.this.getCellAt(row, col);
            String oldname = cell.getName();
            if (oldname != null) {
                this._namemap.remove(oldname);
            }
            if (name != null) {
                this._namemap.put(name, cell);
            }
            cell.setName(name);
            return cell;
        }

        public <T> Generator<T> getReference(Class<T> type, int row, int col) {
            Cell cell = this.getCellAt(row, col);
            if (cell == null) {
                String msg = "Cell({0},{1}) is not yet defined";
                throw new IllegalArgumentException(MessageFormat.format(msg, row, col));
            }
            if (type.isAssignableFrom(cell.getType())) {
                return cell.getReference();
            }
            String err = "Cannot return reference of type {0} from {1}, whose type is {2}";
            String msg = MessageFormat.format(err, type, cell, cell.getType());
            throw new ClassCastException(msg);
        }

        private void setEditableByDefault(boolean b) {
            this._editableByDefault = b;
        }

        private boolean isEditableByDefault() {
            return this._editableByDefault;
        }

        public void setRowCount(int height) {
            int oldHeight = this._numRows;
            this._numRows = height;
            if (oldHeight < height) {
                this.fireTableRowsInserted(oldHeight, height - 1);
            } else {
                this.removeCells();
                this.fireTableRowsDeleted(height, oldHeight - 1);
            }
        }

        public void setColumnCount(int width) {
            int oldWidth = this._numCols;
            this._numCols = width;
            if (width < oldWidth) {
                this.removeCells();
            }
            this.fireTableStructureChanged();
        }

        private void removeCells() {
            Iterator<Cell> iter = this._cellmap.values().iterator();
            while (iter.hasNext()) {
                Cell cell = iter.next();
                Point p = cell.getAddress();
                if (p.x < this._numRows && p.y < this._numCols) continue;
                iter.remove();
                String name = cell.getName();
                if (name != null) {
                    this._namemap.remove(cell.getName());
                }
                cell.unlink();
            }
        }

        @Override
        public int getRowCount() {
            return this._numRows;
        }

        @Override
        public int getColumnCount() {
            return this._numCols;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (!this.checkCellAddress(row, col)) {
                return "### REF ###";
            }
            Cell cell = this._cellmap.get(new Point(row, col));
            if (cell == null) {
                return null;
            }
            Object obj = cell.getValue();
            return cell.isUndefined() ? "" : (cell.isValid() ? obj : cell.getErrorMsg());
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            Cell cell = this.getCellAt(row, col);
            if (cell != null) {
                cell.setValue(value);
            } else if (value != null) {
                this.setCellAt(value.toString(), row, col, true);
            }
            Spreadsheet.this.fireSpreadsheetUpdated();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            Cell cell = this.getCellAt(row, col);
            if (cell != null) {
                return cell.isEditable();
            }
            return this._editableByDefault;
        }

        @Override
        public void update(Observable observable, Object object) {
            Cell cell = (Cell)observable;
            Point addr = cell.getAddress();
            this.fireTableCellUpdated(addr.x, addr.y);
        }

        private boolean checkCellAddress(int row, int col) {
            return row >= 0 && row < this._numRows && col >= 0 && col < this._numCols;
        }
    }
}

