/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.swing.spreadsheet;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.ServiceManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.sf.jga.swing.spreadsheet.Application;
import net.sf.jga.swing.spreadsheet.Controller;
import net.sf.jga.swing.spreadsheet.Spreadsheet;

public class WebStart
extends Application {
    private FileContents _fc;

    public int loadFile(Spreadsheet sheet) {
        Controller controller = this.getController();
        try {
            FileOpenService fos = (FileOpenService)ServiceManager.lookup((String)"javax.jnlp.FileOpenService");
            if (fos == null) {
                return 2;
            }
            this._fc = fos.openFileDialog(null, null);
            if (this._fc == null) {
                return 2;
            }
            sheet.readSpreadsheet(this._fc.getInputStream());
            controller.setSheetSource(new URL("file:///" + this._fc.getName()));
            controller.setSheetDirty(false);
            return 0;
        }
        catch (Exception x) {
            this.displayError(x);
            return 2;
        }
    }

    public int saveFile(Spreadsheet sheet, boolean promptForName) {
        PipedInputStream pipeIn = null;
        PipedOutputStream pipeOut = null;
        try {
            FileSaveService fss = (FileSaveService)ServiceManager.lookup((String)"javax.jnlp.FileSaveService");
            if (fss == null) {
                return 2;
            }
            pipeIn = new PipedInputStream();
            pipeOut = new PipedOutputStream(pipeIn);
            Thread writeThread = new Thread(new Writer(sheet, pipeOut));
            writeThread.setDaemon(true);
            writeThread.start();
            Controller controller = this.getController();
            String hint = this.getClue(this._fc, controller.getSheetSource());
            this._fc = promptForName && this._fc != null ? fss.saveAsFileDialog(hint, new String[]{"hwks"}, this._fc) : fss.saveFileDialog(hint, new String[]{"hwks"}, (InputStream)pipeIn, hint);
            if (this._fc == null) {
                return 2;
            }
            controller.setSheetSource(new URL("file:///" + this._fc.getName()));
            controller.setSheetDirty(false);
            pipeIn.close();
            return 0;
        }
        catch (Exception x) {
            this.displayError(x);
            return 2;
        }
    }

    private String getClue(FileContents fc, URL source) {
        if (fc != null) {
            try {
                return fc.getName();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (source != null) {
            return source.getPath();
        }
        return "worksheet.hwks";
    }

    private synchronized void displayError(final Exception x) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WebStart.this.displayError(x);
                }
            });
        } else {
            Controller controller = this.getController();
            String msg = x.getMessage();
            if (msg == null || msg.length() == 0) {
                msg = Controller.getExceptionName(x);
            }
            controller.notify(msg, Controller.getExceptionName(x));
        }
    }

    public static void main(String[] args) {
        WebStart.printStartupHeader();
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception x) {
            System.err.println("Error loading L&F:" + x);
        }
        new WebStart();
    }

    private static void printStartupHeader() {
        System.out.println("");
        System.out.println("/**");
        System.out.println(" * A Java Hacker's Worksheet: JNLP Edition");
        System.out.println(" * Copyright (c) 2005  David A. Hall");
        System.out.println(" */");
        System.out.println("");
    }

    private class Writer
    implements Runnable {
        private PipedOutputStream _os;
        private Spreadsheet _sheet;

        public Writer(Spreadsheet sheet, PipedOutputStream os) {
            this._os = os;
            this._sheet = sheet;
        }

        public void run() {
            try {
                this._sheet.writeSpreadsheet(this._os);
            }
            catch (Exception x) {
                WebStart.this.displayError(x);
            }
            try {
                this._os.close();
            }
            catch (IOException x) {
                WebStart.this.displayError(x);
            }
        }
    }
}

