/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sf.jga.fn.BinaryFunctor;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.fn.algorithm.Accumulate;
import net.sf.jga.fn.algorithm.Count;
import net.sf.jga.fn.algorithm.Find;
import net.sf.jga.fn.algorithm.FindAdjacent;
import net.sf.jga.fn.algorithm.FindElement;
import net.sf.jga.fn.algorithm.FindMismatch;
import net.sf.jga.fn.algorithm.FindRepeated;
import net.sf.jga.fn.algorithm.FindSequence;
import net.sf.jga.fn.algorithm.ForEach;
import net.sf.jga.fn.algorithm.MaxValue;
import net.sf.jga.fn.algorithm.Merge;
import net.sf.jga.fn.algorithm.MinValue;
import net.sf.jga.fn.algorithm.RemoveAll;
import net.sf.jga.fn.algorithm.ReplaceAll;
import net.sf.jga.fn.algorithm.TransformBinary;
import net.sf.jga.fn.algorithm.TransformUnary;
import net.sf.jga.fn.algorithm.Unique;
import net.sf.jga.fn.arithmetic.Arithmetic;
import net.sf.jga.fn.arithmetic.ArithmeticFactory;
import net.sf.jga.fn.arithmetic.Plus;
import net.sf.jga.fn.comparison.EqualTo;
import net.sf.jga.fn.comparison.Equality;
import net.sf.jga.util.ComparableComparator;
import net.sf.jga.util.Iterators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Algorithms {
    public static <T> Iterator<T> find(Collection<? extends T> collection, T value) {
        return new Find<T>(value).fn(collection.iterator());
    }

    public static <T> Iterator<T> find(Collection<? extends T> collection, T value, Equality<T> eq) {
        return new Find<T>(eq, value).fn(collection.iterator());
    }

    public static <T> Iterator<T> find(Collection<? extends T> collection, UnaryFunctor<T, Boolean> eq) {
        return new Find<T>(eq).fn(collection.iterator());
    }

    public static <T> long count(Collection<? extends T> collection, T value) {
        return new Count<T>(value).fn(collection.iterator());
    }

    public static <T> long count(Collection<? extends T> collection, Equality<T> eq, T value) {
        return new Count<T>(eq, value).fn(collection.iterator());
    }

    public static <T> long count(Collection<? extends T> collection, UnaryFunctor<T, Boolean> eq) {
        return new Count<T>(eq).fn(collection.iterator());
    }

    public static <T> Iterator<T> findAdjacent(Collection<? extends T> collection) {
        return new FindAdjacent<T>().fn(collection.iterator());
    }

    public static <T> Iterator<T> findAdjacent(Collection<? extends T> c, BinaryFunctor<T, T, Boolean> bf) {
        return new FindAdjacent<T>(bf).fn(c.iterator());
    }

    public static <T> Iterator<T> findElement(Collection<? extends T> c, Collection<? extends T> desired) {
        return new FindElement<T>(desired).fn(c.iterator());
    }

    public static <T> Iterator<T> findElement(Collection<? extends T> c, Collection<? extends T> desired, BinaryFunctor<T, T, Boolean> eq) {
        return new FindElement<T>(desired, eq).fn(c.iterator());
    }

    public static <T> Iterator<T> match(Collection<? extends T> c, Collection<? extends T> pattern) {
        return new FindSequence<T>(pattern).fn(c.iterator());
    }

    public static <T> Iterator<T> match(Collection<? extends T> c, Collection<? extends T> pattern, BinaryFunctor<T, T, Boolean> eq) {
        return new FindSequence<T>(pattern, eq).fn(c.iterator());
    }

    public static <T> Iterator<T> mismatch(Collection<? extends T> c, Collection<? extends T> pattern) {
        return new FindMismatch<T>(pattern).fn(c.iterator());
    }

    public static <T> Iterator<T> mismatch(Collection<? extends T> c, Collection<? extends T> pattern, BinaryFunctor<T, T, Boolean> neq) {
        return new FindMismatch<T>(pattern, neq).fn(c.iterator());
    }

    public static <T> Iterator<T> findRepeated(Collection<? extends T> c, int n, T value) {
        return new FindRepeated<T>(n, value).fn(c.iterator());
    }

    public static <T> Iterator<T> findRepeated(Collection<? extends T> c, int n, T value, Equality<T> eq) {
        return new FindRepeated<T>(n, value, eq).fn(c.iterator());
    }

    public static <T> Iterator<T> findRepeated(Collection<? extends T> c, int n, UnaryFunctor<T, Boolean> eq) {
        return new FindRepeated<T>(n, eq).fn(c.iterator());
    }

    public static <T, R> UnaryFunctor<T, R> forEach(Collection<? extends T> c, UnaryFunctor<T, R> fn) {
        new ForEach<T, R>(fn).fn(c.iterator());
        return fn;
    }

    public static <T> boolean equal(Collection<? extends T> c1, Collection<? extends T> c2) {
        return new EqualTo().p(c1, c2);
    }

    public static <T> boolean equal(Collection<? extends T> c1, Collection<? extends T> c2, Comparator<T> comp) {
        return Iterators.equal(c1.iterator(), c2.iterator(), comp);
    }

    public static <T> boolean equal(Collection<? extends T> c1, Collection<? extends T> c2, BinaryFunctor<T, T, Boolean> eq) {
        return Iterators.equal(c1.iterator(), c2.iterator(), eq);
    }

    public static <T extends Comparable<? super T>> boolean lessThan(Collection<? extends T> c1, Collection<? extends T> c2) {
        return Iterators.lessThan(c1.iterator(), c2.iterator());
    }

    public static <T> boolean lessThan(Collection<? extends T> c1, Collection<? extends T> c2, Comparator<T> comp) {
        return Iterators.lessThan(c1.iterator(), c2.iterator(), comp);
    }

    public static <T> boolean lessThan(Collection<? extends T> c1, Collection<? extends T> c2, BinaryFunctor<T, T, Boolean> lt) {
        return Iterators.lessThan(c1.iterator(), c2.iterator(), lt);
    }

    public static <T extends Comparable<? super T>> Iterator<T> minimum(Collection<? extends T> c) {
        T min = Algorithms.minimumValue(c);
        return new Find<T>(min).fn(c.iterator());
    }

    public static <T> Iterator<T> minimum(Collection<? extends T> c, Comparator<T> comp) {
        T min = Algorithms.minimumValue(c, comp);
        return new Find<T>(min).fn(c.iterator());
    }

    public static <T> Iterator<T> minimum(Collection<? extends T> c, BinaryFunctor<T, T, T> bf) {
        T min = Algorithms.minimumValue(c, bf);
        return new Find<T>(min).fn(c.iterator());
    }

    public static <T extends Comparable<? super T>> T minimumValue(Collection<? extends T> c) {
        return (T)((Comparable)new MinValue<T>(new ComparableComparator()).fn(c));
    }

    public static <T> T minimumValue(Collection<? extends T> c, Comparator<T> comp) {
        return new MinValue<T>(comp).fn(c);
    }

    public static <T> T minimumValue(Collection<? extends T> c, BinaryFunctor<T, T, T> bf) {
        return new Accumulate<T>(bf).fn(c.iterator());
    }

    public static <T extends Comparable<? super T>> Iterator<T> maximum(Collection<? extends T> c) {
        T max = Algorithms.maximumValue(c);
        return new Find<T>(max).fn(c.iterator());
    }

    public static <T> Iterator<T> maximum(Collection<? extends T> c, Comparator<T> comp) {
        T max = Algorithms.maximumValue(c, comp);
        return new Find<T>(max).fn(c.iterator());
    }

    public static <T> Iterator<T> maximum(Collection<? extends T> c, BinaryFunctor<T, T, T> bf) {
        T max = Algorithms.maximumValue(c, bf);
        return new Find<T>(max).fn(c.iterator());
    }

    public static <T extends Comparable<? super T>> T maximumValue(Collection<? extends T> c) {
        return (T)((Comparable)new MaxValue<T>(new ComparableComparator()).fn(c));
    }

    public static <T> T maximumValue(Collection<? extends T> c, Comparator<T> comp) {
        return new MaxValue<T>(comp).fn(c);
    }

    public static <T> T maximumValue(Collection<? extends T> c, BinaryFunctor<T, T, T> fn) {
        return new Accumulate<T>(fn).fn(c.iterator());
    }

    public static <T extends Number> T accumulate(Class<T> numtype, Collection<T> c) {
        return Algorithms.accumulate(numtype, c, new Plus<T>(numtype));
    }

    public static <T extends Number> T accumulate(Class<T> numtype, Collection<T> c, BinaryFunctor<T, T, T> bf) {
        Arithmetic<T> _math = ArithmeticFactory.getArithmetic(numtype);
        if (_math == null) {
            throw new IllegalArgumentException();
        }
        return (T)((Number)new Accumulate<T>(_math.zero(), bf).fn(c.iterator()));
    }

    public static <T> T accumulate(Collection<T> c, T initial, BinaryFunctor<T, T, T> bf) {
        return new Accumulate<T>(initial, bf).fn(c.iterator());
    }

    public static <T> void transform(List<T> lin, UnaryFunctor<T, T> uf) {
        ListIterator<T> liter = lin.listIterator();
        while (liter.hasNext()) {
            liter.set(uf.fn(liter.next()));
        }
    }

    public static <T, R> void transformCopy(Collection<? extends T> cin, Collection<? super R> cout, UnaryFunctor<T, R> uf) {
        Algorithms.addAll(cout, new TransformUnary<T, R>(uf).fn(cin.iterator()));
    }

    public static <T1, T2, R> void transformCopy(Collection<? extends T1> c1, Collection<? extends T2> c2, Collection<? super R> cout, BinaryFunctor<T1, T2, R> bf) {
        TransformBinary<? extends T1, ? extends T2, R> xform = new TransformBinary<T1, T2, R>(bf);
        Algorithms.addAll(cout, xform.fn(c1.iterator(), c2.iterator()));
    }

    public static <T> void replaceAll(List<T> lin, UnaryFunctor<T, Boolean> uf, T value) {
        ListIterator<T> liter = lin.listIterator();
        while (liter.hasNext()) {
            if (!uf.fn(liter.next()).booleanValue()) continue;
            liter.set(value);
        }
    }

    public static <T, R> void replaceAllCopy(Collection<? extends T> cin, Collection<? super T> cout, UnaryFunctor<T, Boolean> test, T value) {
        Algorithms.addAll(cout, new ReplaceAll<T>(test, value).fn(cin.iterator()));
    }

    public static <T> void removeAll(List<? extends T> lin, T value) {
        Algorithms.removeAll(lin, new EqualTo().bind2nd(value));
    }

    public static <T> void removeAll(List<? extends T> lin, T value, Equality<T> eq) {
        Algorithms.removeAll(lin, eq.bind2nd(value));
    }

    public static <T> void removeAll(List<? extends T> lin, UnaryFunctor<T, Boolean> uf) {
        ListIterator<T> liter = lin.listIterator();
        while (liter.hasNext()) {
            if (!uf.fn(liter.next()).booleanValue()) continue;
            liter.remove();
        }
    }

    public static <T> void removeAllCopy(Collection<? extends T> cin, Collection<? super T> cout, T value) {
        Algorithms.addAll(cout, new RemoveAll<T>(value).fn(cin.iterator()));
    }

    public static <T> void removeAllCopy(Collection<? extends T> cin, Collection<? super T> cout, T value, Equality<T> eq) {
        Algorithms.addAll(cout, new RemoveAll<T>(eq, value).fn(cin.iterator()));
    }

    public static <T> void removeAllCopy(Collection<? extends T> cin, Collection<? super T> cout, UnaryFunctor<T, Boolean> eq) {
        Algorithms.addAll(cout, new RemoveAll<T>(eq).fn(cin.iterator()));
    }

    public static <T> void unique(List<? extends T> lin) {
        Algorithms.unique(lin, new EqualTo());
    }

    public static <T> void unique(List<? extends T> lin, BinaryFunctor<T, T, Boolean> eq) {
        ListIterator<T> liter = lin.listIterator();
        Object last = null;
        if (liter.hasNext()) {
            last = liter.next();
        }
        while (liter.hasNext()) {
            T next = liter.next();
            if (eq.fn(last, next).booleanValue()) {
                liter.remove();
                continue;
            }
            last = next;
        }
    }

    public static <T> void uniqueCopy(Collection<? extends T> cin, Collection<? super T> cout) {
        Algorithms.addAll(cout, new Unique<T>().fn(cin.iterator()));
    }

    public static <T> void uniqueCopy(Collection<? extends T> cin, Collection<? super T> cout, BinaryFunctor<T, T, Boolean> eq) {
        Algorithms.addAll(cout, new Unique<T>(eq).fn(cin.iterator()));
    }

    public static <T extends Comparable<? super T>> void mergeCopy(Collection<? extends T> cin1, Collection<? extends T> cin2, Collection<? super T> cout) {
        Algorithms.mergeCopy(cin1, cin2, cout, new ComparableComparator());
    }

    public static <T> void mergeCopy(Collection<? extends T> cin1, Collection<? extends T> cin2, Collection<? super T> cout, Comparator<T> comp) {
        Merge<? extends T> merger = new Merge<T>(comp);
        Algorithms.addAll(cout, merger.fn(cin1.iterator(), cin2.iterator()));
    }

    public static <T> boolean addAll(Collection<? super T> c, Iterator<T> iter) {
        boolean b = false;
        while (iter.hasNext()) {
            b |= c.add(iter.next());
        }
        return b;
    }
}

