/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.util;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayIterator<T>
implements ListIterator<T>,
Iterable<T> {
    private T[] _array;
    private int _idx;
    private Boolean _goingForward;

    public ArrayIterator(T[] array) {
        this._array = array;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this._idx < this._array.length;
    }

    @Override
    public boolean hasPrevious() {
        return this._idx > 0;
    }

    @Override
    public int nextIndex() {
        return this._idx;
    }

    @Override
    public int previousIndex() {
        return this._idx - 1;
    }

    @Override
    public T next() {
        if (this._idx >= this._array.length) {
            throw new NoSuchElementException();
        }
        this._goingForward = Boolean.TRUE;
        return this._array[this._idx++];
    }

    @Override
    public T previous() {
        if (this._idx <= 0) {
            throw new NoSuchElementException();
        }
        this._goingForward = Boolean.FALSE;
        return this._array[--this._idx];
    }

    @Override
    public void set(T value) {
        if (this._goingForward == null) {
            throw new IllegalStateException();
        }
        if (this._goingForward.booleanValue()) {
            this._array[this._idx - 1] = value;
        } else {
            this._array[this._idx] = value;
        }
    }

    @Override
    public void add(T value) {
        this._goingForward = null;
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove() {
        this._goingForward = null;
        throw new UnsupportedOperationException();
    }

    public static <E> ArrayIterator<E> iterate(E[] arr) {
        return new ArrayIterator<E>(arr);
    }
}

