/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.jga.util.EmptyIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingIterator<T>
implements Iterator<T>,
Iterable<T> {
    private Iterator<? extends T> _base;
    private Object[] _cache;
    private int _baseptr = 0;
    private int _cnt = 0;
    private int _size;

    public CachingIterator(Iterator<? extends T> base) {
        this(base, 1);
    }

    public CachingIterator(Iterator<? extends T> base, int max) {
        if (max <= 0) {
            throw new IllegalArgumentException();
        }
        this._base = base != null ? base : new EmptyIterator();
        this._size = max;
        this._cache = new Object[this._size];
    }

    public boolean hasCached(int n) {
        return n > 0 && n <= this._cnt;
    }

    public T cached(int n) {
        if (n <= 0 || n > this._cnt || n > this._size) {
            throw new NoSuchElementException();
        }
        return (T)this._cache[(this._baseptr + this._size - n) % this._size];
    }

    public int getCacheSize() {
        return this._size;
    }

    public int getCacheCount() {
        return this._cnt;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this._base.hasNext();
    }

    @Override
    public T next() {
        if (this._cnt < this._size) {
            ++this._cnt;
        }
        int n = this._baseptr++;
        this._baseptr %= this._size;
        this._cache[n] = this._base.next();
        return (T)this._cache[n];
    }

    @Override
    public void remove() {
        this._base.remove();
    }
}

