/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.util.EmptyIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindIterator<T>
implements Iterator<T>,
Iterable<T> {
    private T _next;
    private Iterator<? extends T> _base;
    private Boolean _baseHasNext;

    public FindIterator(Iterator<? extends T> iter) {
        this._base = iter != null ? iter : new EmptyIterator();
    }

    public boolean findNext(UnaryFunctor<T, Boolean> filter) {
        if (filter == null) {
            return this.hasNext();
        }
        if (this._baseHasNext != null) {
            if (this._baseHasNext.booleanValue()) {
                if (filter.fn(this._next).booleanValue()) {
                    return true;
                }
            } else {
                return false;
            }
        }
        while (this._base.hasNext()) {
            T elem = this._base.next();
            if (!filter.fn(elem).booleanValue()) continue;
            this._next = elem;
            this._baseHasNext = Boolean.TRUE;
            return true;
        }
        this._next = null;
        this._baseHasNext = Boolean.FALSE;
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this._baseHasNext != null) {
            return this._baseHasNext;
        }
        boolean b = this._base.hasNext();
        this._baseHasNext = b;
        if (b) {
            this._next = this._base.next();
        }
        return b;
    }

    @Override
    public T next() {
        if (this._baseHasNext == null ? !this.hasNext() : this._baseHasNext == false) {
            throw new NoSuchElementException();
        }
        T val = this._next;
        this._next = null;
        this._baseHasNext = null;
        return val;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

