/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import net.sf.jga.fn.BinaryFunctor;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.util.Algorithms;
import net.sf.jga.util.ArrayIterator;
import net.sf.jga.util.ComparableComparator;
import net.sf.jga.util.FilterIterator;
import net.sf.jga.util.FindAllIterator;
import net.sf.jga.util.MergeIterator;
import net.sf.jga.util.TransformAdjacentIterator;
import net.sf.jga.util.TransformBinaryIterator;
import net.sf.jga.util.TransformIterator;
import net.sf.jga.util.UniqueIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Iterables {
    public static <T> Iterable<Iterator<? extends T>> findAll(Iterable<? extends T> i, UnaryFunctor<Iterator<? extends T>, ? extends Iterator<T>> fn) {
        return new FindAllIterator<T>(i.iterator(), fn);
    }

    public static <T> Iterable<Iterator<? extends T>> findAll(T[] ts, UnaryFunctor<Iterator<? extends T>, ? extends Iterator<T>> fn) {
        return new FindAllIterator<T>(ArrayIterator.iterate(ts), fn);
    }

    public static <T> Iterable<T> filter(Iterable<? extends T> i, UnaryFunctor<T, Boolean> pred) {
        return new FilterIterator<T>(i.iterator(), pred);
    }

    public static <T> Iterable<T> filter(T[] ts, UnaryFunctor<T, Boolean> pred) {
        return new FilterIterator<T>(ArrayIterator.iterate(ts), pred);
    }

    public static <T extends Comparable<T>> Iterable<T> merge(Iterable<? extends T> i1, Iterable<? extends T> i2) {
        return new MergeIterator<T>(i1.iterator(), i2.iterator(), new ComparableComparator());
    }

    public static <T extends Comparable<T>> Iterable<T> merge(T[] ts1, T[] ts2) {
        return new MergeIterator<T>(ArrayIterator.iterate(ts1), ArrayIterator.iterate(ts2), new ComparableComparator());
    }

    public static <T> Iterable<T> merge(Iterable<? extends T> i1, Iterable<? extends T> i2, Comparator<T> comp) {
        return new MergeIterator<T>(i1.iterator(), i2.iterator(), comp);
    }

    public static <T> Iterable<T> merge(T[] ts1, T[] ts2, Comparator<T> comp) {
        return new MergeIterator<T>(ArrayIterator.iterate(ts1), ArrayIterator.iterate(ts2), comp);
    }

    public static <T> Iterable<T> merge(Iterable<? extends T> i1, Iterable<? extends T> i2, BinaryFunctor<T, T, Boolean> fn) {
        return new MergeIterator<T>(i1.iterator(), i2.iterator(), fn);
    }

    public static <T> Iterable<T> merge(T[] ts1, T[] ts2, BinaryFunctor<T, T, Boolean> fn) {
        return new MergeIterator<T>(ArrayIterator.iterate(ts1), ArrayIterator.iterate(ts2), fn);
    }

    public static <T, R> Iterable<R> transform(Iterable<? extends T> i, UnaryFunctor<T, R> fn) {
        return new TransformIterator<T, R>(i.iterator(), fn);
    }

    public static <T, R> Iterable<R> transform(T[] ts, UnaryFunctor<T, R> fn) {
        return new TransformIterator<T, R>(ArrayIterator.iterate(ts), fn);
    }

    public static <T1, T2, R> Iterable<R> transform(Iterable<? extends T1> i1, Iterable<? extends T2> i2, BinaryFunctor<T1, T2, R> fn) {
        return new TransformBinaryIterator<T1, T2, R>(i1.iterator(), i2.iterator(), fn);
    }

    public static <T1, T2, R> Iterable<R> transform(T1[] ts1, T2[] ts2, BinaryFunctor<T1, T2, R> fn) {
        return new TransformBinaryIterator<T1, T2, R>(ArrayIterator.iterate(ts1), ArrayIterator.iterate(ts2), fn);
    }

    public static <T, R> Iterable<R> transform(Iterable<? extends T> i, BinaryFunctor<T, T, R> fn) {
        return new TransformAdjacentIterator<T, R>(i.iterator(), fn);
    }

    public static <T, R> Iterable<R> transform(T[] ts, BinaryFunctor<T, T, R> fn) {
        return new TransformAdjacentIterator<T, R>(ArrayIterator.iterate(ts), fn);
    }

    public static <T> Iterable<T> unique(Iterable<? extends T> i) {
        return new UniqueIterator<T>(i.iterator());
    }

    public static <T> Iterable<T> unique(T[] ts) {
        return new UniqueIterator<T>(ArrayIterator.iterate(ts));
    }

    public static <T> Iterable<T> unique(Iterable<? extends T> i, BinaryFunctor<T, T, Boolean> eq) {
        return new UniqueIterator<T>(i.iterator(), eq);
    }

    public static <T> Iterable<T> unique(T[] ts, BinaryFunctor<T, T, Boolean> eq) {
        return new UniqueIterator<T>(ArrayIterator.iterate(ts), eq);
    }

    public static <T> boolean addAll(Collection<? super T> c, Iterable<T> iter) {
        return Algorithms.addAll(c, iter.iterator());
    }

    public static <T> boolean addAll(Collection<? super T> c, T[] ts) {
        return Algorithms.addAll(c, ArrayIterator.iterate(ts));
    }
}

