/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import net.sf.jga.fn.BinaryFunctor;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.fn.algorithm.Accumulate;
import net.sf.jga.fn.algorithm.Count;
import net.sf.jga.fn.algorithm.Find;
import net.sf.jga.fn.algorithm.FindAdjacent;
import net.sf.jga.fn.algorithm.FindElement;
import net.sf.jga.fn.algorithm.FindMismatch;
import net.sf.jga.fn.algorithm.FindRepeated;
import net.sf.jga.fn.algorithm.FindSequence;
import net.sf.jga.fn.algorithm.ForEach;
import net.sf.jga.fn.algorithm.Merge;
import net.sf.jga.fn.algorithm.RemoveAll;
import net.sf.jga.fn.algorithm.ReplaceAll;
import net.sf.jga.fn.algorithm.TransformBinary;
import net.sf.jga.fn.algorithm.TransformUnary;
import net.sf.jga.fn.algorithm.Unique;
import net.sf.jga.fn.arithmetic.Arithmetic;
import net.sf.jga.fn.arithmetic.ArithmeticFactory;
import net.sf.jga.fn.arithmetic.Minus;
import net.sf.jga.fn.arithmetic.Plus;
import net.sf.jga.fn.comparison.EqualTo;
import net.sf.jga.fn.comparison.Equality;
import net.sf.jga.fn.comparison.Less;
import net.sf.jga.fn.comparison.Max;
import net.sf.jga.fn.comparison.Min;
import net.sf.jga.util.ComparableComparator;
import net.sf.jga.util.FilterIterator;
import net.sf.jga.util.FindIterator;
import net.sf.jga.util.IteratorComparator;
import net.sf.jga.util.LookAheadIterator;
import net.sf.jga.util.MergeIterator;
import net.sf.jga.util.TransformAdjacentIterator;
import net.sf.jga.util.TransformIterator;
import net.sf.jga.util.UniqueIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Iterators {
    public static <T> FindIterator<T> find(Iterator<? extends T> iterator, T value) {
        return new Find<T>(value).fn(iterator);
    }

    public static <T> FindIterator<T> find(Iterator<? extends T> iterator, T value, Equality<T> eq) {
        return new Find<T>(eq, value).fn(iterator);
    }

    public static <T> FindIterator<T> find(Iterator<? extends T> iterator, UnaryFunctor<T, Boolean> eq) {
        return new Find<T>(eq).fn(iterator);
    }

    public static <T> long count(Iterator<? extends T> iterator, T value) {
        return new Count<T>(value).fn(iterator);
    }

    public static <T> long count(Iterator<? extends T> iterator, Equality<T> eq, T value) {
        return new Count<T>(eq, value).fn(iterator);
    }

    public static <T> long count(Iterator<? extends T> iterator, UnaryFunctor<T, Boolean> eq) {
        return new Count<T>(eq).fn(iterator);
    }

    public static <T> LookAheadIterator<T> findAdjacent(Iterator<? extends T> iterator) {
        return new FindAdjacent<T>().fn(iterator);
    }

    public static <T> LookAheadIterator<T> findAdjacent(Iterator<? extends T> iterator, BinaryFunctor<T, T, Boolean> bf) {
        return new FindAdjacent<T>(bf).fn(iterator);
    }

    public static <T> FindIterator<T> findElement(Iterator<? extends T> iterator, Collection<? extends T> desired) {
        return new FindElement<T>(desired).fn(iterator);
    }

    public static <T> FindIterator<T> findElement(Iterator<? extends T> iter, Collection<? extends T> coll, BinaryFunctor<T, T, Boolean> eq) {
        return new FindElement<T>(coll, eq).fn(iter);
    }

    public static <T> LookAheadIterator<T> match(Iterator<? extends T> iterator, Collection<? extends T> pattern) {
        return new FindSequence<T>(pattern).fn(iterator);
    }

    public static <T> LookAheadIterator<T> match(Iterator<? extends T> iterator, Collection<? extends T> pattern, BinaryFunctor<T, T, Boolean> eq) {
        return new FindSequence<T>(pattern, eq).fn(iterator);
    }

    public static <T> LookAheadIterator<T> mismatch(Iterator<? extends T> iterator, Collection<? extends T> pattern) {
        return new FindMismatch<T>(pattern).fn(iterator);
    }

    public static <T> LookAheadIterator<T> mismatch(Iterator<? extends T> iterator, Collection<? extends T> pattern, BinaryFunctor<T, T, Boolean> neq) {
        return new FindMismatch<T>(pattern, neq).fn(iterator);
    }

    public static <T> LookAheadIterator<T> findRepeated(Iterator<? extends T> iterator, int n, T value) {
        return new FindRepeated<T>(n, value).fn(iterator);
    }

    public static <T> LookAheadIterator<T> findRepeated(Iterator<? extends T> iterator, int n, T value, Equality<T> eq) {
        return new FindRepeated<T>(n, value, eq).fn(iterator);
    }

    public static <T> LookAheadIterator<T> findRepeated(Iterator<? extends T> iterator, int n, UnaryFunctor<T, Boolean> eq) {
        return new FindRepeated<T>(n, eq).fn(iterator);
    }

    public static <T, R> UnaryFunctor<T, R> forEach(Iterator<? extends T> iterator, UnaryFunctor<T, R> fn) {
        new ForEach<T, R>(fn).fn(iterator);
        return fn;
    }

    public static <T extends Comparable<? super T>> boolean equal(Iterator<? extends T> iterator1, Iterator<? extends T> iterator2) {
        return Iterators.equal(iterator1, iterator2, new ComparableComparator());
    }

    public static <T> boolean equal(Iterator<? extends T> iterator1, Iterator<? extends T> iterator2, Comparator<T> comp) {
        IteratorComparator<T> comp2 = new IteratorComparator<T>(comp);
        EqualTo<T> eq = new EqualTo<T>(comp2);
        return eq.p(iterator1, iterator2);
    }

    public static <T> boolean equal(Iterator<? extends T> iter1, Iterator<? extends T> iter2, BinaryFunctor<T, T, Boolean> eq) {
        while (iter1.hasNext() && iter2.hasNext()) {
            if (eq.fn(iter1.next(), iter2.next()).booleanValue()) continue;
            return false;
        }
        return iter1.hasNext() == iter2.hasNext();
    }

    public static <T extends Comparable<? super T>> boolean lessThan(Iterator<? extends T> iter1, Iterator<? extends T> iter2) {
        ComparableComparator comp1 = new ComparableComparator();
        IteratorComparator comp2 = new IteratorComparator(comp1);
        return new Less(comp2).p(iter1, iter2);
    }

    public static <T> boolean lessThan(Iterator<? extends T> iter1, Iterator<? extends T> iter2, Comparator<T> comp) {
        IteratorComparator<T> comp2 = new IteratorComparator<T>(comp);
        return new Less<T>(comp2).p(iter1, iter2);
    }

    public static <T> boolean lessThan(Iterator<? extends T> i1, Iterator<? extends T> i2, final BinaryFunctor<T, T, Boolean> lt) {
        IteratorComparator comp = new IteratorComparator(new Comparator<T>(){

            @Override
            public int compare(T x, T y) {
                return (Boolean)lt.fn(x, y) != false ? -1 : ((Boolean)lt.fn(y, x) != false ? 1 : 0);
            }
        });
        return new Less(comp).p(i1, i2);
    }

    public static <T extends Comparable<? super T>> T minimumValue(Iterator<? extends T> iterator) {
        return (T)((Comparable)Iterators.minimumValue(iterator, new Min(new ComparableComparator())));
    }

    public static <T> T minimumValue(Iterator<? extends T> iterator, Comparator<T> comp) {
        return Iterators.minimumValue(iterator, new Min<T>(comp));
    }

    public static <T> T minimumValue(Iterator<? extends T> iterator, BinaryFunctor<T, T, T> bf) {
        return new Accumulate<T>(bf).fn(iterator);
    }

    public static <T extends Comparable<? super T>> T maximumValue(Iterator<? extends T> iterator) {
        return (T)((Comparable)Iterators.maximumValue(iterator, new Max(new ComparableComparator())));
    }

    public static <T> T maximumValue(Iterator<? extends T> iterator, Comparator<T> comp) {
        return Iterators.maximumValue(iterator, new Max<T>(comp));
    }

    public static <T> T maximumValue(Iterator<? extends T> iterator, BinaryFunctor<T, T, T> bf) {
        return new Accumulate<T>(bf).fn(iterator);
    }

    public static <T extends Number> T accumulate(Class<T> numtype, Iterator<T> iterator) {
        return Iterators.accumulate(numtype, iterator, new Plus<T>(numtype));
    }

    public static <T extends Number> T accumulate(Class<T> numtype, Iterator<T> iterator, BinaryFunctor<T, T, T> bf) {
        Arithmetic<T> _math = ArithmeticFactory.getArithmetic(numtype);
        if (_math == null) {
            throw new IllegalArgumentException();
        }
        return (T)((Number)new Accumulate<T>(_math.zero(), bf).fn(iterator));
    }

    public static <T> T accumulate(Iterator<T> iterator, T initial, BinaryFunctor<T, T, T> bf) {
        return new Accumulate<T>(initial, bf).fn(iterator);
    }

    public static <T, R> TransformIterator<T, R> transform(Iterator<? extends T> iter, UnaryFunctor<T, R> uf) {
        return new TransformUnary<T, R>(uf).fn(iter);
    }

    public static <T1, T2, R> Iterator<R> transform(Iterator<? extends T1> i1, Iterator<? extends T2> i2, BinaryFunctor<T1, T2, R> bf) {
        return new TransformBinary<T1, T2, R>(bf).fn(i1, i2);
    }

    public static <T> Iterator<T> replaceAll(Iterator<? extends T> iter, UnaryFunctor<T, Boolean> test, T value) {
        return new ReplaceAll<T>(test, value).fn(iter);
    }

    public static <T> FilterIterator<T> removeAll(Iterator<? extends T> iterator, T value) {
        return new RemoveAll<T>(value).fn(iterator);
    }

    public static <T> FilterIterator<T> removeAll(Iterator<? extends T> iterator, T value, Equality<T> eq) {
        return new RemoveAll<T>(eq, value).fn(iterator);
    }

    public static <T> FilterIterator<T> removeAll(Iterator<? extends T> iterator, UnaryFunctor<T, Boolean> eq) {
        return new RemoveAll<T>(eq).fn(iterator);
    }

    public static <T> UniqueIterator<T> unique(Iterator<? extends T> iterator) {
        return new Unique<T>().fn(iterator);
    }

    public static <T> UniqueIterator<T> unique(Iterator<? extends T> iterator, BinaryFunctor<T, T, Boolean> eq) {
        return new Unique<T>(eq).fn(iterator);
    }

    public static <T extends Comparable<? super T>> MergeIterator<T> merge(Iterator<? extends T> iter1, Iterator<? extends T> iter2) {
        return new Merge<T>(new ComparableComparator()).fn(iter1, iter2);
    }

    public static <T> MergeIterator<T> merge(Iterator<? extends T> iter1, Iterator<? extends T> iter2, Comparator<T> comp) {
        return new Merge<T>(comp).fn(iter1, iter2);
    }

    public static <T extends Number> TransformAdjacentIterator<T, T> adjacentDiff(Class<T> type, Iterator<? extends T> iter) {
        return new TransformAdjacentIterator(iter, new Minus<T>(type));
    }
}

